package com.gtis.archive.web;

import com.gtis.archive.core.web.BaseEntityAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.service.ArchiveService;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-10-13
 */
public class DocEntityAction extends BaseEntityAction<Document> {
    @Autowired
    private ArchiveService archiveService;

    /**
     * 档案id
     */
    private String archiveId;

    public void prepare() {
        if (StringUtils.isBlank(id)) {
            entity = archiveService.newDocument(modelName);
            String cid = (String) session.get("currentDId");
            Document lastDocument = null;
            if (cid != null) {
                lastDocument = archiveService.getDocument(modelName, cid);
            }
            if (lastDocument != null) {
                try {
                    PropertyUtils.copyProperties(entity, lastDocument);
                    entity.setSxh(entity.getSxh()+1);
                } catch (Exception ignored) {
                }
                entity.setId(null);
            }
        } else {
            entity = archiveService.getDocument(modelName, id);
            if(archiveId==null)
                archiveId=entity.getArchiveId();
        }
        if(entity!=null&&archiveId!=null){
            try{
                Archive archive = archiveService.getArchive(modelName,archiveId);
                entity.setArchive(archive);
                entity.setQzh(archive.getQzh());
                entity.setMlh(archive.getMlh());
                entity.setAjh(archive.getAjh());
            } catch(Exception ex){
                logger.debug(ex.toString());
            }
        }
    }

    @Override
    protected void doSave(Document entity) {
        archiveService.saveDocument(entity);
    }

    @Override
    protected String getJsCallBack() {
        return "onDocumentComplete";
    }

    @Override
    protected void afterSave() {
        session.put("currentDId", entity.getId());
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }


}
