package com.gtis.archive.service;

import com.gtis.archive.entity.AjhRange;
import com.gtis.archive.entity.Archive;
import com.gtis.common.Page;
import org.hibernate.criterion.Order;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

/**
 * 案卷号管理接口.
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-10-13
 */
public interface AjhRangeService {
    /**
     * 案卷号范围
     *
     * @param id 案卷号Id
     * @return 案卷号范围
     */
    AjhRange getAjhRange(String id);

    /**
     * 根据目录号获取模型名
     *
     * @param mlh mlh
     * @return 模型名
     */
    String getModelNameByMlh(String mlh);

    /**
     * get model name
     *
     * @param modelName modelname
     * @return AjhRange list
     */
    List<AjhRange> getAjhRangeByModelName(String modelName);

    /**
     *  根据模型名称和卷内目录类型进行获取
     * @param modelName
     * @param term
     * @return
     */
    List<AjhRange> getAjhRangeByModelNameAndTerm(String modelName,String term);

    /**
     *
     */

    /**
     * get available ajh count map
     *
     * @return ajh count map
     */
    Map<String, Integer> getAvailableAjhCountMap();

    /**
     * 根据单位代码获取所有可用案卷号
     * @return
     */
    Map<String,Integer> getAvailableAjhCountMapByDwdm(String dwdm);

    /**
     * get available ajhRange
     *
     * @param modelName modelName
     * @return ajhRange
     */
    AjhRange getAvailableAjhRange(String modelName);

    /**
     * 对含有卷内目录类型的调用此接口
     * @param modelName
     * @param archive
     * @return
     */
    AjhRange getAvailableAjhRange(String modelName, Archive archive) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException;

    /**
     * 获取模型对应单位代码可以用的案卷号
     *
     * @param modelName
     * @param dwdm
     * @return
     */
    AjhRange getAvailableAjhRangeByDwdm(String modelName, String dwdm);

    /**
     * 获取模型对应mlh下可用的案卷号
     *
     * @param modelName
     * @param mlh
     * @return
     */
    AjhRange getAvailableAjhRange(String modelName, String mlh);


    /**
     * 获取对应目录号
     *
     * @param modelName
     * @param dwdm
     * @param mlh
     * @return
     */
    AjhRange getAvailableAjhRange(String modelName, String dwdm, String mlh);

    /**
     * remove a ajhrange
     *
     * @param id id
     */
    void removeAjhRange(String id);

    /**
     * save ajhRange
     *
     * @param ajhRange ajhRange
     * @return ajhRange
     */
    AjhRange saveAjhRange(AjhRange ajhRange);

    /**
     * 获取指定页案卷号
     *
     * @param start
     * @param limit
     * @param order
     * @return
     */
    Page<AjhRange> getAjhRanges(int start, int limit, Order[] order);


    /**
     * 胡群殴案卷号按将目录号转为数字型排序
     * @param start
     * @param limit
     * @param order
     * @return
     */
    Page<AjhRange> getAjhRangesOrderMlh(int start,int limit,String order);





    /**
     * 通用管理中获取案卷号，不做是否可用判断
     * @param modelName
     * @param mlh
     * @return
     */
    AjhRange getAjhRangesForGeneric(String modelName, String mlh);


    List getMlhByModelName(String modelName);

    List getMlh(String modelName,String dwdm);

    /**
     * 江阴根据保管期限获取对应的案卷号
      * @param modelName
     * @param bgqx
     * @return
     */
    AjhRange getAjhRangesByBgqx(String modelName,String bgqx);

    /**
     * 同一个单位代码下是否存在mlh相同的ajhRange
     * @param mlh
     * @param dwdm
     * @param id
     * @return
     */
    boolean  exist(String mlh,String dwdm,String id);

    /**
     * 获取当前的顺序号
     * @param modelName
     * @param dwdm
     * @return
     */
    int getCurrentSxh(String modelName,String dwdm);

    /**
     * 根据模型名称，单位代码，顺序号相同的个数
     * @param modelName
     * @param dwdm
     * @param orderNumber
     * @return
     */
    boolean searchAjhRange(String modelName,String dwdm,int orderNumber,String id);


    /**
     * 根据年度和保管期限检索
     * @param modelName
     * @param bgqx
     * @param nd
     * @return
     */
    AjhRange getAjhRangeByNdBgqx(String modelName,String bgqx,String nd);


    /**
     * 根据年度模型名称获取可用的ajhRange
     * @param modelName
     * @param nd
     * @return
     */
    AjhRange getAvailableAjhRangByNd(String modelName,String nd);


    /**
     * 根据目录号获取，不区分单位代码
     * @param modelName
     * @param mlh
     * @return
     */
    AjhRange getAvailableAjhRangeByMlh(String modelName,String mlh);

    /**
     * 获取可用目录号，剔除mlh，不区分单位代码
     * @param modelName
     * @param mlh  剔除的mlh
     * @return 剔除后可用的目录号
     */
    AjhRange getAvailableAjhRangeNo(String modelName,String mlh,String nd);

    /**
     * 根据term查找目录号，区分单位代码
     * @param modelName
     * @param term
     * @return
     */
    AjhRange getAvailableAjhRangeByLb(String modelName,String term);

    /**
     * 金坛财务档案获取目录号
     * @param modelName
     * @param isPz    是否为凭证类别，明细和现金共用一个目录号，凭证则独立分配目录号
     * @param nd       年度
     * @param term    财务类型
     * @return
     */
    AjhRange getAvailableAjhRange(String modelName,boolean isPz,String nd,String term);

    /**
     * 句容根据卷内目录类型获取
     * @param modelName
     * @param jnmllx
     * @return
     */
    AjhRange getAvaliableAjhRangeByJnmllx(String modelName, String jnmllx);


}
