package com.gtis.archive.entity;

import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.List;

/**
 * 资源
 * <p/>
 * Generated 2010-08-13 13:26:31 by Model Code Generater 1.0
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_resource")
public class Resource implements Cloneable {
    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String id;

    /**
     * 名称
     */
    @Column(length = 100, nullable = false)
    private String name;

    /**
     * 标题
     */
    @Column(length = 100)
    private String title;

    /**
     * 内容
     */
    @Column(length = 4000)
    private String content;

    /**
     * 父资源序号
     */
    @Column(length = 32)
    private String parentId;

    /**
     * 顺序号
     */
    @Column(nullable = false)
    private int orderNumber;

    /**
     * 是否有效
     */
    @Column(nullable = false)
    private boolean enabled = true;

    /**
     * 分类号
     */
    @Column(length = 100)
    private String flh;


    @Transient
    private List<Resource> children;

    public List<Resource> getChildren() {
        return children;
    }

    public void setChildren(List<Resource> children) {
        this.children = children;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getOrderNumber() {
        return orderNumber;
    }

    public void setOrderNumber(int orderNumber) {
        this.orderNumber = orderNumber;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getFlh() {
        return flh;
    }

    public void setFlh(String flh) {
        this.flh = flh;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Resource && id != null && name.equals(((Resource) obj).getId());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public int hashCode() {
        return id.hashCode();
    }

    @Override
    public String toString() {
        return "[" + id + "," + name + "]";
    }
}