package com.gtis.archive.entity;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
* <p>
    * 档案附属信息
    * Generated 2012-5-17 17:30:16 by Model Code Generater 1.0
    * </p>
*
* @author <a href="mailto:lanxy88@gmail.com">NelsonX</a>
*/
@Entity
@Table(name = "t_archvieinfo")
@Inheritance(strategy = InheritanceType.JOINED)
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class ArchiveInfo {

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String id;

    /**
    * 档案序号 
    */
    @Column(length = 32, nullable = false)
    private String archiveId;

    /**
     * 档案模型
     */
    @Column(length = 100, nullable = false)
    private String archiveModel;

    @Transient
    private Archive archive;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getArchiveId() {
        return archiveId;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public String getArchiveModel() {
        return archiveModel;
    }

    public void setArchiveModel(String archiveModel) {
        this.archiveModel = archiveModel;
    }

    public Archive getArchive() {
        return archive;
    }

    public void setArchive(Archive archive) {
        this.archive = archive;
    }
}