package com.gtis.archive.core.web;

import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.ex.EntityParameterException;
import com.gtis.archive.core.support.freemarker.DictModel;
import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.Preparable;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.interceptor.SessionAware;
import org.springframework.beans.factory.annotation.Autowired;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

/**
 * 实体对象管理基础action.
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-12-1
 */
public class BaseEntityAction<T> extends BaseAction implements ModelDriven<T>, Preparable, SessionAware {
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected EntityService entityService;
    @Autowired
    protected DictService dictService;
    /**
     * 模型名
     */
    protected String modelName;
    /**
     * 主键
     */
    protected String id;
    /**
     * 实体对象
     */
    protected T entity;
    /**
     * session
     */
    protected Map<String, Object> session;

    public BaseEntityAction() {
        Type genType = getClass().getGenericSuperclass();
        if (genType instanceof ParameterizedType) {
            Type params = (((ParameterizedType) genType).getActualTypeArguments())[0];
            if (params instanceof Class) {
                setModelName(((Class) params).getSimpleName());
            }
        }
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSession(Map<String, Object> session) {
        this.session = session;
    }

    public String getModelName() {
        return modelName;
    }

    /**
     * 获取实体对象模型
     *
     * @return 实体对象模型
     */
    public Model getEntityModel() {
        return modelService.getModel(modelName);
    }

    /**
     * 获取字段列表
     *
     * @return 字段列表
     */
    public Map<String, Field> getFields() {
        return getEntityModel().getInheritfieldsMap();
    }

    /**
     * 获取字典
     *
     * @return 字典
     */
    public DictModel get_dict() {
        return new DictModel(dictService);
    }

    public T getModel() {
        if (entity == null)
            prepare();
        return entity;
    }

    public void prepare() {
        entity = StringUtils.isBlank(id) ? entityService.<T>newInstance(modelName) : entityService.<T>load(modelName, id);
    }

    @Override
    public String execute() throws Exception {
        return renderModelTemplate("edit");
    }

    public String input() throws Exception {
        throw new EntityParameterException(getModel().getClass());
    }

    public String preview() throws Exception {
        return renderModelTemplate("preview");
    }

    public String save() throws Exception {
        return renderJs(new Runner() {
            public void run() {
                preSave();
                doSave(entity);
                afterSave();
            }
        }, getSuccessMsg() , null, getJsCallBack());
    }

    protected void preSave() {
    }

    protected void afterSave() {

    }

    protected void doSave(T entity){
        entityService.save(entity);
    }
    
    protected String getSuccessMsg(){
        return "保存成功";
    }

    protected String getJsCallBack() {
        return null;
    }

    protected String getEntityTemplate(String name) {
        return getEntityModel().getTemplate(name);
    }

    protected String renderModelTemplate(String name) throws Exception {
        return renderTemplate(getEntityTemplate(name));
    }
}
