package com.gtis.archive.web.admin;

import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelManager;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.entity.AjhRange;
import com.gtis.archive.service.AjhRangeService;
import com.gtis.archive.service.ExtTreeService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-10-13
 */
@Results({@Result(name = "toList", location = "ajh!list.action?modelName=${modelName}", type = "redirect")})
public class AjhAction extends ActionSupport {
    private static final long serialVersionUID = 7582278548353967361L;
    private String id;
    private String modelName;
    private AjhRange ajhRange;
    private List<AjhRange> ajhRanges;
    private Map<String, Integer> modelsMap;
    private Map<String,String> modelAliasMap;
    private Map<String,String> flMap;
    private String msg;

    private String mlh;
    private String dm;

    private  List<String> bgqxs;//保管期限

    private  List<String> lbs;//实物类别，金坛实物档案



    @Autowired
    private ModelManager modelService;

    @Autowired
    private AjhRangeService ajhRangeService;

    @Autowired
    private SysUserService userService;

    @Autowired
    private ExtTreeService treeService;

    @Autowired
    protected DictService dictService;


    public String getMlh() {
        return mlh;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public String getDm() {
        return dm;
    }

    public void setDm(String dm) {
        this.dm = dm;
    }

    public AjhRange getAjhRange() {
        return ajhRange;
    }

    public void setAjhRange(AjhRange ajhRange) {
        this.ajhRange = ajhRange;
    }

    public List<AjhRange> getAjhRanges() {
        return ajhRanges;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModelName() {
        return modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public Map<String, Integer> getModelsMap() {
        return modelsMap;
    }
    
    public Map<String,String> getModelAliasMap(){
        return modelAliasMap;
    }

    public Map<String, String> getFlMap() {
        return flMap;
    }

    public String getMsg() {
        return msg;
    }


    public List<String> getBgqxs() {
        List<Item> items=dictService.getItems(Constants.BGQX);
        bgqxs=new ArrayList<String>();
        for (Item item:items){
            bgqxs.add(item.getValue());
        }
        return bgqxs;
    }

    public List<String> getLbs() {
        List<Item> items=dictService.getItems(Constants.LB);
        lbs=new ArrayList<String>();
        for (Item item:items){
            lbs.add(item.getValue());
        }
        return lbs;
    }

    @Override
    public String execute() throws Exception {
        modelsMap = new LinkedHashMap<String, Integer>();
        modelAliasMap = new HashMap<String, String>();
        Map<String, Integer> map;
        if((EnvHolder.isEnable(Switch.JURONG)||EnvHolder.isEnable(Switch.JIN_TAN))&&EnvHolder.isEnable(Switch.DWDM)&&!SessionUtil.getCurrentUser().isAdmin()){
           map=ajhRangeService.getAvailableAjhCountMapByDwdm(getDwdm());
        }else {
            map = ajhRangeService.getAvailableAjhCountMap();
        }
        if(EnvHolder.isEnable(Switch.JIANGYIN)){
            flMap=new HashMap<String, String>();
            List<Map<String, Object>> temp= treeService.getTree(null, Constants.MODEL_ROOT);
            for(Map<String, Object> parentNode:temp){
                String fl= parentNode.get("text").toString();
                    ArrayList<Map<String, Object>> children= (ArrayList<Map<String, Object>>) parentNode.get("children");
                    for(Map<String, Object> model:children) {
                        Model tempModel=modelService.getModelAllowNull(model.get("name").toString());
                        if(tempModel!=null){
                            modelsMap.put(tempModel.getName(), map.get(tempModel.getName()));
                            modelAliasMap.put(tempModel.getName(),tempModel.getTitle());
                            flMap.put(tempModel.getName(),fl);
                        }
                    }
            }
        }else{
            for (Model model : modelService.getModels()) {
                if ("Archive".equals(model.getParentName())) {
                    modelsMap.put(model.getName(), map.get(model.getName()));
                    modelAliasMap.put(model.getName(),model.getTitle());
                } else if(EnvHolder.isEnable(Switch.JIANGYIN) && model.getParentName()==null){
                    modelsMap.put(model.getName(), map.get(model.getName()));
                    modelAliasMap.put(model.getName(),model.getTitle());
                }
            }
        }
        return super.execute();
    }

    public String edit() throws Exception {
        if (ajhRange == null) {
            if (StringUtils.isNotBlank(id)) {
                ajhRange = ajhRangeService.getAjhRange(id);
                modelName = ajhRange.getModelName();
            } else {
                ajhRange = new AjhRange();
                ajhRange.setModelName(modelName);
            }
        } else {
            if (ajhRange.getCurrentValue() < ajhRange.getMinValue())
                ajhRange.setCurrentValue(ajhRange.getMinValue());
            if (StringUtils.isBlank(ajhRange.getId())) {
                ajhRange.setId(null);
            }

            if(EnvHolder.isEnable(Switch.JIN_TAN)){
                if(!"Swda".equals(modelName)){
                    if(ajhRangeService.exist(ajhRange.getMlh(),ajhRange.getDwdm(),ajhRange.getId())){
                        msg="exist";
                        return "edit";
                    }
                }
                if(ajhRangeService.searchAjhRange(modelName,ajhRange.getDwdm(),ajhRange.getOrderNumber(),ajhRange.getId())){
                    msg="orderNumberExist";
                    return "edit";
                }
            }

            if(EnvHolder.isEnable(Switch.DWDM)&&ajhRange.getDwdm()==null) {
                if(EnvHolder.isEnable(Switch.JIN_TAN)&&(("Jhcw").equals(modelName)||"Swda".equals(modelName))){

                }else{
                    ajhRange.setDwdm(getDwdm());
                }
            }
            ajhRangeService.saveAjhRange(ajhRange);
            msg = "successed";
        }
        return "edit";
    }

    public String getTab() {
        return "ajh";
    }

    public String list() throws Exception {
        ajhRanges = ajhRangeService.getAjhRangeByModelName(modelName);
        return "list";
    }

    public String remove() throws Exception {
        ajhRangeService.removeAjhRange(id);
        return "toList";
    }

    /**
     * 获取当前对应单位代码
     * @return
     */
    public String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }

    public String validateMlh(){
        if(EnvHolder.isEnable(Switch.JIN_TAN)&&modelName.equals("Swda")){
            Struts2Utils.renderJson("false");
            return null;//金坛实物档案不做重复验证
        }

        if(ajhRangeService.exist(mlh,dm,id)){
            Struts2Utils.renderJson("true");
        }else{
            Struts2Utils.renderJson("false");
        }
        return null;
    }

    /**
     * 获取当前目录号列表的顺序号
     * @return
     */
    public String currentSxh(){
        Struts2Utils.renderJson(ajhRangeService.getCurrentSxh(modelName,dm));
        return null;
    }

}
