package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.Constants;
import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.NoPermissionException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.entity.Permission;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.ResourceService;
import com.gtis.archive.service.SecurityService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.Serializable;
import java.util.*;

/**
 * Created with IntelliJ IDEA.
 * User: zhangbixi
 * Date: 12-10-18
 * Time: 下午4:32
 * To change this template use File | Settings | File Templates.
 */
public class MainAction extends BaseModelAction {

    @Autowired
    private ResourceService resourceService;

    @Autowired
    private ArchiveService archiveService;

    @Autowired
    private SecurityService securityService;

    private String treeId;

    private String id;

    private Map showFields;

    private Map docShowFields;

    private List<Item> operations;
    private Map<String, String> topMenu;




    @Override
    public String execute() {
        operations = dictService.getItems(Permission.OPERATION_DICT);
        return Action.SUCCESS;
    }

    public String node() throws Exception {
        List<Resource> ress = StringUtils.isBlank(id) ? resourceService.getChildrenResource(resourceService.getResource(null, "model").getId()) : resourceService.getChildrenResource(id);
        List<Map<Object, Serializable>> list = new ArrayList<Map<Object, Serializable>>();
        for (Resource res : ress) {
            Map<Object, Serializable> map = new HashMap<Object, Serializable>();
            map.put("id", res.getId());
            String text = res.getName();
            if (!res.getParentId().equals(resourceService.getResource(null, "model").getId())) {
                if (StringUtils.isNotEmpty(res.getTitle())) {
                    text = res.getTitle();
                }
            }
            map.put("text", text);
            map.put("name", res.getName());
            map.put("title", res.getTitle());
            map.put("content", res.getContent());
            map.put("parentId", res.getParentId());
            map.put("flh", res.getFlh());
            map.put("orderNumber", res.getOrderNumber());
            map.put("iconCls", "model");
            list.add(map);
        }
        Struts2Utils.renderJson(list);
        return null;
    }

    @Override
    public Map getShowFields() {
        if (showFields == null) {
            showFields = JSON.parseObject(getEntityTemplate("showFields"), LinkedHashMap.class);
        }
        Map<String, Field> fileds = getFields();
        StringBuilder sb = new StringBuilder("{\"result\":[");
        Iterator iter = showFields.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry) iter.next();
            StringBuilder content = new StringBuilder("{\"fieldName\":");
            String key = entry.getKey().toString();
            content.append("\"" + key + "\",\"title\":\"" + fileds.get(key).getTitle() + "\",");
            Map val = (Map) entry.getValue();
            Iterator it = val.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry en = (Map.Entry) it.next();
                String keyV = en.getKey().toString();
                String value = en.getValue().toString();
                content.append("\"" + keyV + "\":\"" + value + "\"");
                if (it.hasNext()) {
                    content.append(",");
                }
            }
            if (iter.hasNext()) {
                content.append("},");
                sb.append(content.toString());
            } else {
                content.append("}");
                sb.append(content.toString() + "]}");
            }
        }
        Struts2Utils.renderJson(sb.toString());
        return null;
    }


    /**
     * 获取卷被的字段
     * @return
     */
    public Map getDocShowFields() {
        if (docShowFields == null) {
            try {
                Model doc = archiveService.getDocumentModel(modelName);
                docShowFields = JSON.parseObject(doc.getTemplate("showFields"), LinkedHashMap.class);
            } catch (ModelNotFoundException ex) {
            } catch (TemplateNotFoundException ex) {
                docShowFields = JSON.parseObject(getEntityTemplate("Document-showFields"), LinkedHashMap.class);
            }
        }

        Map<String, Field> fileds = getDocFields();
        StringBuilder sb = new StringBuilder("{\"result\":[");
        Iterator iter = docShowFields.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry) iter.next();
            StringBuilder content = new StringBuilder("{\"fieldName\":");
            String key = entry.getKey().toString();
            content.append("\"" + key + "\",\"title\":\"" + fileds.get(key).getTitle() + "\",");
            Map val = (Map) entry.getValue();
            Iterator it = val.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry en = (Map.Entry) it.next();
                String keyV = en.getKey().toString();
                String value = en.getValue().toString();
                content.append("\"" + keyV + "\":\"" + value + "\"");
                if (it.hasNext()) {
                    content.append(",");
                }
            }
            if (iter.hasNext()) {
                content.append("},");
                sb.append(content.toString());
            } else {
                content.append("}");
                sb.append(content.toString() + "]}");
            }
        }
        Struts2Utils.renderJson(sb.toString());
        return null;
    }


    public Map getDocFields() {
        Map docFields = null;
        try {
            Model doc = archiveService.getDocumentModel(modelName);
            docFields = doc.getInheritfieldsMap();
        } catch (ModelNotFoundException ex) {
        }
        return docFields;
    }


    public String getTreeId() {
        return treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, String> getTopMenu() {
        if (topMenu == null) {
            topMenu = new LinkedHashMap<String, String>();
            for (Item item : dictService.getItems("archiveMenu")) {
                if ("true".equalsIgnoreCase(item.getValue())) {
                    topMenu.put(item.getName(), item.getRemark());
                }
            }
        }
        return topMenu;
    }

    public String getPermJson() {
        Map<String, Boolean> perm = new HashMap<String, Boolean>();
        if (operations == null)
            operations = dictService.getItems(Permission.OPERATION_DICT);
        for (Item item : operations) {
            if (securityService.isPermitted(treeId, item.getName()))
                perm.put(item.getName(), true);
        }
        if (treeId != null) {
            Struts2Utils.renderJson(perm);
        }
//        return JSON.toJSONString(perm);
        return null;
    }

    public List<Item> getOperations() {
        return operations;
    }
}
