package com.gtis.archive.core;

import java.util.Collection;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-8-3
 */
public interface ModelManager {
    /**
     * 获取模型
     *
     * @param modelName 模型名
     * @return 模型
     */
    Model getModel(String modelName);

    /**
     * 获取模型，若模型不存在则返回NULL
     * @param modelName
     * @return
     */
    Model getModelAllowNull(String modelName);

    /**
     * 获取所有模型
     *
     * @return 模型
     */
    Collection<Model> getModels();

    /**
     * 删除模型
     *
     * @param modelName 模型名
     */
    void removeModel(String modelName);

    /**
     * 保存模型
     *
     * @param model 需要保存的模型
     */
    void saveModel(Model model);
}
