package com.gtis.archive.web.admin;

import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelManager;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.environment.Environment;
import com.gtis.archive.core.generater.ModelCodeGenerater;
import com.gtis.archive.core.support.hibernate.ReloadableSessionFactory;
import com.gtis.archive.util.Struts2Utils;
import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.Preparable;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.StringWriter;
import java.util.*;
import java.util.regex.Pattern;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-8-5
 */
@Results({@Result(name = "toIndex", location = "model.action", type = "redirect"),
        @Result(name = "toTplList", location = "model!tplList.action?name=${name}", type = "redirect")})
public class ModelAction extends ActionSupport implements Preparable {
    private static final Pattern MODEL_NAME_PATTERN = Pattern.compile("[a-zA-Z_]\\w*");
    private static final long serialVersionUID = -3310497863268668088L;

    @Autowired
    private ModelManager modelManager;
    @Autowired
    private ModelService modelService;
    @Autowired
    private ReloadableSessionFactory reloadableSessionFactory;

    private String name;
    private Model model;
    private List<String> envName;
    private List<String> envValue;
    private List<String> fieldName;
    private List<String> fieldtitle;
    private List<String> fieldremark;
    private List<String> fieldtype;
    private List<Integer> fieldlength;
    private List<Boolean> fieldnullable;
    private List<String> fieldvalueDict;
    private List<String> fieldvalidation;
    private List<String> fielddefaultValue;
    private String msg;
    private String tplName;
    private String tplContent;

    public Model getModel() {
        return model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public String getMsg() {
        return msg;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTplContent() {
        return tplContent;
    }

    public void setTplContent(String tplContent) {
        this.tplContent = tplContent;
    }

    public String getTplName() {
        return tplName;
    }

    public void setTplName(String tplName) {
        this.tplName = tplName;
    }

    public void setEnvName(List<String> envName) {
        this.envName = envName;
    }

    public void setEnvValue(List<String> envValue) {
        this.envValue = envValue;
    }

    public void setFieldName(List<String> fieldName) {
        this.fieldName = fieldName;
    }

    public void setFielddefaultValue(List<String> fielddefaultValue) {
        this.fielddefaultValue = fielddefaultValue;
    }

    public void setFieldlength(List<Integer> fieldlength) {
        this.fieldlength = fieldlength;
    }

    public void setFieldnullable(List<Boolean> fieldnullable) {
        this.fieldnullable = fieldnullable;
    }

    public void setFieldremark(List<String> fieldremark) {
        this.fieldremark = fieldremark;
    }

    public void setFieldtitle(List<String> fieldtitle) {
        this.fieldtitle = fieldtitle;
    }

    public void setFieldtype(List<String> fieldtype) {
        this.fieldtype = fieldtype;
    }

    public void setFieldvalidation(List<String> fieldvalidation) {
        this.fieldvalidation = fieldvalidation;
    }

    public void setFieldvalueDict(List<String> fieldvalueDict) {
        this.fieldvalueDict = fieldvalueDict;
    }

    @Override
    public String execute() throws Exception {
        return SUCCESS;
    }

    public void prepare() throws Exception {
        if (StringUtils.isNotBlank(name)) {
            model = modelService.getModel(name);
        } else {
            model = new Model();
        }
    }

    public String edit() throws Exception {
        if (Struts2Utils.isPost()) {
            if (envName != null) {
                Environment env = new Environment();
                for (int i = 0; i < envName.size(); i++) {
                    if (StringUtils.isBlank(envName.get(i)))
                        continue;
                    env.put(envName.get(i), envValue.get(i));
                }
                model.setEnv(env);
            }
            if (StringUtils.isBlank(model.getParentName()) || model.getParentName().equals(model.getName()))
                model.setParentName(null);
            if (StringUtils.isBlank(model.getTitle()))
                model.setTitle(null);
            if (StringUtils.isBlank(model.getRemark()))
                model.setRemark(null);
            Set<Field> fields = new LinkedHashSet<Field>();
            if (fieldName != null) {
                for (int i = 0; i < fieldName.size(); i++) {
                    String name = fieldName.get(i);
                    if (StringUtils.isBlank(name))
                        continue;
                    Field field = new Field();
                    field.setName(name);
                    String title = fieldtitle.get(i);
                    String remark = fieldremark.get(i);
                    String valueDict = fieldvalueDict.get(i);
                    String validation = fieldvalidation.get(i);
                    String defaultValue = fielddefaultValue.get(i);
                    if (fieldtype == null)
                        continue;
                    if (fieldtype.size() > i) {
                        field.setType(Field.Type.valueOf(fieldtype.get(i)));
                        if (fieldlength.get(i) != null)
                            field.setLength(fieldlength.get(i));
                        field.setNullable(fieldnullable.get(i));
                        if (StringUtils.isNotBlank(title))
                            field.setTitle(title);
                        if (StringUtils.isNotBlank(remark))
                            field.setRemark(remark);
                        if (StringUtils.isNotBlank(valueDict))
                            field.setValueDict(valueDict);
                        if (StringUtils.isNotBlank(validation))
                            field.setValidation(validation);
                        if (StringUtils.isNotBlank(defaultValue))
                            field.setDefaultValue(defaultValue);
                        fields.add(field);
                    } else {
                        Field parentField = model.getParent().getInheritField(name);
                        boolean fieldChange = false;
                        if (StringUtils.isNotBlank(title) && !title.equals(parentField.getTitle())) {
                            field.setTitle(title);
                            fieldChange = true;
                        }
                        if (StringUtils.isNotBlank(remark) && !remark.equals(parentField.getRemark())) {
                            field.setRemark(remark);
                            fieldChange = true;
                        }
                        if (StringUtils.isNotBlank(valueDict) && !valueDict.equals(parentField.getValueDict())) {
                            field.setValueDict(valueDict);
                            fieldChange = true;
                        }
                        if (StringUtils.isNotBlank(validation) && !validation.equals(parentField.getValidation())) {
                            field.setValidation(validation);
                            fieldChange = true;
                        }
                        if (StringUtils.isNotBlank(defaultValue) && !defaultValue.equals(parentField.getDefaultValue())) {
                            field.setDefaultValue(defaultValue);
                            fieldChange = true;
                        }
                        if (fieldChange)
                            fields.add(field);
                    }
                }
                model.setFields(fields);
            }
            if (StringUtils.isBlank(name)) {
                try {
                    modelService.getModel(model.getName());
                    msg = "existed";
                    return "edit";
                } catch (Exception e) {
                    if (!MODEL_NAME_PATTERN.matcher(model.getName()).matches()) {
                        msg = "invalid";
                        return "edit";
                    }
                    name = model.getName();
                }
            }
            modelManager.saveModel(model);
            msg = "successed";
        }
        return "edit";
    }

    public String generate() throws Exception {
        model = modelService.getModel(name);
        StringWriter sw = new StringWriter();
        ModelCodeGenerater.JAVA.generate(model, sw);
        msg = sw.toString();
        return "generate";
    }

    public Collection<Model> getModels() {
        return modelService.getModels();
    }

    public Date getNow() {
        return new Date();
    }

    public List<Field> getParentFields() {
        List<Field> list = new ArrayList<Field>();
        for (Model m = model.getParent(); m != null; m = m.getParent()) {
            list.addAll(m.getFields());
        }
        return list;
    }

    public String getTab() {
        return "model";
    }

    public String remove() throws Exception {
        modelManager.removeModel(name);
        return "toIndex";
    }

    public String tplEdit() {
        if (tplContent != null) {
            model.getTemplates().put(tplName, tplContent);
            modelManager.saveModel(model);
            msg = "successed";
        } else {
            tplContent = model.getTemplates().get(tplName);
        }
        return "tplEdit";
    }

    public String tplList() throws Exception {
        return "tplList";
    }

    public String tplRemove() {
        model.getTemplates().remove(tplName);
        modelManager.saveModel(model);
        return "toTplList";
    }

    public String update() {
        modelService.reload();
        reloadableSessionFactory.reload();
        return "toIndex";
    }
}
