package com.gtis.archive.service.impl;

import com.gtis.search.EntityIndexProvider;
import com.gtis.search.Index;
import com.gtis.search.IndexManager;
import org.hibernate.event.*;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-10-28
 */
@SuppressWarnings("unchecked")
public class ArchiveIndexListener implements PostInsertEventListener, PostDeleteEventListener, PostUpdateEventListener, BeanPostProcessor {
    private static final long serialVersionUID = 5859744034324984631L;
    @Autowired
    private EntityIndexProvider indexProvider;
    @Autowired
    private IndexManager indexManager;

    public Object postProcessBeforeInitialization(Object bean, String s) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String s) throws BeansException {
        if (bean instanceof EntityIndexProvider)
            indexProvider = (EntityIndexProvider) bean;
        else if (bean instanceof IndexManager)
            indexManager = (IndexManager) bean;
        return bean;
    }

    public void onPostDelete(PostDeleteEvent event) {
        Index index = indexProvider.toIndex(event.getEntity());
        if (index != null) {
            indexManager.remove(index.getId());
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        doUpdate(event.getEntity());
    }

    public void onPostUpdate(PostUpdateEvent event) {
        doUpdate(event.getEntity());
    }

    private void doUpdate(Object entity) {
        Index index = indexProvider.toIndex(entity);
        if (index != null) {
            indexManager.update(index);
        }
    }
}
