package com.gtis.archive.service;

import java.util.Set;

/**
 * 访问控制接口.
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">Administrator</a>
 * @version V1.0, 2010-12-8
 */
public interface SecurityService {
    /**
     * 是否能访问
     *
     * @param permissionString 权限字符串
     * @return 是否能访问
     */
    boolean isPermitted(String permissionString);

    /**
     * 是否能访问
     *
     * @param resourceId 资源id
     * @param operation  操作
     * @return 是否能访问
     */
    boolean isPermitted(String resourceId, String operation);

    Set<String> getReadableRoleIds(String resourceId);
}
