package com.gtis.archive.service;

import com.gtis.archive.entity.AjhRange;
import com.gtis.common.Page;
import org.hibernate.criterion.Order;

import java.util.List;
import java.util.Map;

/**
 * 案卷号管理接口.
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-10-13
 */
public interface AjhRangeService {
    /**
     * 案卷号范围
     *
     * @param id 案卷号Id
     * @return 案卷号范围
     */
    AjhRange getAjhRange(String id);

    /**
     * 根据目录号获取模型名
     *
     * @param mlh mlh
     * @return 模型名
     */
    String getModelNameByMlh(String mlh);

    /**
     * get model name
     *
     * @param modelName modelname
     * @return AjhRange list
     */
    List<AjhRange> getAjhRangeByModelName(String modelName);

    /**
     * get available ajh count map
     *
     * @return ajh count map
     */
    Map<String, Integer> getAvailableAjhCountMap();

    /**
     * 根据单位代码获取所有可用案卷号
     * @return
     */
    Map<String,Integer> getAvailableAjhCountMapByDwdm(String dwdm);

    /**
     * get available ajhRange
     *
     * @param modelName modelName
     * @return ajhRange
     */
    AjhRange getAvailableAjhRange(String modelName);

    /**
     * 获取模型对应单位代码可以用的案卷号
     *
     * @param modelName
     * @param dwdm
     * @return
     */
    AjhRange getAvailableAjhRangeByDwdm(String modelName, String dwdm);

    /**
     * 获取模型对应mlh下可用的案卷号
     *
     * @param modelName
     * @param mlh
     * @return
     */
    AjhRange getAvailableAjhRange(String modelName, String mlh);


    /**
     * 获取对应目录号
     *
     * @param modelName
     * @param dwdm
     * @param mlh
     * @return
     */
    AjhRange getAvailableAjhRange(String modelName, String dwdm, String mlh);

    /**
     * remove a ajhrange
     *
     * @param id id
     */
    void removeAjhRange(String id);

    /**
     * save ajhRange
     *
     * @param ajhRange ajhRange
     * @return ajhRange
     */
    AjhRange saveAjhRange(AjhRange ajhRange);

    /**
     * 获取指定页案卷号
     *
     * @param start
     * @param limit
     * @param order
     * @return
     */
    Page<AjhRange> getAjhRanges(int start, int limit, Order[] order);


    /**
     * 胡群殴案卷号按将目录号转为数字型排序
     * @param start
     * @param limit
     * @param order
     * @return
     */
    Page<AjhRange> getAjhRangesOrderMlh(int start,int limit,String order);





    /**
     * 通用管理中获取案卷号，不做是否可用判断
     * @param modelName
     * @param mlh
     * @return
     */
    AjhRange getAjhRangesForGeneric(String modelName, String mlh);


    List getMlhByModelName(String modelName);

    List getMlh(String modelName,String dwdm);

    /**
     * 江阴根据保管期限获取对应的案卷号
      * @param modelName
     * @param bgqx
     * @return
     */
    AjhRange getAjhRangesByBgqx(String modelName,String bgqx);


}
