package com.gtis.archive.core.environment;

import com.gtis.archive.Constants;
import freemarker.template.Configuration;
import freemarker.template.Template;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-8-4
 */
public class Environment {
    public static final int TPL_CACHE_SIZE = 500;
    private static Map<String,Template> tplCaches = Collections.synchronizedMap(new LRUMap(TPL_CACHE_SIZE));
    private static Configuration cfg;
    private final Logger logger = LoggerFactory.getLogger(getClass());
    private Map props;
    private Object valueObject;
    private Environment parent;
    private EnvironmentModel em;

    static {
        DateConverter dc = new DateConverter(null);
        dc.setUseLocaleFormat(true);
        dc.setPatterns(new String[]{Constants.DATE_FORMAT.toPattern(), Constants.DATETIME_FORMAT.toPattern(), Constants.DATETIME_FORMAT_FULL.toPattern()});
        ConvertUtils.register(dc, Date.class);
        cfg = new Configuration();
        cfg.setDateFormat(Constants.DATE_FORMAT.toPattern());
        cfg.setDateTimeFormat(Constants.DATETIME_FORMAT.toPattern());
        cfg.setNumberFormat("0.######");
    }

    public Environment() {
        props = new LinkedHashMap();
    }

    public Environment(Map props) {
        this.props = props;
    }

    public Environment(Object valueObject) {
        this();
        this.valueObject = valueObject;
    }

    public Environment(Environment parent) {
        this();
        this.parent = parent;
    }

    public Environment(Map props, Environment parent) {
        this.props = props;
        this.parent = parent;
    }

    public Environment(Map props, Object valueObject) {
        this.props = props;
        this.valueObject = valueObject;
    }

    public Environment(Object valueObject, Environment parent) {
        this();
        this.valueObject = valueObject;
        this.parent = parent;
    }

    public Environment(Map props, Object valueObject, Environment parent) {
        this.props = props;
        this.valueObject = valueObject;
        this.parent = parent;
    }

    public Environment getParent() {
        return parent;
    }

    public void setParent(Environment parent) {
        this.parent = parent;
    }

    public Map getProps() {
        return props;
    }

    public void setProps(Map props) {
        this.props = props;
    }

    public Object getValueObject() {
        return valueObject;
    }

    public void setValueObject(Object valueObject) {
        this.valueObject = valueObject;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(props);
    }

    public String get(Object key) {
        String value = getRaw(key);
        return value != null ? getExpr(value) : null;
    }

    public String getRaw(Object key) {
        if (props.containsKey(key)) {
            return (String) props.get(key);
        } else {
            if (parent != null) {
                return parent.getRaw(key);
            }
        }
        return null;
    }

    public String getExpr(String expr) {
        if (!expr.contains("${") && !expr.contains("<#")) //not a template
            return expr;
        Template tpl = tplCaches.get(expr);
        try {
            if (tpl == null) {
                tpl = new Template(null, new StringReader(expr), cfg);
                tplCaches.put(expr, tpl);
            }
            StringWriter result = new StringWriter();
            if (em == null) {
                em = new EnvironmentModel(this);
            }
            tpl.process(em, result);
            return result.toString();
        } catch (Exception e) {
            logger.debug("process template:[{}] error:[{}]", expr, e);
        }
        return null;
    }

    public boolean isEmpty() {
        return props.isEmpty();
    }

    public Set keys() {
        return props.keySet();
    }

    @SuppressWarnings("unchecked")
    public Object put(String key, String value) {
        return props.put(key, value);
    }

    public Object remove(String key) {
        return props.remove(key);
    }

    public int size() {
        return props.size();
    }
    

}
