package com.gtis.archive.web.admin;

import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.ResourceService;
import com.gtis.archive.util.Struts2Utils;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-9-16
 */
public class TreeAction extends ActionSupport {
    private static final long serialVersionUID = 2867121450313294860L;
    @Autowired
    private ResourceService resourceService;

    private String type;
    private Resource res;
    private String id;

    public Resource getRes() {
        return res;
    }

    public void setRes(Resource res) {
        this.res = res;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String execute() throws Exception {
        return super.execute();
    }

    public String del() throws Exception {
        resourceService.removeResource(id);
        return null;
    }

    public String edit() throws Exception {
        if (StringUtils.isBlank(res.getParentId())) {
            res.setParentId(resourceService.getResource(null, type).getId());
        }
        Resource res1 = resourceService.getResource(res.getParentId(), res.getName());
        if (StringUtils.isBlank(res.getId())) {
            res.setId(null);
            if (res1 != null) {
                Struts2Utils.renderHtml("{success:false}");
                return null;
            }
        } else {
            if (res1 != null && !res1.getId().equals(res.getId())) {
                Struts2Utils.renderHtml("{success:false}");
                return null;
            }
        }
        resourceService.saveResource(res);
        Struts2Utils.renderHtml("{success:true}");
        return null;
    }

    public String getTab() {
        return "tree";
    }

    public String node() throws Exception {
        List<Resource> ress = StringUtils.isBlank(id) ? resourceService.getChildrenResource(resourceService.getResource(null, type).getId()) : resourceService.getChildrenResource(id);
        List<Map<Object, Serializable>> list = new ArrayList<Map<Object, Serializable>>();
        for (Resource res : ress) {
            Map<Object, Serializable> map = new HashMap<Object, Serializable>();
            map.put("id", res.getId());
            String text = res.getName();
            if (StringUtils.isNotEmpty(res.getTitle())) {
                text = text + "(" + res.getTitle() + ")";
            }
            map.put("text", text);
            map.put("name", res.getName());
            map.put("title", res.getTitle());
            map.put("content", res.getContent());
            map.put("parentId", res.getParentId());
            map.put("flh",res.getFlh());
            map.put("orderNumber", res.getOrderNumber());
            map.put("iconCls", "model");
            list.add(map);
        }
        Struts2Utils.renderJson(list);
        return null;
    }
}
