package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.support.hibernate.UUIDHexGenerator;
import com.gtis.archive.core.web.BaseAction;
import com.gtis.archive.core.web.BaseEntityAction;
import com.gtis.archive.entity.AjhRange;
import com.gtis.archive.service.AjhRangeService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import groovy.lang.GroovyObject;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:wanglei@gtis.com.cn">wanglei</a>
 * @version V1.0, 2010-11-9
 */
public class GenericEntityAction extends BaseEntityAction<Object> {

    @Autowired
    private AjhRangeService ajhRangeService;
    @Autowired
    private SysUserService userService;
    private AjhRange ajhRange;
    private Integer jh;
    private Integer djh;
    private String tempDjh;
    private String tempSbjh;
    private String tempQzh;
    private String tempNd;
    private String tempFlh;
    private String tempBgqx;

    //发文类型，一体化内文，不同发文类型对应一套登记号
    private String fwlx;

    private String currentId;

    public Map getShowFields() {
        Map showFields = null;
        try {
            showFields = JSON.parseObject(getEntityTemplate("showFields"), LinkedHashMap.class);
        } catch (TemplateNotFoundException ex) {
            logger.error(ex.getMessage());
        }
        return showFields == null ? Collections.emptyMap() : showFields;
    }

    @Override
    protected String getJsCallBack() {
        return "onGenericComplete";
    }

    @Override
    public String preview() throws Exception {
        try {
            return super.preview();
        } catch (TemplateNotFoundException ex) {
            try {
                return renderModelTemplate("Generic-preview");
            } catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return null;
    }

    @Override
    protected void preSave() {
        try {
            if (modelName.toLowerCase().equals("ythsw") || modelName.toLowerCase().equals("ythfw")||modelName.toLowerCase().equals("ythnw")) {
                if (tempDjh != null && !tempDjh.equals(PropertyUtils.getProperty(entity, "djh"))) {
                    PropertyUtils.setProperty(entity, "djh", tempDjh);
                }
                if( modelName.toLowerCase().equals("ythfw")&&tempDjh==null){
                    fwlx=PropertyUtils.getProperty(entity,"fwlx").toString();
                    ajhRange = getDjh();
                    djh = ajhRange.getNextValue();
                    PropertyUtils.setProperty(entity, "djh", String.valueOf(djh));
                }
                if (tempSbjh != null) { //生成室编件号后，nd,qzh,flh，的值不允许其修改
                    PropertyUtils.setProperty(entity, "sbjh", tempSbjh);
                    PropertyUtils.setProperty(entity, "nd", tempNd);
                    PropertyUtils.setProperty(entity, "qzh", tempQzh);
                    PropertyUtils.setProperty(entity, "flh", tempFlh);
                    PropertyUtils.setProperty(entity, "bgqx", tempBgqx);
                }
//                else if (tempQzh != null) {
//                    PropertyUtils.setProperty(entity, "nd", tempNd);
//                    PropertyUtils.setProperty(entity, "qzh", tempQzh);
//                    PropertyUtils.setProperty(entity, "flh", tempFlh);
//                }
                if (modelName.toLowerCase().equals("ythsw") && PropertyUtils.getProperty(entity, "status").equals("wgd")) {
                    PropertyUtils.setProperty(entity, "sbjh", null);
                }
            } else {
                if (ajhRange == null)
                      ajhRange = ajhRangeService.getAvailableAjhRange(modelName, PropertyUtils.getProperty(entity, "mlh").toString());
//                    ajhRange = ajhRangeService.getAvailableAjhRange(((GroovyObject) entity).getProperty("modelName").toString(), PropertyUtils.getProperty(entity, "mlh").toString());
                if (PropertyUtils.getProperty(entity, "jh") != null&&!StringUtils.isBlank(PropertyUtils.getProperty(entity, "jh").toString())) {   //修改操作，不修改件号

                } else {
                    jh = ajhRange.getNextValue();
                    PropertyUtils.setProperty(entity, "jh", String.valueOf(jh));
                }
            }
        } catch (Exception e) {
            logger.error(e.toString());
        }
        super.preSave();
    }

    @Override
    protected void afterSave() {
        if (jh != null) {
            ajhRange.setCurrentValue(jh);
            ajhRangeService.saveAjhRange(ajhRange);
        }
        if (djh != null) {
            ajhRange.setCurrentValue(djh);
            ajhRangeService.saveAjhRange(ajhRange);
        }
        try{
            this.currentId=PropertyUtils.getProperty(entity,"id").toString();
        }catch (Exception ex){
            logger.error(ex.toString());
        }
    }


    @Override
    public void prepare() {
        entity = StringUtils.isBlank(id) ? entityService.<Object>newInstance(modelName) : entityService.<Object>load(modelName, id);
        try {
            if (StringUtils.isBlank(id)) {
                if (modelName.toLowerCase().equals("ythsw") || modelName.toLowerCase().equals("ythfw")||modelName.toLowerCase().equals("ythnw")) {
                    if(!modelName.toLowerCase().equals("ythfw")){   //发文登记号与发文类型配套，先不予赋值
                        if (ajhRange == null) {
                            ajhRange = getDjh();
                        }
                        if (djh == null) {
                            djh = ajhRange.getNextValue();
                        }
                        PropertyUtils.setProperty(entity, "nd", String.valueOf(Calendar.getInstance().get(Calendar.YEAR)));
                        PropertyUtils.setProperty(entity, "djh", String.valueOf(djh));
                        PropertyUtils.setProperty(entity, "qzh", String.valueOf(getQzh()));
                    }else {
                        PropertyUtils.setProperty(entity, "nd", String.valueOf(Calendar.getInstance().get(Calendar.YEAR)));
                        PropertyUtils.setProperty(entity, "qzh", String.valueOf(getQzh()));
                    }

                }
            } else {
                if (modelName.toLowerCase().equals("ythsw") || modelName.toLowerCase().equals("ythfw")||modelName.toLowerCase().equals("ythnw")) {

                     tempDjh = PropertyUtils.getProperty(entity, "djh").toString();
                    if (PropertyUtils.getProperty(entity, "status").toString().equals("ygd")) {
                        tempSbjh = PropertyUtils.getProperty(entity, "sbjh").toString();
                        tempFlh = PropertyUtils.getProperty(entity, "flh").toString();
                        tempNd = PropertyUtils.getProperty(entity, "nd").toString();
                        tempQzh = PropertyUtils.getProperty(entity, "qzh").toString();
                        tempBgqx=PropertyUtils.getProperty(entity, "bgqx").toString();
                    }
                }
            }
            PropertyUtils.setProperty(entity,"dwdm",getDwdm());
        } catch (Exception ex) {
            logger.error(ex.toString());
        }
    }


    /**
     * 获取登记案卷号
     *
     * @return
     */
    private AjhRange getDjh() {
        String qzh=getQzh();
        AjhRange ajhRange1;
        String mlh;
        if(modelName.toLowerCase().equals("ythfw")){
            mlh = modelName+"-"+qzh+"-"+String.valueOf(Calendar.getInstance().get(Calendar.YEAR))+"-"+fwlx;
        }else {
            mlh = modelName+"-"+qzh+"-"+String.valueOf(Calendar.getInstance().get(Calendar.YEAR));
        }
        try {
            ajhRange1 = ajhRangeService.getAjhRangesForGeneric("Wdyth", mlh);
        } catch (Exception ex) {
            AjhRange ajhRangeTemp = new AjhRange();
            if (EnvHolder.isEnable(Switch.INDIVIDUAL_MLH))
                ajhRangeTemp.setDwdm(getDwdm());
            ajhRangeTemp.setMlh(mlh);
            ajhRangeTemp.setCurrentValue(0);
            ajhRangeTemp.setMinValue(0);
            ajhRangeTemp.setMaxValue(1000);
            ajhRangeTemp.setModelName("Wdyth");
            ajhRangeService.saveAjhRange(ajhRangeTemp);
            ajhRange1 = ajhRangeService.getAjhRangesForGeneric("Wdyth", mlh);
        }
        if (ajhRange1.hasExhausted()) {
            ajhRange1.setMaxValue(ajhRange1.getMaxValue() + 100);
            ajhRangeService.saveAjhRange(ajhRange1);
        }
        return ajhRange1;
    }

    /**
     * 获取全宗号
     *
     * @return
     */
    private String getQzh() {
        String qzh = "";
        String dwdm = getDwdm();
        try {
            List<Item> items = dictService.getItems(Constants.QZH_DWDM);
            for (Item item : items) {
                if (dwdm.equals(item.getName())) {
                    qzh = item.getValue();
                    break;
                }
            }
        } catch (Exception ex) {
            logger.info("未配置[{}]单位代码全宗号字典项", Constants.QZH_DWDM);
        }
        return qzh;
    }


    /**
     * 获取当前用户的单位代码
     *
     * @return
     */
    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }

    @Override
    protected String renderJs(Runner runner, String successMessage, String failuremessage, String fn) {
        if (fn == null) {
            fn = "onComplete";
        }
        try {
            runner.run();
            if (successMessage == null) {
                successMessage = "";
            }
            Struts2Utils.renderJs("(opener||parent)." + fn + "(true,'" + successMessage+";"+this.currentId + "');");
        } catch (Exception e) {
            logger.error("error", e);
            if (failuremessage == null) {
                failuremessage = "失败 " + e.getMessage();
            }
            Struts2Utils.renderJs("(opener||parent)." + fn + "(false,'" + failuremessage + "');");
        }
        return null;
    }
}
