package com.gtis.archive.service;

/**
 * archive Gateway service.
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-9-30
 */
public interface GatewayService {
    /**
     * proccess archive in access
     *
     * @param content content
     * @return result
     * @throws Exception exception
     */
    String in(String content) throws Exception;

    /**
     * proccess archive out access
     *
     * @param key key
     * @return result
     */
    String out(String key);

    /**
     * update archive
     *
     * @param content the content of archive(before update,format the content)
     * @return true or false
     */
    String update(String content);


    /**
     * 档案数据接入
     * @param content
     * @return
     * @throws Exception
     */
    String preIn(String content) throws Exception;

    /**
     * 预处理接口
     * @param modelName
     * @param id
     * @param mlh
     * @return
     * @throws Exception
     */
    String  preDispose(String modelName,String id,String mlh) throws Exception;


    /**
     *  取消预处理
     * @param modelName
     * @param id
     * @return
     * @throws Exception
     */
    String cancelDispose(String modelName,String id) throws Exception;

    /**
     * 打印完交接单，数据将在档案列表中显示
     * @param modelName
     * @param id
     * @return
     * @throws Exception
     */
    String dispose(String modelName,String id) throws Exception;


}
