package com.gtis.archive.core.support.freemarker;

import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.environment.EnvironmentModel;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-12-5
 */
public class FreemarkerContext {
    public UserInfo getUser() {
        return SessionUtil.getCurrentUser();
    }

    public boolean isAdmin() {
        return getUser().isAdmin();
    }

    public EnvironmentModel getEnv() {
        return new EnvironmentModel(EnvHolder.getAppEnv());
    }

    public boolean hasEnv(String key) {
        return EnvHolder.isEnable(key);
    }
}
