package com.gtis.archive.core.dict;

import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * 字典项
 * <p/>
 * Generated 2010-08-13 13:17:58 by Model Code Generater 1.0
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_dict_item")
public class Item {
    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String id;

    /**
     * 名称
     */
    @Column(length = 100, nullable = false)
    private String name;

    /**
     * 值
     */
    @Column(length = 100)
    private String value;

    /**
     * 备注
     */
    @Column(length = 100)
    private String remark;

    /**
     * 所有者序号
     */
    @Column(length = 32)
    private String ownerId;

    /**
     * 父条目序号
     */
    @Column(length = 32)
    private String parentId;

    /**
     * 字典序号
     */
    @Column(length = 32, nullable = false)
    private String dictId;

    /**
     * 顺序号
     */
    @Column(nullable = false)
    private int orderNumber;

    public String getDictId() {
        return dictId;
    }

    public void setDictId(String dictId) {
        this.dictId = dictId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getOrderNumber() {
        return orderNumber;
    }

    public void setOrderNumber(int orderNumber) {
        this.orderNumber = orderNumber;
    }

    public String getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}