package com.gtis.archive.web;

import com.gtis.archive.Constants;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.entity.Permission;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.ExtTreeService;
import com.gtis.archive.service.SecurityService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.config.AppConfig;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-8-5
 */
public class IndexAction implements Action {
    private static final long serialVersionUID = -465202185697219258L;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private DictService dictService;
    @Autowired
    private SecurityService securityService;

    private boolean hideBanner;
    private Boolean isA3d;
    private String id;
    private String modelName;
    private Map<String, Boolean> perms;
    private HashMap<String, Object> a3dFieldsMap;

    public void setHideBanner(boolean hideBanner) {
        this.hideBanner = hideBanner;
    }

    public List<Map<String, Object>> getTree() {
        return treeService.getTree(null, Constants.MODEL_ROOT);
    }

    public boolean isAdmin() {
        return SessionUtil.getCurrentUser().isAdmin();
    }

    public Boolean isA3d() {
        return isA3d;
    }

    public Map<String, Boolean> getPerms() {
        return perms;
    }

    public String a3dframe() throws Exception {
        return "a3dframe";
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModelName() {
        return modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public HashMap<String, Object> getA3dFieldsMap() {
        return a3dFieldsMap;
    }

    public String execute() throws Exception {
        if (hideBanner) {
            Struts2Utils.getSession().setAttribute("hideBanner", Boolean.TRUE);
        }
        if (AppConfig.getBooleanProperty("archive3d.enable")) {
            isA3d = true;
        }
        perms = new HashMap<String, Boolean>();
        for (Item item : dictService.getItems(Permission.SYS_FUNCTION_DICT)) {
            if (securityService.isPermitted("sys", item.getName()))
                perms.put(item.getName(), true);
        }
        return SUCCESS;
    }

    public String a3d() throws Exception {
        isA3d = true;
        Archive archive = null;
        a3dFieldsMap = new HashMap<String, Object>();
        if (modelName == null) {
            return "a3d";
        } else if ("Archive".equals(modelName)) {
            archive = archiveService.getArchive(modelName, id);
        } else if (modelName.lastIndexOf("_jn") > -1) {
            Document doc = archiveService.getDocument(modelName, id);
            archive = archiveService.getDocumentArchive(doc);
        }
        if (archive != null) {
            a3dFieldsMap.put("archiveid", id);
            a3dFieldsMap.put("ajh", archive.getAjh());
            a3dFieldsMap.put("mlh", archive.getMlh());
            a3dFieldsMap.put("title", archive.getTm());
        }
        return "a3d";
    }
}
