package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.GatewayService;
import com.gtis.archive.util.Struts2Utils;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-9-30
 */
public class GatewayAction implements Action {

    @Autowired
    private GatewayService gatewayService;

    @Autowired
    private DictService dictService;

    @Autowired
    private ArchiveService archiveService;

    @Autowired
    protected ModelService modelService;

    private String data;

    private String id;

    private String modelName;

    private Map docShowFields;
    private Map docFields;

    public void setData(String data) {
        this.data = data;
    }

    /**
     * 默认插入档案
     *
     * @return
     * @throws Exception
     */
    public String execute() throws Exception {
        if (StringUtils.isNotBlank(data))
            Struts2Utils.renderXml(gatewayService.in(data));
        return null;
    }

    /**
     * 更新档案
     *
     * @return
     */
    public String update() {
        if (StringUtils.isNotBlank(data)) {
            Struts2Utils.renderXml(gatewayService.update(data));
        }
        return null;
    }

    public String edit() {
        return "edit";
    }

    public String originalInfo(){
        return "originalInfo";
    }

    public String inBox(){
        return "inBox";
    }

    public String out(){
        if(StringUtils.isNotBlank(id))
            Struts2Utils.renderXml(gatewayService.out(id));
        return null;
    }


    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModelName() {
        return modelName;
    }

    public String getId() {
        return id;
    }

    public String getSessionId() {
        return ServletActionContext.getRequest().getSession().getId();
    }


    public Map getDocShowFields() {
        if(docShowFields==null)
        {
            try{
                Model doc = archiveService.getDocumentModel(modelName+"_jn");
                docShowFields = JSON.parseObject(doc.getTemplate("showFields"), LinkedHashMap.class);
            }catch(ModelNotFoundException ex){
            }catch(TemplateNotFoundException ex){
                docShowFields = JSON.parseObject(getEntityTemplate("Document-showFields"),LinkedHashMap.class);
            }
        }
        return docShowFields;
    }

    public Map getDocFields(){
        if(docFields==null)
        {
            try {
                Model doc = archiveService.getDocumentModel(modelName);
                docFields = doc.getInheritfieldsMap();
            }catch(ModelNotFoundException ex){
            }
        }
        return docFields;
    }

    private String getEntityTemplate(String name) {
        return getEntityModel().getTemplate(name);
    }

    private Model getEntityModel() {
        return modelService.getModel(modelName);
    }


    public String getList(){
        Collection<Model> models=getModels();
        Map<String,String> map=new HashMap<String,String>();
        Iterator iterator=models.iterator();
        while (iterator.hasNext()){
            Model model=(Model)iterator.next();
            if("Archive".equals(model.getParentName()))
                map.put(model.getTitle(),model.getName());
        }
        return JSON.toJSONString(map);
    }

    public ArrayList<String> getKeys(){
        Collection<Model> models=getModels();
        ArrayList<String> keys=new ArrayList<String>();
        Iterator iterator=models.iterator();
        while (iterator.hasNext()){
            Model model=(Model)iterator.next();
            if("Archive".equals(model.getParentName()))
                keys.add(model.getTitle());
        }
        return keys;
    }


    public Collection<Model> getModels() {
        return modelService.getModels();
    }

}
