package com.gtis.archive.web;

import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.support.hibernate.UUIDHexGenerator;
import com.gtis.archive.core.web.BaseEntityAction;
import com.gtis.archive.entity.AjhRange;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.service.AjhRangeService;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.ResourceService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-10-13
 */
public class ArchiveEntityAction extends BaseEntityAction<Archive> {
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private AjhRangeService ajhRangeService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SysUserService userService;


    private String treeId;
    private AjhRange ajhRange;
    public Integer _ajh;
    public boolean gd;

    private List<String> mlhs;//江阴目录号列表

    private String mlh;//用户江阴目录号下拉框改变时同时改变案卷号

    public void setAjhRange(AjhRange ajhRange) {
        this.ajhRange = ajhRange;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setGd(boolean gd) {
        this.gd = gd;
    }

    public AjhRange getAjhRange() {
        return ajhRange;
    }

    public String getTreeId() {
        return treeId;
    }

    /**
     * 是否处于档案补录状态
     */
    private boolean isMakeUp;

    public boolean isMakeUp() {
        return isMakeUp;
    }

    public void setMakeUp(boolean makeUp) {
        isMakeUp = makeUp;
    }

    @Override
    public void prepare() {
        boolean isCreate = StringUtils.isBlank(id);
        if (isCreate) {
            entity = archiveService.newArchive(modelName);
            String cid = (String) session.get("currentAId");
            Archive lastArchive = null;
            if (cid != null) {
                lastArchive = archiveService.getArchive(modelName, cid);
            }
            if (lastArchive != null&&lastArchive.getModelName().equals(modelName)) {
                try {
                    PropertyUtils.copyProperties(entity, lastArchive);
                } catch (Exception ignored) {
                }
                entity.setDh(null);
            }else if(EnvHolder.isEnable(Switch.JIANGYIN)) {
                entity.setDwdm(getDwdm());
                entity.setQzh(getQzh());
            }
            entity.setId(UUIDHexGenerator.generate());
            if (StringUtils.isNotBlank(treeId)) {
//                String flh = resourceService.getResource(treeId).getContent();
                String flh = resourceService.getResource(treeId).getFlh();
                if (StringUtils.isNotBlank(flh))
                        entity.setFlh(flh);
//                    if (flh.contains(",")) {
//                        String[] strs = flh.split(",");
//                        entity.setFlh(strs[1]);
//                    }
            }
        } else {
            entity = archiveService.getArchive(modelName, id);
            if (entity == null) {
                entity = archiveService.newArchive(modelName);
//                }
            }
        }
        if (isCreate && EnvHolder.isEnable(Switch.INCREASE_AJH)) {
            ajhRange = getAvailableAjhRange();
            entity.setMlh(ajhRange.getMlh());
            entity.setAjh(ajhRange.getNextValue());
        }
    }

    @Override
    protected void preSave() {
        if (ajhRange != null && StringUtils.isNotBlank(ajhRange.getId()) && entity.getAjh()!=null && entity.getAjh() == ajhRange.getNextValue()) {//如果相等，说明用户未修改ajh，取出当前可用案卷号赋值
            ajhRange = ajhRangeService.getAjhRange(ajhRange.getId());
            _ajh = ajhRange.getNextValue();
            entity.setAjh(_ajh);
        } else {
            List<Criterion> criterions = new ArrayList<Criterion>();
            criterions.add(Restrictions.eq("qzh", entity.getQzh()));
            criterions.add(Restrictions.eq("mlh", entity.getMlh()));
            criterions.add(Restrictions.eq("ajh", entity.getAjh()));
            Page<Archive> page = archiveService.searchArchive(modelName, criterions, null, 0, 1);

            if (!page.isEmpty() && !page.getItem(0).getId().equals(entity.getId())) {
                if (!EnvHolder.isEnable(Switch.BENG_BU) && !isMakeUp) {
                    throw new RuntimeException("此案卷号已被使用");
                }
                if(EnvHolder.isEnable(Switch.JIN_TAN) && isMakeUp){
                    logger.debug("档案补录，插入案卷号");
                    makeUpArchive();
                }
            }
        }
        if (StringUtils.isNotBlank(treeId)) {
            entity.setResourceId(treeId);
        }
        if(entity.getAjh()!=null && entity.getMlh()!=null)
        {
            AjhRange preAjhRange = ajhRangeService.getAvailableAjhRange(modelName,entity.getMlh());
            //获得当前目录号的案卷号范围
            /**List<AjhRange> listAjh =  ajhRangeService.getAjhRangeByModelName(modelName);
            for (AjhRange ajh : listAjh) {
                if (entity.getMlh().equals(ajh.getMlh())) {
                    preAjhRange = ajh;
                }
            }**/
            //如果当前案卷号大于当前最大可用案卷号或者是小于当前最小可用案卷号，则给出提示！
            if(preAjhRange!=null){
                if(entity.getAjh()>preAjhRange.getMaxValue())
                    throw new RuntimeException("案卷号不能大于当前最大案卷号");
                if(entity.getAjh()<preAjhRange.getMinValue())
                    throw new RuntimeException("案卷号不能小于当前最小案卷号");
            }
        }

        if (gd) {
            ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
            if (entity.getAjh() > ajhRange.getNextValue()) {
                throw new RuntimeException("不能大于当前最大案卷号");
            }
            entity.setGdsj(new Date());
            entity.setState(Archive.STATE_YGD);
        }
        entity.setDh(null);
    }

    /**
     * 档案补录
     */
    private void makeUpArchive(){
        try{
            List<Criterion> criterions = new ArrayList<Criterion>();
            criterions.add(Restrictions.eq("mlh", entity.getMlh()));
            criterions.add(Restrictions.ge("ajh", entity.getAjh()));
            List<Order> orders = new ArrayList<Order>();
            orders.add(Order.asc("ajh"));
            List<AjhRange> ajhRanges = ajhRangeService.getAjhRangeByModelName(modelName);
            for(AjhRange range : ajhRanges){
                if(range.getMlh().equalsIgnoreCase(entity.getMlh())) {
                    ajhRange = range;
                    break;
                }
            }
            Page<Archive> pages = archiveService.searchArchive(modelName, criterions, orders, 0, ajhRange.getMaxValue());
            for (int i = pages.getTotalCount(); i>0; i--){
                Archive archive = pages.getItem(i-1);
                archive.setAjh(archive.getAjh().intValue()+1);
                archive.setDh(null);
                if(archive.getAjh()>ajhRange.getMaxValue()) {
                    throw new RuntimeException("档案移动后将会超出目录最大容量，请先扩充目录号【{"+archive.getMlh()+"}】容量");
                }
                archiveService.saveArchive(archive);
            }
        }catch(Exception ex){
            logger.error("档案补录异常【{}】,确认目录号【{}】已配置",ex.getLocalizedMessage(),entity.getMlh());
            throw new RuntimeException("档案补录异常,确认目录号【"+entity.getMlh()+"】已配置");
        }
    }

    public String bl() throws Exception {
        return renderModelTemplate("bl");
    }

    @Override
    protected void doSave(Archive entity) {
        archiveService.saveArchive(entity);
    }

    @Override
    protected void afterSave() {
        if (_ajh != null) {
            ajhRange.setCurrentValue(_ajh);
            ajhRangeService.saveAjhRange(ajhRange);
        }
        session.put("currentAId", entity.getId());
    }

    /**
     * 获取可用的案卷号
     * @return
     */
    private AjhRange getAvailableAjhRange(){
        if(entity.getMlh()!=null && entity.getMlh()!=null)
            return ajhRangeService.getAvailableAjhRange(modelName,entity.getMlh());
        else
            return ajhRangeService.getAvailableAjhRange(modelName);
    }

    @Override
    protected String getSuccessMsg() {
        return entity==null?super.getSuccessMsg():entity.getId();
    }

    @Override
    protected String getJsCallBack() {
        return "onArchiveComplete";
    }

    /**
     * 获取全宗号
     *
     * @return
     */
    private String getQzh() {
        String qzh = "";
        String dwdm = getDwdm();
        try {
            List<Item> items = dictService.getItems(Constants.QZH_DWDM);
            for (Item item : items) {
                if (dwdm.equals(item.getName())) {
                    qzh = item.getValue();
                    break;
                }
            }
        } catch (Exception ex) {
            logger.info("未配置[{}]单位代码全宗号字典项", Constants.QZH_DWDM);
        }
        return qzh;
    }


    /**
     * 获取当前用户的单位代码
     *
     * @return
     */
    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }


    public String reSetAjh(){
        ajhRange=ajhRangeService.getAvailableAjhRange(modelName,mlh);
        entity.setMlh(mlh);
        entity.setAjh(ajhRange.getNextValue());
        renderJson(ajhRange.getNextValue()+","+ajhRange.getId()+","+ajhRange.getCurrentValue()+","+ajhRange.getBgqx());
        return null;
    }

    public String getMlh() {
        return mlh;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public List<String> getMlhs() {
        return ajhRangeService.getMlhByModelName(modelName);
    }
}