package com.gtis.archive.core;

import com.gtis.archive.util.CriteriaCallback;
import com.gtis.common.Page;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;

import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-8-3
 */
public interface EntityService {

    void cleanCache();

    <X> X load(String modelName, String id);

    <X> X load(Class clazz, String id);

    <X> X newInstance(String modelName);

    <X> X newInstance(Class clazz);

    void remove(String modelName, String[] ids);

    void remove(Class clazz, String[] ids);

    <X> X save(Object entity);

    <X> X query(String modelName, Criterion... criterions);

    <X> X query(Class clazz, Criterion... criterions);

    <X> X query(String hql, Object... values);

    <X> X query(String hql, Map<String, ?> values);

    <X> Page<X> search(CriteriaCallback callback, int start, int limit);

    <X> Page<X> search(CriteriaCallback callback, List<? extends Criterion> criterions, List<Order> orders, int start, int limit);

    <X> Page<X> search(String modelName, List<? extends Criterion> criterions, List<Order> orders, int start, int limit);

    <X> Page<X> search(Class clazz, List<? extends Criterion> criterions, List<Order> orders, int start, int limit);

    <X> Page<X> search(String hql, String countHql, int start, int limit, Object... values);

    <X> Page<X> search(String hql, String countHql, int start, int limit, Map<String, ?> values);

    <X> Page<X> search(String hql, int start, int limit, Object... values);

    <X> Page<X> search(String hql, int start, int limit, Map<String, ?> values);

    int getCount(String modelName, List<? extends Criterion> criterions);

    int getCount(Class clazz, List<? extends Criterion> criterions);
}
