/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web.admin;

import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.entity.Permission;
import com.gtis.archive.service.ExtTreeService;
import com.gtis.archive.service.PermissionService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfRoleVo;
import com.opensymphony.xwork2.ActionSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.json.JSONUtil;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class PermissionAction
extends ActionSupport {
    private static final long serialVersionUID = -3107528495499282167L;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private DictService dictService;
    private List<PfRoleVo> roles;
    private String treeJson;
    private String roleId;
    private String[] checked;
    private String[] unChecked;
    private Set<Permission> permissions = new HashSet();
    private List<Item> operations;

    private List<Map<String, Object>> rewrite(List<Map<String, Object>> tree) {
        if (tree != null) {
            for (Map<String, Object> map : tree) {
                this.rewrite((List)map.get("children"));
                String id = (String)map.get("id");
                ArrayList opts = new ArrayList();
                for (Item item : this.operations) {
                    HashMap<String, Object> op = new HashMap<String, Object>();
                    op.put("name", id + "_" + item.getName());
                    op.put("text", item.getValue());
                    op.put("checked", this.permissions.contains(new Permission(id, this.roleId, item.getName())));
                    opts.add(op);
                }
                map.put("data", opts);
            }
        }
        return tree;
    }

    public void setUnChecked(String[] unChecked) {
        this.unChecked = unChecked;
    }

    public void setChecked(String[] checked) {
        this.checked = checked;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public List<PfRoleVo> getRoles() {
        return this.roles;
    }

    public String getTreeJson() {
        return this.treeJson;
    }

    public String execute() throws Exception {
        this.roles = this.userService.getRoleList();
        return "success";
    }

    public String tree() throws Exception {
        this.permissions.addAll(this.permissionService.getPermissions(null, this.roleId));
        this.operations = this.dictService.getItems("operationPerm");
        List tree = this.rewrite(this.treeService.getTree(null, new String[]{"model"}));
        tree.add(0, this.getSysFunctionNode());
        this.treeJson = JSONUtil.serialize((Object)tree);
        return "tree";
    }

    private Map<String, Object> getSysFunctionNode() {
        List sysFunction = this.dictService.getItems("sysPerm");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", "sys");
        map.put("text", "\u7cfb\u7edf\u529f\u80fd");
        map.put("leaf", true);
        map.put("iconCls", "node");
        ArrayList functions = new ArrayList();
        for (Item item : sysFunction) {
            HashMap<String, Object> op = new HashMap<String, Object>();
            op.put("name", "sys_" + item.getName());
            op.put("text", item.getValue());
            op.put("checked", this.permissions.contains(new Permission("sys", this.roleId, item.getName())));
            functions.add(op);
        }
        map.put("data", functions);
        return map;
    }

    public String save() throws Exception {
        int i;
        int len;
        Permission[] ps;
        if (this.checked != null && StringUtils.isNotBlank((String)this.checked[0])) {
            ps = new Permission[this.checked.length];
            len = this.checked.length;
            for (i = 0; i < len; ++i) {
                ps[i] = PermissionAction.toPermission((String)this.checked[i], (String)this.roleId);
            }
            this.permissionService.grant(ps);
        }
        if (this.unChecked != null && StringUtils.isNotBlank((String)this.unChecked[0])) {
            ps = new Permission[this.unChecked.length];
            len = this.unChecked.length;
            for (i = 0; i < len; ++i) {
                ps[i] = PermissionAction.toPermission((String)this.unChecked[i], (String)this.roleId);
            }
            this.permissionService.revoke(ps);
        }
        return null;
    }

    private static Permission toPermission(String s, String roleId) {
        String[] ss = s.split("_");
        return new Permission(ss[0], roleId, ss[1]);
    }

    public String getTab() {
        return "permission";
    }
}

