/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web.admin;

import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelManager;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.entity.AjhRange;
import com.gtis.archive.service.AjhRangeService;
import com.gtis.archive.service.ExtTreeService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.ActionSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Results(value={@Result(name="toList", location="ajh!list.action?modelName=${modelName}", type="redirect")})
public class AjhAction
extends ActionSupport {
    private static final long serialVersionUID = 7582278548353967361L;
    private String id;
    private String modelName;
    private AjhRange ajhRange;
    private List<AjhRange> ajhRanges;
    private Map<String, Integer> modelsMap;
    private Map<String, String> modelAliasMap;
    private Map<String, String> flMap;
    private String msg;
    @Autowired
    private ModelManager modelService;
    @Autowired
    private AjhRangeService ajhRangeService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private ExtTreeService treeService;

    public AjhRange getAjhRange() {
        return this.ajhRange;
    }

    public void setAjhRange(AjhRange ajhRange) {
        this.ajhRange = ajhRange;
    }

    public List<AjhRange> getAjhRanges() {
        return this.ajhRanges;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public Map<String, Integer> getModelsMap() {
        return this.modelsMap;
    }

    public Map<String, String> getModelAliasMap() {
        return this.modelAliasMap;
    }

    public Map<String, String> getFlMap() {
        return this.flMap;
    }

    public String getMsg() {
        return this.msg;
    }

    public String execute() throws Exception {
        this.modelsMap = new LinkedHashMap();
        this.modelAliasMap = new HashMap();
        Map map = EnvHolder.isEnable((String)"jurong.enable") && EnvHolder.isEnable((String)"dwdm.enable") && !SessionUtil.getCurrentUser().isAdmin() ? this.ajhRangeService.getAvailableAjhCountMapByDwdm(this.getDwdm()) : this.ajhRangeService.getAvailableAjhCountMap();
        if (EnvHolder.isEnable((String)"jiangyin.enable")) {
            this.flMap = new HashMap();
            List temp = this.treeService.getTree(null, new String[]{"model"});
            for (Map parentNode : temp) {
                String fl = parentNode.get("text").toString();
                ArrayList children = (ArrayList)parentNode.get("children");
                for (Map model : children) {
                    Model tempModel = this.modelService.getModelAllowNull(model.get("name").toString());
                    if (tempModel == null) continue;
                    this.modelsMap.put(tempModel.getName(), map.get(tempModel.getName()));
                    this.modelAliasMap.put(tempModel.getName(), tempModel.getTitle());
                    this.flMap.put(tempModel.getName(), fl);
                }
            }
        } else {
            for (Model model : this.modelService.getModels()) {
                if ("Archive".equals(model.getParentName())) {
                    this.modelsMap.put(model.getName(), map.get(model.getName()));
                    this.modelAliasMap.put(model.getName(), model.getTitle());
                    continue;
                }
                if (!EnvHolder.isEnable((String)"jiangyin.enable") || model.getParentName() != null) continue;
                this.modelsMap.put(model.getName(), map.get(model.getName()));
                this.modelAliasMap.put(model.getName(), model.getTitle());
            }
        }
        return super.execute();
    }

    public String edit() throws Exception {
        if (this.ajhRange == null) {
            if (StringUtils.isNotBlank((String)this.id)) {
                this.ajhRange = this.ajhRangeService.getAjhRange(this.id);
                this.modelName = this.ajhRange.getModelName();
            } else {
                this.ajhRange = new AjhRange();
                this.ajhRange.setModelName(this.modelName);
            }
        } else {
            if (this.ajhRange.getCurrentValue() < this.ajhRange.getMinValue()) {
                this.ajhRange.setCurrentValue(this.ajhRange.getMinValue());
            }
            if (StringUtils.isBlank((String)this.ajhRange.getId())) {
                this.ajhRange.setId(null);
            }
            if (EnvHolder.isEnable((String)"dwdm.enable") && this.ajhRange.getDwdm() == null) {
                this.ajhRange.setDwdm(this.getDwdm());
            }
            this.ajhRangeService.saveAjhRange(this.ajhRange);
            this.msg = "successed";
        }
        return "edit";
    }

    public String getTab() {
        return "ajh";
    }

    public String list() throws Exception {
        this.ajhRanges = this.ajhRangeService.getAjhRangeByModelName(this.modelName);
        return "list";
    }

    public String remove() throws Exception {
        this.ajhRangeService.removeAjhRange(this.id);
        return "toList";
    }

    public String getDwdm() {
        String dwdm = (String)Struts2Utils.getSessionAttribute((String)"__dwdm");
        if (dwdm == null) {
            dwdm = this.userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", (Object)dwdm);
        }
        return dwdm;
    }
}

