/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web;

import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.ExtTreeService;
import com.opensymphony.xwork2.ActionSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.struts2.ServletActionContext;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsAction
extends ActionSupport {
    private static final long serialVersionUID = 8810580227666165801L;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private ArchiveService archiveService;
    private String nd;
    private List<Map<String, Object>> results;
    private Map<String, Object> totalStatistics;

    public void setNd(String nd) {
        this.nd = nd;
    }

    public List<Map<String, Object>> getResults() {
        return this.results;
    }

    public Map<String, Object> getTotalStatistics() {
        return this.totalStatistics;
    }

    public String getNd() {
        return this.nd;
    }

    public String execute() throws Exception {
        ServletActionContext.getResponse().setContentType("application/vnd.ms-word");
        ServletActionContext.getResponse().setHeader("Content-Disposition", "attachment; filename=stat.doc");
        this.initInfo();
        return "success";
    }

    private List<Map<String, Object>> initInfo() throws Exception {
        List tree = this.treeService.getTree(null, new String[]{"model"});
        this.results = new ArrayList();
        this.totalStatistics = new HashMap();
        SimpleExpression criterion_state = Restrictions.eq((String)"state", (Object)1);
        SimpleExpression criterion_nd = Restrictions.eq((String)"nd", (Object)this.nd);
        SimpleExpression criterion_d = Restrictions.eq((String)"bgqx", (Object)"\u77ed\u671f");
        SimpleExpression criterion_z = Restrictions.eq((String)"bgqx", (Object)"\u957f\u671f");
        SimpleExpression criterion_c = Restrictions.eq((String)"bgqx", (Object)"\u6c38\u4e45");
        int lx = 0;
        int ld = 0;
        int lz = 0;
        int lc = 0;
        int lzj = 0;
        int lzd = 0;
        int lzz = 0;
        int lzc = 0;
        for (Map res : tree) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            int x = 0;
            int d = 0;
            int z = 0;
            int c = 0;
            int zj = 0;
            int zd = 0;
            int zz = 0;
            int zc = 0;
            if (res.get("children") == null) continue;
            ArrayList children = (ArrayList)res.get("children");
            for (Object child : children) {
                String modelName = (String)((Map)child).get("name");
                ArrayList<SimpleExpression> criterions = new ArrayList<SimpleExpression>();
                criterions.add(criterion_state);
                criterions.add(criterion_nd);
                x += this.archiveService.getArchiveCount(modelName, criterions);
                criterions.add(criterion_d);
                d += this.archiveService.getArchiveCount(modelName, criterions);
                criterions.remove(criterion_d);
                criterions.add(criterion_z);
                z += this.archiveService.getArchiveCount(modelName, criterions);
                criterions.remove(criterion_z);
                criterions.add(criterion_c);
                c += this.archiveService.getArchiveCount(modelName, criterions);
                criterions.remove(criterion_nd);
                criterions.remove(criterion_c);
                zj += this.archiveService.getArchiveCount(modelName, criterions);
                criterions.add(criterion_d);
                zd += this.archiveService.getArchiveCount(modelName, criterions);
                criterions.remove(criterion_d);
                criterions.add(criterion_z);
                zz += this.archiveService.getArchiveCount(modelName, criterions);
                criterions.remove(criterion_z);
                criterions.add(criterion_c);
                zc += this.archiveService.getArchiveCount(modelName, criterions);
            }
            result.put("nd", this.nd);
            result.put("title", res.get("name"));
            result.put("x", x);
            lx += x;
            result.put("d", d);
            ld += d;
            result.put("z", z);
            lz += z;
            result.put("c", c);
            lc += c;
            result.put("zj", zj);
            lzj += zj;
            result.put("zd", zd);
            lzd += zd;
            result.put("zz", zz);
            lzz += zz;
            result.put("zc", zc);
            lzc += zc;
            this.totalStatistics.put("lx", lx);
            this.totalStatistics.put("ld", ld);
            this.totalStatistics.put("lz", lz);
            this.totalStatistics.put("lc", lc);
            this.totalStatistics.put("lzj", lzj);
            this.totalStatistics.put("lzd", lzd);
            this.totalStatistics.put("lzz", lzz);
            this.totalStatistics.put("lzc", lzc);
            this.results.add(result);
        }
        return null;
    }
}

