/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web;

import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.NoPermissionException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Loan;
import com.gtis.archive.service.SecurityService;
import com.gtis.archive.util.CriteriaCallback;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoanAction
extends BaseModelAction<Loan> {
    @Autowired
    private SecurityService securityService;
    @Autowired
    private SysUserService userService;
    private String type;

    public void setType(String type) {
        this.type = type;
    }

    public String returnLoan() {
        for (String id : this.ids) {
            if (StringUtils.isBlank((String)id)) continue;
            Loan loan = (Loan)this.entityService.load(Loan.class, id);
            loan.setState(1);
            this.entityService.save((Object)loan);
        }
        return null;
    }

    protected Page<Loan> searchEntity(List<Criterion> criterions, List<Order> orders) {
        if ("return".equals(this.type)) {
            criterions.add((Criterion)Restrictions.eq((String)"state", (Object)1));
        } else if ("exceed".equals(this.type)) {
            criterions.add(Restrictions.sqlRestriction((String)"jyrq+jyqx<?", (Object)new Date(), (Type)StandardBasicTypes.DATE));
            criterions.add((Criterion)Restrictions.eq((String)"state", (Object)0));
        } else {
            criterions.add((Criterion)Restrictions.eq((String)"state", (Object)0));
        }
        if (this.query != null) {
            criterions.add((Criterion)Restrictions.or((Criterion)Restrictions.like((String)"arc.tm", (Object)("%" + this.query + "%")), (Criterion)Restrictions.like((String)"arc.dh", (Object)("%" + this.query + "%"))));
        }
        if (EnvHolder.isEnable((String)"dwdm.enable") && !SessionUtil.getCurrentUser().isAdmin()) {
            criterions.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"dwdm"), (Criterion)Restrictions.eq((String)"dwdm", (Object)this.getDwdm())));
        }
        return this.entityService.search((CriteriaCallback)new /* Unavailable Anonymous Inner Class!! */, criterions, orders, this.start, this.limit);
    }

    protected String[] getQueryFields() {
        return null;
    }

    private String getDwdm() {
        String dwdm = (String)Struts2Utils.getSessionAttribute((String)"__dwdm");
        if (dwdm == null) {
            dwdm = this.userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", (Object)dwdm);
        }
        return dwdm;
    }

    public String execute() throws Exception {
        if (!this.securityService.isPermitted("sys", "loan")) {
            throw new NoPermissionException("\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u501f\u9605\u7ba1\u7406");
        }
        return super.execute();
    }
}

