/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web;

import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.ExtTreeService;
import com.gtis.archive.service.SecurityService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.config.AppConfig;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexAction
implements Action {
    private static final long serialVersionUID = -465202185697219258L;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private DictService dictService;
    @Autowired
    private SecurityService securityService;
    private boolean hideBanner;
    private Boolean isA3d;
    private String id;
    private String modelName;
    private Map<String, Boolean> perms;
    private HashMap<String, Object> a3dFieldsMap;

    public void setHideBanner(boolean hideBanner) {
        this.hideBanner = hideBanner;
    }

    public List<Map<String, Object>> getTree() {
        return this.treeService.getTree(null, new String[]{"model"});
    }

    public boolean isAdmin() {
        return SessionUtil.getCurrentUser().isAdmin();
    }

    public Boolean isA3d() {
        return this.isA3d;
    }

    public Map<String, Boolean> getPerms() {
        return this.perms;
    }

    public String a3dframe() throws Exception {
        return "a3dframe";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public HashMap<String, Object> getA3dFieldsMap() {
        return this.a3dFieldsMap;
    }

    public String execute() throws Exception {
        if (this.hideBanner) {
            Struts2Utils.getSession().setAttribute("hideBanner", (Object)Boolean.TRUE);
        }
        if (AppConfig.getBooleanProperty((String)"archive3d.enable")) {
            this.isA3d = true;
        }
        this.perms = new HashMap();
        for (Item item : this.dictService.getItems("sysPerm")) {
            if (!this.securityService.isPermitted("sys", item.getName())) continue;
            this.perms.put(item.getName(), true);
        }
        return "success";
    }

    public String a3d() throws Exception {
        this.isA3d = true;
        Archive archive = null;
        this.a3dFieldsMap = new HashMap();
        if (this.modelName == null) {
            return "a3d";
        }
        if ("Archive".equals(this.modelName)) {
            archive = this.archiveService.getArchive(this.modelName, this.id);
        } else if (this.modelName.lastIndexOf("_jn") > -1) {
            Document doc = this.archiveService.getDocument(this.modelName, this.id);
            archive = this.archiveService.getDocumentArchive(doc);
        }
        if (archive != null) {
            this.a3dFieldsMap.put("archiveid", this.id);
            this.a3dFieldsMap.put("ajh", archive.getAjh());
            this.a3dFieldsMap.put("mlh", archive.getMlh());
            this.a3dFieldsMap.put("title", archive.getTm());
        }
        return "a3d";
    }
}

