/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.GatewayService;
import com.gtis.archive.util.Struts2Utils;
import com.opensymphony.xwork2.Action;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GatewayAction
implements Action {
    @Autowired
    private GatewayService gatewayService;
    @Autowired
    private DictService dictService;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    protected ModelService modelService;
    private String data;
    private String id;
    private String modelName;
    private Map docShowFields;
    private Map docFields;

    public void setData(String data) {
        this.data = data;
    }

    public String execute() throws Exception {
        if (StringUtils.isNotBlank((String)this.data)) {
            Struts2Utils.renderXml((String)this.gatewayService.in(this.data), (String[])new String[0]);
        }
        return null;
    }

    public String update() {
        if (StringUtils.isNotBlank((String)this.data)) {
            Struts2Utils.renderXml((String)this.gatewayService.update(this.data), (String[])new String[0]);
        }
        return null;
    }

    public String edit() {
        return "edit";
    }

    public String originalInfo() {
        return "originalInfo";
    }

    public String inBox() {
        return "inBox";
    }

    public String out() {
        if (StringUtils.isNotBlank((String)this.id)) {
            Struts2Utils.renderXml((String)this.gatewayService.out(this.id), (String[])new String[0]);
        }
        return null;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getId() {
        return this.id;
    }

    public String getSessionId() {
        return ServletActionContext.getRequest().getSession().getId();
    }

    public Map getDocShowFields() {
        if (this.docShowFields == null) {
            try {
                Model doc = this.archiveService.getDocumentModel(this.modelName + "_jn");
                this.docShowFields = (Map)JSON.parseObject((String)doc.getTemplate("showFields"), LinkedHashMap.class);
            }
            catch (ModelNotFoundException ex) {
            }
            catch (TemplateNotFoundException ex) {
                this.docShowFields = (Map)JSON.parseObject((String)this.getEntityTemplate("Document-showFields"), LinkedHashMap.class);
            }
        }
        return this.docShowFields;
    }

    public Map getDocFields() {
        if (this.docFields == null) {
            try {
                Model doc = this.archiveService.getDocumentModel(this.modelName);
                this.docFields = doc.getInheritfieldsMap();
            }
            catch (ModelNotFoundException modelNotFoundException) {
                // empty catch block
            }
        }
        return this.docFields;
    }

    private String getEntityTemplate(String name) {
        return this.getEntityModel().getTemplate(name);
    }

    private Model getEntityModel() {
        return this.modelService.getModel(this.modelName);
    }

    public String getList() {
        Collection models = this.getModels();
        HashMap<String, String> map = new HashMap<String, String>();
        for (Model model : models) {
            if (!"Archive".equals(model.getParentName())) continue;
            map.put(model.getTitle(), model.getName());
        }
        return JSON.toJSONString(map);
    }

    public ArrayList<String> getKeys() {
        Collection models = this.getModels();
        ArrayList<String> keys = new ArrayList<String>();
        for (Model model : models) {
            if (!"Archive".equals(model.getParentName())) continue;
            keys.add(model.getTitle());
        }
        return keys;
    }

    public Collection<Model> getModels() {
        return this.modelService.getModels();
    }
}

