/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web;

import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.LoanCart;
import com.gtis.archive.service.LoanService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BorrowAction
extends BaseModelAction<Archive> {
    @Autowired
    private LoanService loanService;
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected EntityService entityService;
    @Autowired
    private SysUserService userService;
    private String archiveType;
    private String idString;
    private String id;

    public String getArchiveType() {
        return this.archiveType;
    }

    public void setArchiveType(String archiveType) {
        this.archiveType = archiveType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIdString(String idString) {
        this.idString = idString;
    }

    public void setIds(String[] ids) {
        this.ids = ids;
    }

    public List<LoanCart> getLoanCar() {
        ArrayList<LoanCart> entities = new ArrayList<LoanCart>();
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if (!"".equals(this.idString)) {
            Date date = new Date();
            for (String id : this.idString.split(",")) {
                LoanCart lc = new LoanCart();
                lc.setArchiveId(id.trim());
                Archive arvhice = (Archive)this.entityService.load(this.archiveType, id.trim());
                lc.setUserId(userInfo.getId());
                lc.setArchiveType(this.archiveType);
                lc.setInDate(date);
                lc.setDwdm(this.getDwdm());
                lc.setMlh(arvhice.getMlh());
                lc.setAjh(arvhice.getAjh().toString());
                lc.setTm(arvhice.getTm());
                entities.add(lc);
            }
        }
        return entities;
    }

    public String borrows() {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        List criterions = this.createCriterions(new ArrayList());
        if (userInfo.isAdmin()) {
            this.renderJson((Object)this.loanService.getPages(this.start, this.limit, criterions));
        } else {
            SimpleExpression cr = Restrictions.eq((String)"userId", (Object)userInfo.getId());
            criterions.add(cr);
            this.renderJson((Object)this.loanService.getPages(this.start, this.limit, criterions));
        }
        return null;
    }

    public String addLoanCar() {
        for (LoanCart loancar : this.getLoanCar()) {
            this.loanService.addToCart((Object)loancar);
        }
        Struts2Utils.renderJson((String)"success", (String[])new String[0]);
        return null;
    }

    public String getDwdm() {
        String dwdm = (String)Struts2Utils.getSessionAttribute((String)"__dwdm");
        if (dwdm == null) {
            dwdm = this.userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", (Object)dwdm);
        }
        return dwdm;
    }

    public String remove() {
        this.loanService.removeFromCart(this.entityService.load(LoanCart.class, this.id));
        Struts2Utils.renderJson((String)"success", (String[])new String[0]);
        return null;
    }

    public Model getEntityModel() {
        return this.modelService.getModel("LoanCart");
    }
}

