/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.util;

import com.gtis.archive.core.Field;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.Hibernate;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class SearchUtils {
    private static String getValue(String s) {
        int i = s.indexOf(",");
        try {
            return i == -1 || i == s.length() - 1 ? null : URLDecoder.decode(s.substring(i + 1), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private static Criterion conditionToCriterion(Field field, String op, String value) {
        if ("eq".equals(op)) {
            return Restrictions.eq((String)field.getName(), (Object)field.getValue(value));
        }
        if ("like".equals(op)) {
            return Restrictions.sqlRestriction((String)("to_char(" + field.getName() + ") like ?"), (Object)("%" + value + "%"), (Type)Hibernate.STRING);
        }
        if ("ne".equals(op)) {
            return Restrictions.ne((String)field.getName(), (Object)field.getValue(value));
        }
        if ("gt".equals(op)) {
            return Restrictions.gt((String)field.getName(), (Object)field.getValue(value));
        }
        if ("lt".equals(op)) {
            return Restrictions.lt((String)field.getName(), (Object)field.getValue(value));
        }
        if ("isNull".equals(op)) {
            return Restrictions.isNull((String)field.getName());
        }
        if ("notNull".equals(op)) {
            return Restrictions.isNotNull((String)field.getName());
        }
        return null;
    }

    public static List<Criterion> conditionToCriterion(Map<String, Field> fieldMap, String condition) {
        ArrayList<Criterion> criterions = new ArrayList<Criterion>();
        String[] cs = condition.split(";");
        for (int i = 0; i < cs.length; i += 3) {
            String name = SearchUtils.getValue((String)cs[i]);
            String op = SearchUtils.getValue((String)cs[i + 1]);
            String value = SearchUtils.getValue((String)cs[i + 2]);
            if (name == null || value == null) continue;
            criterions.add(SearchUtils.conditionToCriterion((Field)fieldMap.get(name), (String)op, (String)value));
        }
        return criterions;
    }
}

