/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.service.impl;

import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelChangeEvent;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.environment.Environment;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.entity.Original;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.ResourceService;
import com.gtis.archive.service.SecurityService;
import com.gtis.search.Business;
import com.gtis.search.BusinessFactory;
import com.gtis.search.Category;
import com.gtis.search.CategoryFactory;
import com.gtis.search.EntityIndexProvider;
import com.gtis.search.Index;
import com.gtis.search.IndexManager;
import com.gtis.search.MimeTypeHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveIndexProviderImpl
extends EntityIndexProvider<Object>
implements ApplicationListener {
    public static final String[] TPLS = new String[]{"textUrl", "textBody", "fileUrl", "fileBody"};
    @Autowired
    private ModelService modelService;
    @Autowired
    private EntityService entityService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private IndexManager indexManager;
    @Autowired
    private ResourceService resourceService;
    private CategoryFactory defaultCategoryFactory;
    private ScheduledExecutorService executorService;
    private Future reloadFuture;

    public void setDefaultBusinessFactory(BusinessFactory defaultBusinessFactory) {
        this.defaultBusiness = defaultBusinessFactory.getBusiness();
    }

    public void setDefaultCategoryFactory(CategoryFactory defaultCategoryFactory) {
        this.defaultCategoryFactory = defaultCategoryFactory;
    }

    public List<Business> getBusinesses() {
        ArrayList<Category> categories = new ArrayList<Category>();
        for (Model model : this.modelService.getModels()) {
            if (model.isHidden()) continue;
            Category cat = this.defaultCategoryFactory.getCategory(this.defaultBusiness).clone();
            cat.setId("a_" + model.getName());
            cat.setName(model.getTitle());
            cat.setIcon(model.getName());
            cat.setRoleIds(this.getReadableRoleIds(model.getName()));
            for (String tpl : TPLS) {
                try {
                    cat.addTpl(tpl, model.getTemplate("search" + StringUtils.capitalize((String)tpl)));
                }
                catch (TemplateNotFoundException ignored) {
                    // empty catch block
                }
            }
            categories.add(cat);
        }
        this.defaultBusiness.setCategories(categories);
        return Collections.singletonList(this.defaultBusiness);
    }

    private String[] getReadableRoleIds(String name) {
        Resource res = this.resourceService.findChildResource(null, name, new String[]{"model"});
        if (res != null) {
            Set ids = this.securityService.getReadableRoleIds(res.getId());
            return ids.toArray(new String[ids.size()]);
        }
        return null;
    }

    public int getTotalCount(String categoryId) {
        return this.entityService.getCount(this.getModelName(categoryId), null);
    }

    protected Index createIndex(Object entity) {
        if (entity instanceof Archive || entity instanceof Document || entity instanceof Original) {
            return super.createIndex(entity);
        }
        return null;
    }

    protected Index prepareIndex(Index index) {
        return index;
    }

    protected Object getEntity(String categoryId, String id) {
        return this.entityService.load(this.getModelName(categoryId), id);
    }

    protected void extractEntity(Object entity, Index index) {
        index.setBusinessId(this.defaultBusiness.getId());
        index.setCategoryId("a_" + this.modelService.getModelName(entity));
        if (entity instanceof Archive) {
            this.extractArchive((Archive)entity, index);
        } else if (entity instanceof Document) {
            this.extractDocument((Document)entity, index);
        } else if (entity instanceof Original) {
            this.extractOriginal((Original)entity, index);
        }
        index.appendBody(this.renderBody(entity));
    }

    private String renderBody(Object entity) {
        try {
            Model model = this.modelService.getModel(entity);
            Environment env = new Environment(entity, model.getEnv());
            env.put("fields", StringUtils.join(model.getInheritfieldsMap().keySet(), (String)" "));
            String indexTpl = this.modelService.getModel(entity).getTemplate("index");
            return env.getExpr(indexTpl);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected List<Object> getEntities(String categoryId, int start, int size) {
        return this.entityService.search(this.getModelName(categoryId), null, null, start, size).getItems();
    }

    private String getModelName(String categoryId) {
        return categoryId.substring(2);
    }

    protected void extractArchive(Archive entity, Index index) {
        index.setId(entity.getId());
        index.setTitle(entity.getTm());
        index.setDate(entity.getQrq());
    }

    protected void extractDocument(Document entity, Index index) {
        index.setId(entity.getId());
        index.setTitle(entity.getTm());
        index.setDate(entity.getRq());
        index.addSearchableField("aid", (Serializable)((Object)entity.getArchiveId()));
    }

    protected void extractOriginal(Original entity, Index index) {
        index.setId(entity.getId());
        index.setTitle(entity.getName());
        index.setDate(entity.getUpdateTime());
        index.setMimeType(MimeTypeHelper.getMimeType((String)entity.getName()));
        index.appendBody(entity.getFullText(), 500);
        index.addField("size", (Serializable)Integer.valueOf((int)entity.getFileSize()));
        index.addSearchableField("oid", (Serializable)((Object)entity.getOwnerId()));
        Archive archive = (Archive)this.entityService.load(Archive.class, entity.getOwnerId());
        if (archive != null) {
            index.addField("ownerIsArchive", (Serializable)Boolean.valueOf(true));
            String modelName = this.modelService.getModelName((Object)archive);
            if (Archive.MODEL_NAME.equals(modelName)) {
                modelName = Original.MODEL_NAME;
            }
            index.setCategoryId("a_" + modelName);
        } else {
            Document document = (Document)this.entityService.load(Document.class, entity.getOwnerId());
            if (document != null) {
                String modelName = this.modelService.getModelName((Object)document);
                if (Document.MODEL_NAME.equals(modelName)) {
                    modelName = Original.MODEL_NAME;
                }
                index.setCategoryId("a_" + modelName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ModelChangeEvent) {
            this.defaultBusiness.setLastModified(Long.valueOf(event.getTimestamp()));
            ArchiveIndexProviderImpl archiveIndexProviderImpl = this;
            synchronized (archiveIndexProviderImpl) {
                if (this.executorService == null) {
                    this.executorService = Executors.newSingleThreadScheduledExecutor();
                }
                if (this.reloadFuture != null) {
                    this.reloadFuture.cancel(false);
                }
                this.reloadFuture = this.executorService.schedule((Runnable)new /* Unavailable Anonymous Inner Class!! */, 10L, TimeUnit.SECONDS);
            }
        }
    }

    static /* synthetic */ Business access$000(ArchiveIndexProviderImpl x0) {
        return x0.defaultBusiness;
    }

    static /* synthetic */ IndexManager access$100(ArchiveIndexProviderImpl x0) {
        return x0.indexManager;
    }

    static /* synthetic */ Future access$200(ArchiveIndexProviderImpl x0) {
        return x0.reloadFuture;
    }

    static /* synthetic */ Future access$202(ArchiveIndexProviderImpl x0, Future x1) {
        x0.reloadFuture = x1;
        return x0.reloadFuture;
    }
}

