/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.core.impl;

import com.gtis.archive.core.AppPropsManager;
import com.gtis.archive.core.support.xstream.CDATASupportDom4JDriver;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppPropsManagerImpl
implements AppPropsManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Resource location;
    private Map<String, String> props;
    private XStream sm;

    public void setLocation(Resource location) {
        this.location = location;
    }

    public Map<String, String> getAppProps() {
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveAppProps() {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(this.location.getFile());
            this.sm.toXML((Object)this.props, (OutputStream)os);
        }
        catch (IOException e) {
            this.logger.error("store props [" + this.props + "],error:{}", (Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.sm = new XStream((HierarchicalStreamDriver)new CDATASupportDom4JDriver());
        InputStream is = null;
        try {
            is = this.location.getInputStream();
            this.props = (Map)this.sm.fromXML(is);
        }
        catch (Exception e) {
            this.props = new LinkedHashMap();
            this.logger.error("load props file [" + this.location + "],error:{}", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

