/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.core.environment;

import com.gtis.archive.Constants;
import com.gtis.archive.core.environment.EnvironmentModel;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environment {
    public static final int TPL_CACHE_SIZE = 500;
    private static LRUMap tplCaches = new LRUMap(500);
    private static Configuration cfg;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map props;
    private Object valueObject;
    private Environment parent;
    private EnvironmentModel em;

    public Environment() {
        this.props = new LinkedHashMap();
    }

    public Environment(Map props) {
        this.props = props;
    }

    public Environment(Object valueObject) {
        this();
        this.valueObject = valueObject;
    }

    public Environment(Environment parent) {
        this();
        this.parent = parent;
    }

    public Environment(Map props, Environment parent) {
        this.props = props;
        this.parent = parent;
    }

    public Environment(Map props, Object valueObject) {
        this.props = props;
        this.valueObject = valueObject;
    }

    public Environment(Object valueObject, Environment parent) {
        this();
        this.valueObject = valueObject;
        this.parent = parent;
    }

    public Environment(Map props, Object valueObject, Environment parent) {
        this.props = props;
        this.valueObject = valueObject;
        this.parent = parent;
    }

    public Environment getParent() {
        return this.parent;
    }

    public void setParent(Environment parent) {
        this.parent = parent;
    }

    public Map getProps() {
        return this.props;
    }

    public void setProps(Map props) {
        this.props = props;
    }

    public Object getValueObject() {
        return this.valueObject;
    }

    public void setValueObject(Object valueObject) {
        this.valueObject = valueObject;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this.props);
    }

    public String get(Object key) {
        String value = this.getRaw(key);
        return value != null ? this.getExpr(value) : null;
    }

    public String getRaw(Object key) {
        if (this.props.containsKey(key)) {
            return (String)this.props.get(key);
        }
        if (this.parent != null) {
            return this.parent.getRaw(key);
        }
        return null;
    }

    public String getExpr(String expr) {
        if (!expr.contains("${") && !expr.contains("<#")) {
            return expr;
        }
        Template tpl = (Template)tplCaches.get((Object)expr);
        try {
            if (tpl == null) {
                tpl = new Template(null, (Reader)new StringReader(expr), cfg);
                tplCaches.put((Object)expr, (Object)tpl);
            }
            StringWriter result = new StringWriter();
            if (this.em == null) {
                this.em = new EnvironmentModel(this);
            }
            tpl.process((Object)this.em, (Writer)result);
            return result.toString();
        }
        catch (Exception e) {
            this.logger.debug("process template:[{}] error:[{}]", (Object)expr, (Object)e);
            return null;
        }
    }

    public boolean isEmpty() {
        return this.props.isEmpty();
    }

    public Set keys() {
        return this.props.keySet();
    }

    public Object put(String key, String value) {
        return this.props.put(key, value);
    }

    public Object remove(String key) {
        return this.props.remove(key);
    }

    public int size() {
        return this.props.size();
    }

    static {
        DateConverter dc = new DateConverter(null);
        dc.setUseLocaleFormat(true);
        dc.setPatterns(new String[]{Constants.DATE_FORMAT.toPattern(), Constants.DATETIME_FORMAT.toPattern(), Constants.DATETIME_FORMAT_FULL.toPattern()});
        ConvertUtils.register((Converter)dc, Date.class);
        cfg = new Configuration();
        cfg.setDateFormat(Constants.DATE_FORMAT.toPattern());
        cfg.setDateTimeFormat(Constants.DATETIME_FORMAT.toPattern());
        cfg.setNumberFormat("0.######");
    }
}

