/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.core;

import com.gtis.archive.core.Field;
import com.gtis.archive.core.InheritField;
import com.gtis.archive.core.environment.Environment;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model {
    public static final String PACKAGE_NAME = "com.gtis.archive.entity";
    private static final Logger logger = LoggerFactory.getLogger(Model.class);
    private String name;
    private String title;
    private String remark;
    private String parentName;
    private boolean constant;
    private boolean hidden;
    private Set<Field> fields;
    private Map<String, String> templates;
    private Environment env;
    @XStreamOmitField
    private Model parent;
    @XStreamOmitField
    private Map<String, Field> fieldCache;
    @XStreamOmitField
    private Map<String, Field> inheritFieldCache;

    public Environment getEnv() {
        return this.env;
    }

    public void setEnv(Environment env) {
        this.env = env;
    }

    public Set<Field> getFields() {
        return this.fields;
    }

    public void setFields(Set<Field> fields) {
        this.fieldCache = null;
        this.inheritFieldCache = null;
        this.fields = fields;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Model getParent() {
        return this.parent;
    }

    public void setParent(Model parent) {
        this.parent = parent;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.fieldCache = null;
        this.inheritFieldCache = null;
        this.parentName = parentName;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Map<String, String> getTemplates() {
        return this.templates;
    }

    public void setTemplates(Map<String, String> templates) {
        this.templates = templates;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean equals(Object obj) {
        return obj instanceof Model && this.name != null && this.name.equals(((Model)obj).getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.name + "," + this.title + "]";
    }

    public Field getField(String fieldName) {
        if (this.fieldCache == null) {
            this.initFieldsMap();
        }
        return (Field)this.fieldCache.get(fieldName);
    }

    public Field getInheritField(String fieldName) {
        if (this.inheritFieldCache == null) {
            this.initFieldsMap();
        }
        return (Field)this.inheritFieldCache.get(fieldName);
    }

    public Map<String, Field> getInheritfieldsMap() {
        if (this.inheritFieldCache == null) {
            this.initFieldsMap();
        }
        return this.inheritFieldCache;
    }

    public String getTemplate(String tplName) {
        String tpl = null;
        for (Model model = this; model != null; model = model.getParent()) {
            if (model.getTemplates() != null && StringUtils.isNotBlank((String)(tpl = (String)model.getTemplates().get(tplName)))) {
                return tpl;
            }
            String fileName = model.getName() + "-" + tplName + ".ftl";
            String basePath = this.env.getExpr("${.vars['web.root']}/tpls");
            File file = new File(basePath, fileName);
            if (!file.exists()) {
                basePath = this.env.getExpr("${.vars['egov.conf']}/archive/tpls");
                try {
                    file = ResourceUtils.getFile((String)(basePath + "/" + fileName));
                }
                catch (FileNotFoundException ignored) {
                    // empty catch block
                }
            }
            if (!file.exists()) continue;
            try {
                return FileUtils.readFileToString((File)file, (String)"UTF-8");
            }
            catch (IOException e) {
                logger.error("read file error", (Throwable)e);
            }
        }
        if (tpl == null) {
            try {
                File file = ResourceUtils.getFile((String)(this.env.getExpr("${.vars['web.root']}/tpls/") + tplName + ".ftl"));
                if (file.exists()) {
                    return FileUtils.readFileToString((File)file, (String)"UTF-8");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new TemplateNotFoundException(tplName, this.name);
        }
        return tpl;
    }

    public File getPrintFr3(String printType) {
        for (Model model = this; model != null; model = model.getParent()) {
            String fileName = model.getName() + (printType == null ? "" : "-" + printType) + ".fr3";
            String basePath = this.env.getExpr("${.vars['web.root']}/print");
            File file = new File(basePath, fileName);
            if (file.exists()) {
                return file;
            }
            basePath = this.env.getExpr("${.vars['egov.conf']}/archive/print");
            try {
                file = ResourceUtils.getFile((String)(basePath + "/" + fileName));
                if (!file.exists()) continue;
                return file;
            }
            catch (FileNotFoundException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    private synchronized void initFieldsMap() {
        this.fieldCache = new LinkedHashMap();
        this.inheritFieldCache = new LinkedHashMap();
        for (Field f : this.getFields()) {
            this.fieldCache.put(f.getName(), f);
        }
        for (Model model = this; model != null; model = model.getParent()) {
            for (Field f : model.getFields()) {
                if (this.inheritFieldCache.containsKey(f.getName())) continue;
                this.inheritFieldCache.put(f.getName(), new InheritField(f.getName(), model));
            }
        }
    }
}

