package com.gtis.archive.web.admin;

import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.OriginalService;
import com.gtis.archive.service.impl.OriginalServiceImpl;
import com.gtis.archive.util.SearchUtils;
import com.gtis.archive.util.Struts2Utils;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2014/8/18.
 */
public class TbywAction extends BaseModelAction<Object> {

    @Autowired
    private ArchiveService archiveService;

    @Autowired
    private OriginalService originalService;

    private int dealTime;

    public int getDealTime() {
        return dealTime;
    }

    public void setDealTime(int dealTime) {
        this.dealTime = dealTime;
    }

    public String getTab(){
        return "og" ;
    }

    @Override
    public String execute() throws Exception {
        return "syn_og";
    }


    public String syncOg(){
        Map<String,Object> map = new HashMap<String,Object>() ;
        int size = archiveService.findAllArchiveSize() ;
        try {
            originalService.batchSyncOriginal(size);
            map.put("success",true) ;
        }catch (Exception e){
            e.printStackTrace();
            map.put("success",false) ;
        }
//        map.put("size",size) ;
        renderJson(map) ;
        return null;
    }

    public String syncOgPercent(){
        Map<String,Object> map = new HashMap<String,Object>() ;
        java.text.DecimalFormat df =new java.text.DecimalFormat("#.0000");
        df.setRoundingMode(RoundingMode.HALF_UP);
        String f1 = df.format(originalService.batchSyncOriginalPercent());
        map.put("percent",Float.parseFloat(f1)) ;
        return renderJson(map) ;
    }

    /**
     * 页面展示所有同步的信息
     * @return
     */
    public String ShowAllInfo(){
        Map map = null ;

        int size = archiveService.findAllArchiveSize() ;
        map = originalService.batchSyncOriginalInfo(size,dealTime);
        Struts2Utils.renderJson(map);
        return null;
    }
}
