package com.gtis.archive.web.admin;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.CheckLog;
import com.gtis.archive.service.*;
import com.gtis.plat.service.SysUserService;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by Administrator on 2014/8/6.
 */
public class CheckAction extends BaseModelAction<Object> {
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private AjhRangeService ajhRangeService;

    @Autowired
    private OriginalService originalService;

    @Autowired
    private ArchiveService archiveService;

    @Autowired
    private RecordAjhRangeService recordAjhRangeService;

    @Autowired
    private CheckLogService checkLogService ;

    private List<CheckLog> list = new ArrayList<CheckLog>() ;

    private CheckLog checkLog ;

    private Date startTime ;

    private Date endTime ;

    private String checkLogId;

    public List<CheckLog> getList() {
        return list;
    }

    public void setList(List<CheckLog> list) {
        this.list = list;
    }

    public CheckLog getCheckLog() {
        return checkLog;
    }

    public void setCheckLog(CheckLog checkLog) {
        this.checkLog = checkLog;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getCheckLogId() {
        return checkLogId;
    }

    public void setCheckLogId(String checkLogId) {
        this.checkLogId = checkLogId;
    }

    @Override
    public String execute() throws Exception {
        return super.execute();
    }

    public String showCheckLog(){
        list = checkLogService.findAllCheckLog() ;
        return "log" ;
    }

    public String getTab(){
        return "log" ;
    }

    public String searchCheckLog(){
        try {
            list = checkLogService.findCheckLog(checkLog,startTime,endTime) ;
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return "log" ;
    }

    public void getCheclogById(){
        checkLog = checkLogService.findCheckLogById(checkLogId);
    /*    SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = sFormat.parse(checkLog.getCreateAt().toString());
        } catch (ParseException e) {
            e.printStackTrace();
        }
        checkLog.setCreateAt(date);*/
        try {
//            HttpServletResponse response = (HttpServletResponse)ActionContext.getContext().get("response");
            HttpServletResponse response = ServletActionContext.getResponse();
            response.getWriter().write(JSON.toJSONStringWithDateFormat(checkLog,"yyyy-MM-dd HH:mm:ss"));
        }catch (IOException e){
            renderJson(checkLog);
        }
    }

}
