package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.EntityNotFoundException;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.NoPermissionException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.*;
import com.gtis.archive.service.*;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import freemarker.template.TemplateException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.json.JSONException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.IOException;
import java.util.*;

public class ScrutinyAction extends BaseModelAction<Archive> {

    private static final Object Lock = 0x001;

    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private DictService dictService;
    @Autowired
    private AjhRangeService ajhRangeService;

    @Autowired
    private OriginalService originalService;

    @Autowired
    private RecordAjhRangeService recordAjhRangeService;

    @Autowired
    private SysUserService userService;

    /**
     * tree id
     */
    private String treeId;
    /**
     * archive view type,wgd(未归档) ygd(已归档)
     */
    private String type;

    /**
     * 数据集合类型 new(由本单位发起的数据) old(互查单位的数据包括本单位的老数据)
     */
    private String data_type;
    /**
     * 所有定义的操作项
     */
    private List<Item> operations;
    private Map<String, String> topMenu;
    /**
     * 自动组盒用的目录号
     */
    private String mlh;
    /**
     * 自动组盒用的起始案卷号
     */
    private Integer ajh;

    /**
     * 自动组合截止案卷号
     */
    private Integer endAjh;
    /**
     * 自动组盒用装盒份数
     */
    private Integer boxSize;
    /**
     * 档案中卷内显示的字段
     */
    private Map docShowFields;
    private Map docFields;

    /**
     * 链接字段
     */
    private String linkField;

    private String docLinkField;

    private String dwdm;

    private String itemId;//互查业务权限

    private Boolean generic = false;

    private Boolean check;//是否显示证书状态,国有土地使用权登记、集体土地使用权登记和土地他项权利三种业务显示


    public Boolean getCheck() {
        if(modelName.equals("Tdsyqdj")||modelName.equals("Jttdsyqdj")||modelName.equals("Tdtxql"))
            return true;
        return false;
    }

    public void setCheck(Boolean check) {
        this.check = check;
    }

    public Boolean getGeneric() {
        if(tempTree==null)
            getTree();
        for(Map tempItem : tempTree){
            if (tempItem.get("name").equals(Constants.GENERIC)) {
                return  true;
            }
        }
        return generic;
    }

    public void setGeneric(Boolean generic) {
        this.generic = generic;
    }

    public String getItemId() {
        if(StringUtils.isBlank(itemId)){
            List<Item> items=dictService.getItems(Constants.HUCHA_PREFIX+userService.getUserRegionCode(SessionUtil.getCurrentUserId()));
            for(Item item:items){
                if(item.getValue().equals(dwdm)){
                    itemId=item.getId();
                    break;
                }
            }
        }
        return itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getDwdm() {
        return dwdm;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    public String getData_type() {
        return data_type;
    }

    public void setData_type(String data_type) {
        this.data_type = data_type;
    }

    @Override
    public void setModelName(String modelName) {
        super.setModelName(Document.toArchiveModelName(modelName));
    }

    @Override
    public String getModelName() {
        return super.getModelName();
    }


    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public void setAjh(Integer ajh) {
        this.ajh = ajh;
    }

    public void setEndAjh(Integer endAjh) {
        this.endAjh = endAjh;
    }

    public void setBoxSize(Integer boxSize) {
        this.boxSize = boxSize;
    }

    public Integer getBoxSize() {
        return boxSize;
    }

    public String getTreeId() {
        return treeId;
    }

    public String getType() {
        return type;
    }

    public List<Item> getOperations() {
        return operations;
    }


    public String getPermJson() {
        Map<String, Boolean> perm = new HashMap<String, Boolean>();
        String remark;
        if(StringUtils.isNotBlank(itemId)){
            Item huchaItem=dictService.getItem(itemId);
            if (StringUtils.isNotBlank(huchaItem.getRemark())){
                remark=huchaItem.getRemark().toString();
                JSONObject jsonObject=JSON.parseObject(remark);
                JSONArray items= (JSONArray) jsonObject.get("items");
                for (int i=0;i<items.size();i++){
                    String id=((JSONObject)items.get(i)).get("id").toString();
                    String huchaPerm=((JSONObject)items.get(i)).get("perm").toString();
                    if (id.equals(treeId)){
                        for (Item item : operations){
                            if (item.getName().equals(huchaPerm))
                                perm.put(item.getName(),true);
                        }
                    }
                }
            }
        }
        return JSON.toJSONString(perm);
    }

    public Map<String, Boolean> getPerms() {
        Map<String, Boolean> perm = new HashMap<String, Boolean>();
        for (Item item : operations) {
            if (securityService.isPermitted(treeId, item.getName()))
                perm.put(item.getName(), true);
        }
        return perm;
    }


    public String getTreeJson() throws JSONException {
        return JSON.toJSONString(rewrite(treeService.getTree(treeId)));
    }

    private List<Map<String, Object>> tree;

    private List<Map<String, Object>> tempTree;

    public List<Map<String, Object>> getTree() {
        if (tree == null) {
            List<Map<String, Object>> listTree = treeService.getAllTree(null, Constants.MODEL_ROOT);
            if(itemId==null){
                List<Item> items=dictService.getItems(Constants.HUCHA_PREFIX+userService.getUserRegionCode(SessionUtil.getCurrentUserId()));
                for(Item item:items){
                    if(item.getValue().equals(dwdm)){
                        itemId=item.getId();
                        break;
                    }
                }
            }
            if(StringUtils.isBlank(itemId)){
                for (Map item : listTree) {
                    logger.debug(item.toString());
                    if (item.get("name").equals(Constants.GENERIC)) {
                        listTree.remove(item);
                        break;
                    }
                }
            }else{
                Item item=dictService.getItem(itemId);
                List<Map<String, Object>> newTree=new ArrayList<Map<String, Object>>();
                if(item!=null&&item.getRemark()!=null&&StringUtils.isNotBlank(item.getRemark().toString())){
                    String remark=item.getRemark().toString();
                    JSONObject job= JSON.parseObject(remark);
                    JSONArray array=job.getJSONArray("items");
                    ArrayList<String> resIds = new ArrayList<String>();
                    for(int i=0;i<array.size();i++){
                        String resId=((JSONObject)array.get(i)).get("id").toString();
                        if(!resIds.contains(resId))
                            resIds.add(resId);
                    }
                    newTree=rewriteMap(listTree,resIds);
                    tempTree=rewriteMap(listTree,resIds);
                    for(Map tempItem : newTree){
                        if (tempItem.get("name").equals(Constants.GENERIC)) {
                            newTree.remove(tempItem);
                            break;
                        }
                    }
                    listTree=newTree;
                }else{//未配置的不可查看任何信息
                    listTree=new ArrayList<Map<String, Object>>();
//                    for (Map tempItem : listTree) {
//                        logger.debug(tempItem.toString());
//                        if (tempItem.get("name").equals(Constants.GENERIC)) {
//                            listTree.remove(tempItem);
//                            break;
//                        }
//                    }
                }
            }
            tree = listTree;
        }
        return tree;
    }


    private List<Map<String, Object>> rewriteMap(List<Map<String, Object>> listTree, List<String> resIds){
        List<Map<String, Object>> parentList=new ArrayList<Map<String, Object>>();
        if(listTree != null){
            for (Map tree : listTree){
                List<Map<String, Object>>childrenList=rewriteMap((List<Map<String, Object>>) tree.get("children"), resIds);
                String id = (String) tree.get("id");
                if(resIds.contains(id)||childrenList.size()!=0){
                    tree.put("children",childrenList);
                    parentList.add(tree);
                }
            }
        }

       return parentList;
    }


    public Map<String, String> getTopMenu() {
        if (topMenu == null) {
            topMenu = new LinkedHashMap<String, String>();
            for (Item item : dictService.getItems("archiveMenu")) {
                if ("true".equalsIgnoreCase(item.getValue())) {
                    topMenu.put(item.getName(), item.getRemark());
                }
            }
        }
        return topMenu;
    }

    @Override
    public String execute() {
        if (modelName == null || modelName.equals("Archive")) {
            List<Map<String, Object>> tree = getTree();
            for (Map<String, Object> map : tree) {
                List<Map<String, Object>> children = (List<Map<String, Object>>) map.get("children");
                if (children != null && children.size() > 0) {
                    modelName = children.get(0).get("name").toString();
                    break;
                }
            }
            if (modelName == null || modelName.equals("Archive"))
                return  Action.NONE;
        }
        String currentDwdm = getCurrentDwdm();
        boolean  hasPermission= false;
        try{
            List<Item> items = dictService.getItems(Constants.HUCHA_PREFIX + currentDwdm);
            for (Item item : items) {
                if (item.getValue().equals(this.dwdm)) {
                    hasPermission=true;
                }
            }
        }catch (Exception ex){

        }
        if(!hasPermission)
            return Action.NONE;
        operations = dictService.getItems(Constants.HUCHA_PERM);
        if (StringUtils.isNotEmpty(modelName)) {
            Resource res = resourceService.findChildResource(null, modelName, Constants.MODEL_ROOT);
            if (res != null) {
                treeId = res.getId();
                if (!securityService.isPermitted(treeId, Permission.VIEW_PERMISSION)) {
                    throw new NoPermissionException(modelName);
                }
            } else {
                throw new ModelNotFoundException(modelName);
            }
        }
        modelService.getModel(modelName);
        String id = getId();
        if (id != null) {
            Archive archive = archiveService.getArchive(modelName, id);
            if (archive != null) {
                type = archive.getState() == Archive.STATE_YGD ? "ygd" : "wgd";
            }
        }
        return Action.SUCCESS;
    }

    @Override
    protected Page<Archive> searchEntity(List<Criterion> criterions, List<Order> orders) {
            Page<Archive> page=null;
            if(Constants.HUCHA_DATA_NEW.equals(data_type)){
                page = archiveService.searchArchive(modelName, criterions, orders, getCurrentDwdm(),false, start, limit);
            }else if(Constants.HUCHA_DATA_OLD.equals(data_type)){
                page = archiveService.searchArchive(modelName, criterions, orders, dwdm,true, start, limit);
            }

            for (Archive archive : page.getItems()) {
                archive.setHasOriginal(originalService.hasOriginal(archive.getId()));
            }
            return page;
    }

    @Override
    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        if (ajh != null) {
            criterions.add(Restrictions.eq("mlh", mlh));
            criterions.add(Restrictions.gt("ajh", ajh));
            if (endAjh != null)
                criterions.add(Restrictions.lt("ajh", endAjh));
            sort = "ajh";
        } else {
            if (type == null || !type.equals("all"))
                criterions.add(Restrictions.eq("state", "ygd".equals(type) ? Archive.STATE_YGD : Archive.STATE_WGD));
            if (StringUtils.isNotBlank(treeId)) {
                if ("checkbox".equals(EnvHolder.getAppEnv().get(Switch.CLASSIFYVIEWMODE))) {
                    String[] treeIds = treeId.split(",");
                    if (treeIds.length == 1) {
                        if (resourceService.getResource(treeId).getName().equals(modelName)) {
                            criterions.add(Restrictions.or(Restrictions.eq("resourceId", treeId), Restrictions.isNull("resourceId")));
                        } else {
                            criterions.add(Restrictions.eq("resourceId", treeId));
                        }
                    } else {
                        if (treeIds.length > 2) {
                            Criterion temp = Restrictions.or(Restrictions.eq("resourceId", treeIds[0]), Restrictions.eq("resourceId", treeIds[1]));
                            for (int i = 2; i < treeIds.length; i++) {
                                temp = Restrictions.or(temp, Restrictions.eq("resourceId", treeIds[i]));
                            }
                            criterions.add(temp);
                        } else {
                            criterions.add(Restrictions.or(Restrictions.eq("resourceId", treeIds[0]), Restrictions.eq("resourceId", treeIds[1])));
                        }
                    }

                } else {
                    if (resourceService.getResource(treeId).getName().equals(modelName)) {
                        criterions.add(Restrictions.or(Restrictions.eq("resourceId", treeId), Restrictions.isNull("resourceId")));
                    } else {
                        criterions.add(Restrictions.eq("resourceId", treeId));
                    }
                }
            } else
                criterions.add(Restrictions.isNull("resourceId"));
        }
        return super.createCriterions(criterions);
    }

    @SuppressWarnings("unchecked")
    private List<Map<String, Object>> rewrite(List<Map<String, Object>> tree) {
        if (tree != null) {
            for (Map<String, Object> map : tree) {
                rewrite((List<Map<String, Object>>) map.get("children"));
                String id = (String) map.get("id");
                Map<String, Boolean> perm = new HashMap<String, Boolean>();
                for (Item item : operations) {
                    if (securityService.isPermitted(id, item.getName()))
                        perm.put(item.getName(), true);
                }
                map.put("perm", perm);
            }
        }
        return tree;
    }

    /**
     * 获得档案中案卷显示的字段
     *
     * @return
     */
    public Map getDocShowFields() {
        if (docShowFields == null) {
            try {
                Model doc = archiveService.getDocumentModel(modelName);
                docShowFields = JSON.parseObject(doc.getTemplate("showFields"), LinkedHashMap.class);
            } catch (ModelNotFoundException ex) {
            } catch (TemplateNotFoundException ex) {
                docShowFields = JSON.parseObject(getEntityTemplate("Document-showFields"), LinkedHashMap.class);
            }
        }
        return docShowFields;
    }

    /**
     * 获取档案中案卷所有字段
     *
     * @return
     */
    public Map getDocFields() {
        if (docFields == null) {
            try {
                Model doc = archiveService.getDocumentModel(modelName);
                docFields = doc.getInheritfieldsMap();
            } catch (ModelNotFoundException ex) {
            }
        }
        return docFields;
    }

    public String getLinkField() {
        if (linkField == null) {
            try {
                linkField = archiveService.getArchiveModel(modelName).getTemplate("linkField");
            } catch (Exception ex) {
                linkField = "tm";
            }
        }
        return linkField;
    }


    public String getDocLinkField() {
        if (docLinkField == null) {
            try {
                docLinkField = archiveService.getDocumentModel(modelName).getTemplate("linkField");
            } catch (ModelNotFoundException ex) {
            } catch (TemplateNotFoundException ex) {
                docLinkField = "tm";
            }
        }
        return docLinkField;
    }
    /**
     * 获取是否存在卷内案卷模型
     *
     * @return
     */
    public boolean getIsShowArchiveInfo() {
        try {
            if (modelService.getModel(modelName.concat("_ai")) != null) {
                return true;
            }
        } catch (ModelNotFoundException ex) {
            return false;
        }
        return false;
    }

    /**
     * 获取案卷是否存在卷内
     *
     * @return
     */
    public boolean getIsShowArchiveDoc() {
        try {
            if (modelService.getModel(modelName.concat("_jn")) != null) {
                return true;
            }

        } catch (ModelNotFoundException ex) {
            return false;
        }
        return false;
    }

    private List docEntities;

    /**
     * 获取档案相关卷内值
     *
     * @return
     */
    public List getDocEntities() {
        if (docEntities != null) return docEntities;
        docEntities = new ArrayList();
        if (ids.length > 0) {
            for (String id : ids) {
                docEntities.addAll(archiveService.getArchiveDocuments(modelName, id));
            }
        }
        return docEntities;
    }

    public void setIdString(String idString) {
        if (StringUtils.isNotBlank(idString))
            ids = idString.split(",");
    }

    /**
     * 过滤条件查询ｉｄ
     *
     * @return
     */
    public String searchIds() {
        List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
        List<Order> orders = createOrders(new ArrayList<Order>());
        List items = entityService.search(modelName, criterions, orders, start, limit).getItems();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.size(); i++) {
            try {
                sb.append(PropertyUtils.getProperty(items.get(i), "id") + ",");
            } catch (Exception e) {
                logger.error(e.toString());
            }
        }
        ids = sb.toString().split(",");
        return cacheIds();
    }

    private String getCurrentDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }
}
