package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.NoPermissionException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.entity.Permission;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.*;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

public class PaperAction extends BaseModelAction<Document> {
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private OriginalService originalService;

    @Autowired
    private SysUserService userService;
    /**
     * tree id
     */
    private String treeId;
    /**
     * document view type,wlj(未立卷) ylj(已立卷)
     */
    private String type;
    /**
     * 档案id
     */
    private String archiveId;

    /**
     * 链接字段
     */
    private String linkField;

    private String dwdm;

    private String itemId;

    private Boolean generic;

    public Boolean getGeneric() {
        if(StringUtils.isNotBlank(itemId)){
            Item item=dictService.getItem(itemId);
            generic=Boolean.parseBoolean(item.getParentId());
        }else{
            List<Item> items=dictService.getItems(Constants.HUCHA_PREFIX+userService.getUserRegionCode(SessionUtil.getCurrentUserId()));
            for(Item item:items){
                if(item.getValue().equals(dwdm)){
                    generic=Boolean.parseBoolean(item.getParentId());
                    break;
                }
            }
        }
        return generic;
    }

    public void setGeneric(Boolean generic) {
        this.generic = generic;
    }

    @Override
    public void setModelName(String modelName) {
        super.setModelName(Archive.toDocumentModelName(modelName));
    }

    public String getItemId() {
        if(StringUtils.isBlank(itemId)){
            List<Item> items=dictService.getItems(Constants.HUCHA_PREFIX+userService.getUserRegionCode(SessionUtil.getCurrentUserId()));
            for(Item item:items){
                if(item.getValue().equals(dwdm)){
                    itemId=item.getId();
                    break;
                }
            }
        }
        return itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public String getTreeId() {
        return treeId;
    }

    public String getType() {
        return type;
    }

    public String getDwdm() {
        return dwdm;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    public String getPermJson() {
        List<Item> operations = dictService.getItems(Permission.OPERATION_DICT);
        Map<String, Boolean> perm = new HashMap<String, Boolean>();
        for (Item item : operations) {
            if (item.getName().equals("view"))
                perm.put(item.getName(), true);
        }
        return JSON.toJSONString(perm);
    }
    private List<Map<String, Object>> tree;
    public List<Map<String, Object>> getTree() {
        if (tree == null) {
            List<Map<String, Object>> listTree = treeService.getAllTree(null, Constants.MODEL_ROOT);
            if(itemId==null){
                List<Item> items=dictService.getItems(Constants.HUCHA_PREFIX+userService.getUserRegionCode(SessionUtil.getCurrentUserId()));
                for(Item item:items){
                    if(item.getValue().equals(dwdm)){
                        itemId=item.getId();
                        break;
                    }
                }
            }
            if(StringUtils.isBlank(itemId)){
                for (Map item : listTree) {
                    logger.debug(item.toString());
                    if (item.get("name").equals(Constants.GENERIC)) {
                        listTree.remove(item);
                        break;
                    }
                }
            }else{
                Item item=dictService.getItem(itemId);
                List<Map<String, Object>> newTree=new ArrayList<Map<String, Object>>();
                if(item!=null&&item.getRemark()!=null&&StringUtils.isNotBlank(item.getRemark().toString())){
                    String remark=item.getRemark().toString();
                    JSONObject job= JSON.parseObject(remark);
                    JSONArray array=job.getJSONArray("items");
                    for(int i=0;i<array.size();i++){
                        String title=((JSONObject)array.get(i)).get("item").toString();
                        JSONArray ops=((JSONObject) array.get(i)).getJSONArray("op");
                        for(Map map : listTree){
                            if(map.get("name").equals(title)){
                                List<Map<String, Object>> list= (List<Map<String, Object>>) map.get("children");
                                List<Map<String, Object>> newList=new ArrayList<Map<String, Object>>();
                                for(Map child:list){
                                    for(int j=0;j<ops.size();j++){
                                        if(child.get("name").equals(ops.get(j))) {
                                            newList.add(child);
                                        }
                                    }
                                }
                                map.put("children",newList);
                                newTree.add(map);
                                break;
                            }
                        }
                    }
                    listTree=newTree;
                }else{//未标识业务权限的查看所有
                    for (Map tempItem : listTree) {
                        logger.debug(tempItem.toString());
                        if (tempItem.get("name").equals(Constants.GENERIC)) {
                            listTree.remove(tempItem);
                            break;
                        }
                    }
                }
            }
            tree = listTree;
        }
        return tree;
//        if (tree == null) {
//            List<Map<String, Object>> listTree = treeService.getAllTree(null, Constants.MODEL_ROOT);
//            for (Map item : listTree) {
//                logger.debug(item.toString());
//                if (item.get("name").equals(Constants.GENERIC)) {
//                    listTree.remove(item);
//                    break;
//                }
//            }
//            tree = listTree;
//        }
//        return tree;
    }

    @Override
    public String execute() throws Exception {
        String currentDwdm = getCurrentDwdm();
        boolean  hasPermission= false;
        try{
            List<Item> items = dictService.getItems(Constants.HUCHA_PREFIX + currentDwdm);
            for (Item item : items) {
                if (item.getValue().equals(this.dwdm)) {
                    hasPermission=true;
                }
            }
        }catch (Exception ex){

        }
        if(!hasPermission)
            return Action.NONE;
        if (StringUtils.isNotEmpty(modelName)) {
            Resource res = resourceService.findChildResource(null, Document.toArchiveModelName(modelName), Constants.MODEL_ROOT);
            if (res != null) {
                treeId = res.getId();
                if (!securityService.isPermitted(treeId, Permission.VIEW_PERMISSION)) {
                    throw new NoPermissionException(modelName);
                }
            } else {
                throw new ModelNotFoundException(modelName);
            }
        }
        modelService.getModel(modelName);
        String id = getId();
        if (id != null) {
            Document doc = archiveService.getDocument(modelName, id);
            if (doc != null) {
                type = doc.getArchiveId()==null ? "wlj" : "ylj";
            }
        }
        return Action.SUCCESS;
    }

    @Override
    protected Page<Document> searchEntity(List<Criterion> criterions, List<Order> orders) {
        if (StringUtils.isNotEmpty(archiveId)) {
            if(EnvHolder.isEnable(Switch.JIANGYIN)){
                List<Document> documents=  entityService.<Document>search(Archive.toDocumentModelName(modelName),
                        Collections.singletonList(Restrictions.eq("archiveId", archiveId)), orders, 0, Page.ALL).getItems();
                if(documents.size()>0){
                    documents.get(0).setArchive(archiveService.getArchive(modelName,archiveId));
                }
                return new Page<Document>(documents);
            }else {
                return new Page<Document>(entityService.<Document>search(Archive.toDocumentModelName(modelName),
                        Collections.singletonList(Restrictions.eq("archiveId", archiveId)), orders, 0, Page.ALL).getItems());
            }
        }
        if(EnvHolder.isEnable(Switch.JIANGYIN)){
            Page<Document> page= super.searchEntity(criterions, orders);
            for(Document document:page.getItems()){
                if(StringUtils.isNotBlank(document.getArchiveId())){
                    document.setArchive(archiveService.getArchive(modelName,document.getArchiveId()));
                }
                document.setHasOriginal(originalService.hasOriginal(document.getId()));
            }
            return page;
        }else{
            return super.searchEntity(criterions, orders);
        }

    }

    @Override
    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        if(type == null || !type.equals("all"))
            criterions.add("ylj".equals(type) ? Restrictions.isNotNull("archiveId") : Restrictions.isNull("archiveId"));
        return super.createCriterions(criterions);
    }

    @Override
    protected List<Order> createOrders(ArrayList<Order> orders) {
        List<Order> superOrders = super.createOrders(orders);
        if(superOrders.size()>0) return superOrders;
        if (StringUtils.isNotEmpty(archiveId))
            orders.add(Order.desc("sxh"));
        orders.add(Order.desc("id"));
        return super.createOrders(orders);
    }

    /**
     *  获取卷内所属的档案
     * @return
     */
    private Map docArchive;
    public Map getDocArchive(){
        try{
            if(docArchive==null) {
                docArchive = JSON.parseObject(JSON.toJSONString(archiveService.getArchive(modelName,archiveId), SerializerFeature.WriteMapNullValue));
                docArchive.remove("id");
            }
        }catch(Exception ex){
            logger.error(ex.toString());
        }
        return docArchive;
    }

    public String getLinkField(){
        if(linkField==null){
            try{
                linkField=archiveService.getDocumentModel(modelName).getTemplate("linkField");
            }catch (ModelNotFoundException ex){
            }catch (TemplateNotFoundException ex){
                linkField="tm";
            }
        }
        return linkField;
    }

    private String getCurrentDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }

}
