package com.gtis.archive.web;

import com.gtis.archive.Switch;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.NoPermissionException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Loan;
import com.gtis.archive.service.SecurityService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StandardBasicTypes;
import org.springframework.beans.factory.annotation.Autowired;

import java.text.Collator;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:wanggang@gtis.com.cn">WangGang</a>
 * @version V1.0, 2010-11-9
 */
public class LoanAction extends BaseModelAction<Loan> {
    @Autowired
    private SecurityService securityService;
    @Autowired
    private SysUserService userService;

    private String type;

    public void setType(String type) {
        this.type = type;
    }

    //归还档案
    public String returnLoan() {
        for (String id : ids) {
            if (StringUtils.isBlank(id))
                continue;
            Loan loan = entityService.load(Loan.class, id);
            loan.setState(1);
            entityService.save(loan);
        }
        return null;
    }

    @Override
    protected Page<Loan> searchEntity(final List<Criterion> criterions, final List<Order> orders) {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if ("return".equals(type)) {
            criterions.add(Restrictions.eq("state", 1));
        } else if ("exceed".equals(type)) {
            criterions.add(Restrictions.sqlRestriction("jyrq+jyqx<?", new Date(), StandardBasicTypes.DATE));
            criterions.add(Restrictions.eq("state", 0));
        } else {
            criterions.add(Restrictions.eq("state", 0));
        }
        if (query != null) {
            criterions.add(Restrictions.or(Restrictions.like("arc.tm", "%" + query + "%"), Restrictions.like("arc.dh", "%" + query + "%")));
        }
        if(EnvHolder.isEnable(Switch.DWDM) && !SessionUtil.getCurrentUser().isAdmin())
        {
            criterions.add(Restrictions.or(Restrictions.isNull("dwdm"),Restrictions.eq("dwdm",getDwdm())));
        }

        //取出市局用户的单位代码和现在的用户比较如果是市局用户，根据市局用户的单位代码进行查询，如果不是根据个人的id查询
        if(EnvHolder.getAppEnv().get(Switch.SJDWDM).equalsIgnoreCase(userInfo.getLstOragn().get(0).getRegionCode())){
            criterions.add(Restrictions.or(Restrictions.isNull("dwdm"),Restrictions.eq("dwdm",userInfo.getLstOragn().get(0).getRegionCode())));
        }else{
            criterions.add(Restrictions.or(Restrictions.isNull("userId"),Restrictions.eq("userId",userInfo.getId())));
        }

        return entityService.search(Loan.class,criterions,orders,start,limit);
//        return entityService.search(new CriteriaCallback() {
//            public Criteria create(Session session) {
//                return session.createCriteria(Loan.class).createAlias("archive", "arc");
//            }
//        }, criterions, orders, start, limit);
    }

    @Override
    protected String[] getQueryFields() {
        return null;
    }

    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }

    @Override
    public String execute() throws Exception {
        if (!securityService.isPermitted("sys", "loan")) {
            throw new NoPermissionException("没有权限访问借阅管理");
        }
        return super.execute();
    }

    public String list() throws Exception {
        try {
            renderJson(sortPage(getEntityPage()));
        } catch (Exception e) {
            renderJson(sortPage(new Page()));
        }
        return null;
    }

    //排序借阅登记表内的数据，按照目录号从小到大，同一目录号下案卷号从小到大的顺序排列
    public Page<Loan> sortPage(Page<Loan> entityPage) {
        List<Loan> loans = entityPage.getItems();

        Collections.sort(loans, new Comparator<Loan>() {
            @Override
            public int compare(Loan o1, Loan o2) {
               //int value = Integer.parseInt(o1.getMlh()) - Integer.parseInt(o2.getMlh());
                int value = Collator.getInstance(Locale.CHINESE).compare(o1.getMlh(),o2.getMlh());
                if (value == 0) {
                    if(o1.getAjh()!=null&&o2.getAjh()!=null){
                        value = Integer.parseInt(o1.getAjh()) - Integer.parseInt(o2.getAjh()) > 0 ? 1 : -1;
                        return value;
                    }else{
                        return -1;
                    }
                } else {
                    return value > 0 ? 1 : -1;
                }
            }
        });

        entityPage.setItems(loans);

        return entityPage;
    }

    /**
     * 重写父类方法，获取数据按照sortPage方法的排序进行排序
     * @return
     */
    public List getEntities() {
        entities = super.getEntities();
        return sortPage(new Page(entities)).getItems();
    }
}
