package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.AjhRange;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.RecordAjhRange;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.*;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ResourceUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.text.Collator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-3-20
 */
public class GenericAction extends BaseModelAction<Object> {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private AjhRangeService ajhRangeService;

    @Autowired
    private OriginalService originalService;

    @Autowired
    private ArchiveService archiveService;

    @Autowired
    private RecordAjhRangeService recordAjhRangeService;

    private AjhRange ajhRange;

    private Integer sbjh;

    private String linkField;

    /**
     * 年度
     */
    private String nd;


    /**
     * tree id
     */
    private String treeId;

    private String tplName;

    private String status;

    private String printType;

    private Boolean isPrint = false;

    private String dataField = "" ; //存储日期字段的名称

    private String buttonType;

    /**
     * 收文的发送类型，已发送还是未发送
     */
    private String changeType;

    /**
     * 需要更新状态的收文
     */
    private String swIds ;

    public String getTreeId() {
        return treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setTplName(String tplName) {
        this.tplName = tplName;
    }

    public String getTreeJson() throws JSONException {
        return JSON.toJSONString(treeService.getTree2(treeId));
    }

    public int getLimit() {
        return limit;
    }

    public String getPrintType() {
        return printType;
    }

    public void setPrintType(String printType) {
        this.printType = printType;
    }

    @Override
    public void setId(String[] ids) {
        this.ids = ids;
    }

    @Override
    public void setStart(int start) {
        super.setStart(start);
    }

    public String getNd() {
        return nd;
    }

    public void setNd(String nd) {
        this.nd = nd;
    }

    public String getButtonType() {
        return buttonType;
    }

    public void setButtonType(String buttonType) {
        this.buttonType = buttonType;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public String getSwIds() {
        return swIds;
    }

    public void setSwIds(String swIds) {
        this.swIds = swIds;
    }

    public String getModelName() {
        return modelName;
    }

    @Override
    public Map getShowFields() {
        Map showFields = null;
        try {
            showFields = super.getShowFields();
        } catch (TemplateNotFoundException ex) {
            logger.error(ex.getMessage());
        }

        Map tempShowFields = new HashMap() ;

        //预归档的里面不需要室编件号属性
        if("pgd".equals(modelName)){
            Set<String> sets = showFields.keySet() ;
            Iterator<String> iterator = sets.iterator() ;
            while (iterator.hasNext()) {
                String keySet = iterator.next();
//                if ("sbjh".equals(keySet)) {
//                    continue;
//                }
                tempShowFields.put(keySet, showFields.get(keySet)) ;
            }
        } else if("ygd".equals(modelName)){   //已归档的里面不需要登记号和件号两个属性
            Set<String> sets = showFields.keySet() ;
            Iterator<String> iterator = sets.iterator() ;
            while (iterator.hasNext()) {
                String keySet = iterator.next();
                if ("djh".equals(keySet) || "jh".equals(keySet)) {
                    continue;
                }

                tempShowFields.put(keySet, showFields.get(keySet)) ;
            }
        }else{
            tempShowFields = showFields ;
        }
        return tempShowFields;
    }

    @Override
    protected String[] getQueryFields() {
        String[] qFields = null;
        try {
            qFields = super.getQueryFields();
        } catch (TemplateNotFoundException ex) {
            logger.error(ex.getMessage());
        }
        return qFields;
    }

    @Override
    public String execute() {
        if (treeId == null) {
            Resource res = resourceService.findChildResource(null, Constants.GENERIC, Constants.MODEL_ROOT);
            treeId = res.getId();
        }
        /*if (!securityService.isPermitted(treeId, Permission.VIEW_PERMISSION)) {
            throw new NoPermissionException(treeId);
        }*/
        return Action.SUCCESS;
    }

    /**
     * @return
     */
    public String tpl() {
        try {
            if (tplName.indexOf("list") > -1) {
                try {
                    renderModelTemplate(tplName);
                } catch (TemplateNotFoundException e) {
                    renderModelTemplate("Generic-list");
                }
            } else {
                renderModelTemplate(tplName);
            }
        } catch (Exception e) {
            logger.error(e.getLocalizedMessage());
        }
        return null;
    }

    /**
     * 撤销预归档
     *
     * @return
     */
    public String cxyGd() {
        try {
            List<Object> entities = orderEntities();
            for (Object entity : entities) {
                if (PropertyUtils.getProperty(entity, "status") == null || !"pgd".equals(PropertyUtils.getProperty(entity, "status").toString()))
                    continue;
                String mlh = PropertyUtils.getProperty(entity, "qzh") + "-" + PropertyUtils.getProperty(entity, "nd") + "-" + PropertyUtils.getProperty(entity, "bgqx") + "-" + PropertyUtils.getProperty(entity, "flh");
                RecordAjhRange recordAjhRange = new RecordAjhRange();
                recordAjhRange.setMlh(mlh);
                recordAjhRange.setAjh(Integer.parseInt(PropertyUtils.getProperty(entity, "sbjh").toString()));
                recordAjhRange.setModelName(modelName);
                recordAjhRange.setDwdm(getDwdm());
                PropertyUtils.setProperty(entity, "status", "xgd");
                PropertyUtils.setProperty(entity, "sbjh", null);
                entityService.save(entity);
                recordAjhRangeService.saveRecordAjh(recordAjhRange);
            }
        } catch (Exception ex) {

        }
        return null;
    }

    @Override
    public String remove() throws Exception{
        if(EnvHolder.isEnable(Switch.JIANGYIN)){
            for(String id :ids){
                Object entity = entityService.load(modelName, id);
                RecordAjhRange recordAjhRange=new RecordAjhRange();
                recordAjhRange.setModelName(modelName);
                recordAjhRange.setAjh(123);
                recordAjhRange.setMlh("sss");
                recordAjhRange.setDjh(Integer.valueOf(String.valueOf(PropertyUtils.getProperty(entity, "djh"))).intValue());
                recordAjhRangeService.saveRecordAjh(recordAjhRange);
            }
        }
        super.remove();
        return null;
    }


    public String modify() {
        try {
            if ("ygd".equals(status) || "pgd".equals(status)) {
                List<Object> entities = orderEntities();
                for (Object entity : entities) {    //生成的室编件号先从已废弃中的使用，没有再找新的
                    if (PropertyUtils.getProperty(entity, "sbjh") == null) {
                        String mlh = PropertyUtils.getProperty(entity, "qzh") + "-" + PropertyUtils.getProperty(entity, "nd") + "-" + PropertyUtils.getProperty(entity, "bgqx") + "-" + PropertyUtils.getProperty(entity, "flh");
                        RecordAjhRange recordAjhRange = recordAjhRangeService.getAvailable(mlh, modelName, getDwdm());
                        if (recordAjhRange == null) {
                            PropertyUtils.setProperty(entity, "sbjh", String.valueOf(getSbjh(mlh)));
                        } else {
                            PropertyUtils.setProperty(entity, "sbjh", String.valueOf(recordAjhRange.getAjh()));
                            recordAjhRangeService.remove(recordAjhRange.getId());
                        }
                    }
                    PropertyUtils.setProperty(entity, "status", status);
                    entityService.save(entity);
                    if (sbjh != null) {
                        ajhRange.setCurrentValue(sbjh);
                        ajhRangeService.saveAjhRange(ajhRange);
                    }
                }
            } else {
                modifyAuto();
            }
        } catch (Exception ex) {
            logger.error(ex.toString());
        }
        return null;
    }

    private String modifyAuto() throws Exception {
        for (String id : ids) {
            Object entity = entityService.load(modelName, id);
            if (PropertyUtils.getProperty(entity, "status").equals(status)) {
                return "";
            }
            PropertyUtils.setProperty(entity, "status", status);
            entityService.save(entity);
        }
        return "";
    }

    public String modify2() {
        for (String id : ids) {
            Object entity = entityService.load(modelName, id);
            try {
                if (PropertyUtils.getProperty(entity, "status").equals(status)) {
                    return "";
                }
                if ("ygd".equals(status)) {
                    String mlh = PropertyUtils.getProperty(entity, "qzh") + "-" + PropertyUtils.getProperty(entity, "nd") + "-" + PropertyUtils.getProperty(entity, "bgqx") + "-" + PropertyUtils.getProperty(entity, "flh");
                    PropertyUtils.setProperty(entity, "sbjh", String.valueOf(getSbjh(mlh)));
                }
                PropertyUtils.setProperty(entity, "status", status);
            } catch (Exception e) {
                logger.error(e.toString());
            }
            entityService.save(entity);
            if (sbjh != null) {
                ajhRange.setCurrentValue(sbjh);
                ajhRangeService.saveAjhRange(ajhRange);
            }
        }
        return "";
    }

    private List orderEntities() {
        List<Object> entities = new ArrayList<Object>();
        for (String id : ids) {
            Object entity = entityService.load("ythsw", id);
            if (entity == null)
                entity = entityService.load("ythfw", id);
            if (entity == null)
                entity = entityService.load("ythnw", id);
            entities.add(entity);
        }
        return addAll(entities, null, null);
    }

    public String years() {
        List<Criterion> criterions = new ArrayList<Criterion>();
        criterions.add(Restrictions.eq("status", status));
        Page<Object> page = searchEntityAll(criterions, null);
        List<Object> list = page.getItems();
        List<String> years = new ArrayList<String>();
        for (Object object : list) {
            try {
                String year = PropertyUtils.getProperty(object, "nd").toString();
                if (!years.contains(year)) {
                    years.add(year);
                }
            } catch (Exception ex) {
            }
        }
        renderJson(years);
        return null;
    }


    public String modifyAll() {
        if (StringUtils.isBlank(nd)) return null;
        List<Criterion> criterions = new ArrayList<Criterion>();
        criterions.add(Restrictions.eq("nd", nd));
        if ("pgd".equals(status)) {
            criterions.add(Restrictions.eq("status", "xgd"));
        } else {
            criterions.add(Restrictions.eq("status", "pgd"));
        }
        List<Order> orders = new ArrayList<Order>();
        orders.add(Order.asc("cwrq"));
        Page<Object> page = searchEntityAll(criterions, orders);
        try {
            if ("pgd".equals(status)) {
                ytygd(page); //一体预归档
            } else {
                gd(page);//一体归档
            }
        } catch (Exception ex) {
            logger.error(ex.toString());
        }
        return "";
    }


/**
     * 获取所有室编件号
     *
     * @return
     */

    public String saveSbjh() throws Exception {
//        if(StringUtils.isBlank(nd)) return null;
        List<Criterion> criterions = new ArrayList<Criterion>();
//        criterions.add(Restrictions.eq("nd",nd));
        criterions.add(Restrictions.eq("status", "pgd"));
        List<Order> orders = new ArrayList<Order>();
        orders.add(Order.asc("cwrq"));

        Page<Object> page = searchEntityAll(criterions, orders);
        for (int i = 0; i < page.getTotalCount(); i++) {
            Object entity = page.getItem(i);
            if (PropertyUtils.getProperty(entity, "sbjh") != null && !"".equals(PropertyUtils.getProperty(entity, "sbjh").toString().trim()))
                continue;
            String mlh = PropertyUtils.getProperty(entity, "nd") + "-" + PropertyUtils.getProperty(entity, "bgqx") + "-" + PropertyUtils.getProperty(entity, "flh");
            RecordAjhRange recordAjhRange = recordAjhRangeService.getRecordAjhRange(mlh, "Wdyth");
            if (recordAjhRange != null) {
                PropertyUtils.setProperty(entity, "sbjh", String.valueOf(recordAjhRange.getAjh()));
                entityService.save(entity);
                recordAjhRangeService.remove(recordAjhRange.getId());
            } else {
                AjhRange ajhRange = null;
                try {
//                    ajhRange = ajhRangeService.getAjhRangesForGeneric("Wdyth", mlh);              //不区分单位代码生成事件编号
                    ajhRange = ajhRangeService.getAjhRangesByDwdmForGeneric("Wdyth",mlh,getDwdm());
                } catch (Exception ex) {
                    AjhRange ajhRangeTemp = new AjhRange();
                    if (EnvHolder.isEnable(Switch.INDIVIDUAL_MLH))
                        ajhRangeTemp.setDwdm(getDwdm());
                    ajhRangeTemp.setMlh(mlh);
                    ajhRangeTemp.setCurrentValue(0);
                    ajhRangeTemp.setMinValue(0);
                    ajhRangeTemp.setMaxValue(1000);
                    ajhRangeTemp.setModelName("Wdyth");
                    ajhRangeService.saveAjhRange(ajhRangeTemp);
                    ajhRange = ajhRangeService.getAjhRangesForGeneric("Wdyth", mlh);
                }
                if (ajhRange.hasExhausted()) {
                    ajhRange.setMaxValue(ajhRange.getMaxValue() + 100);
                    ajhRangeService.saveAjhRange(ajhRange);
                }
                int sbjh = ajhRange.getNextValue();
                PropertyUtils.setProperty(entity, "sbjh", String.valueOf(sbjh));
                entityService.save(entity);
                ajhRange.setCurrentValue(sbjh);
                ajhRangeService.saveAjhRange(ajhRange);
            }
        }
        return "";
    }

   /* *//**
     * 获取所有室编件号
     *
     * @return
     *//*
    public String saveSbjh() throws Exception {
//        if(StringUtils.isBlank(nd)) return null;
        List<Criterion> criterions = new ArrayList<Criterion>();
//        criterions.add(Restrictions.eq("nd",nd));
        criterions.add(Restrictions.eq("status", "pgd"));
        List<Order> orders = new ArrayList<Order>();
        orders.add(Order.asc("cwrq"));
        Page<Object> page = searchEntityAll(criterions, orders);
        for (int i = 0; i < page.getTotalCount(); i++) {
            Object entity = page.getItem(i);
            if (PropertyUtils.getProperty(entity, "sbjh") != null)
                continue;
            String mlh = PropertyUtils.getProperty(entity, "qzh") + "-" + PropertyUtils.getProperty(entity, "nd") + "-" + PropertyUtils.getProperty(entity, "bgqx") + "-" + PropertyUtils.getProperty(entity, "flh");
            RecordAjhRange recordAjhRange = recordAjhRangeService.getRecordAjhRange(mlh, "Wdyth");
            if (recordAjhRange != null) {
                PropertyUtils.setProperty(entity, "sbjh", String.valueOf(recordAjhRange.getAjh()));
                entityService.save(entity);
                recordAjhRangeService.remove(recordAjhRange.getId());
            } else {
                AjhRange ajhRange = null;
                try {
                    ajhRange = ajhRangeService.getAjhRangesForGeneric("Wdyth", mlh);
                } catch (Exception ex) {
                    AjhRange ajhRangeTemp = new AjhRange();
                    if (EnvHolder.isEnable(Switch.INDIVIDUAL_MLH))
                        ajhRangeTemp.setDwdm(getDwdm());
                    ajhRangeTemp.setMlh(mlh);
                    ajhRangeTemp.setCurrentValue(0);
                    ajhRangeTemp.setMinValue(0);
                    ajhRangeTemp.setMaxValue(1000);
                    ajhRangeTemp.setModelName("Wdyth");
                    ajhRangeService.saveAjhRange(ajhRangeTemp);
                    ajhRange = ajhRangeService.getAjhRangesForGeneric("Wdyth", mlh);
                }
                if (ajhRange.hasExhausted()) {
                    ajhRange.setMaxValue(ajhRange.getMaxValue() + 100);
                    ajhRangeService.saveAjhRange(ajhRange);
                }
                int sbjh = ajhRange.getNextValue();
                PropertyUtils.setProperty(entity, "sbjh", String.valueOf(sbjh));
                entityService.save(entity);
                ajhRange.setCurrentValue(sbjh);
                ajhRangeService.saveAjhRange(ajhRange);
            }
        }
        return "";
    }
*/

    /**
     * 一体预归档，生成件号，不生成室编件号
     * 件号不连续向后续编,件号规则，jh-qzh-nd-bgqx-flh,modelName为Wdyth,存在t_ajh_range t中
     *
     * @param page
     * @return
     */
    private String ytygd(Page<Object> page) throws Exception {
        for (int i = 0; i < page.getTotalCount(); i++) {
            Object entity = page.getItem(i);
            String mlh = "jh-" + PropertyUtils.getProperty(entity, "qzh") + "-" + PropertyUtils.getProperty(entity, "nd") + "-" + PropertyUtils.getProperty(entity, "bgqx") + "-" + PropertyUtils.getProperty(entity, "flh");
            PropertyUtils.setProperty(entity, "jh", String.valueOf(getSbjh(mlh)));
            PropertyUtils.setProperty(entity, "status", status);
            entityService.save(entity);
            if (sbjh != null) {
                ajhRange.setCurrentValue(sbjh);
                ajhRangeService.saveAjhRange(ajhRange);
            }
        }
        return null;
    }

    /**
     * 将所有需归档的档案进行归档操作
     *
     * @param page
     * @return
     * @throws Exception
     */
    public String gd(Page<Object> page) throws Exception {
        for (int i = 0; i < page.getTotalCount(); i++) {
            Object entity = page.getItem(i);
//            String mlh=PropertyUtils.getProperty(entity,"qzh")+"-"+PropertyUtils.getProperty(entity,"nd")+"-"+PropertyUtils.getProperty(entity,"bgqx")+"-"+PropertyUtils.getProperty(entity,"flh");
//            PropertyUtils.setProperty(entity,"sbjh",String.valueOf(getSbjh(mlh)));
            if (PropertyUtils.getProperty(entity, "sbjh") == null)
                continue;
            PropertyUtils.setProperty(entity, "status", status);
            entityService.save(entity);
//            if(sbjh!=null){
//                ajhRange.setCurrentValue(sbjh);
//                ajhRangeService.saveAjhRange(ajhRange);
//            }
        }
        return null;
    }

    /**
     * 检索收文，发文，内文中的档案，并根据成文日期排序
     *
     * @param criterions
     * @param orders
     * @return
     */
    private Page<Object> searchEntityAll(List<Criterion> criterions, List<Order> orders) {
        List<Criterion> list = new ArrayList<Criterion>(criterions);
        if (EnvHolder.isEnable(Switch.DWDM) && !SessionUtil.getCurrentUser().isAdmin()) {
            try {
                boolean hasDwdm = PropertyUtils.getProperty(entityService.<Object>newInstance(modelName), "dwdm") == null;
                list.add(Restrictions.or(Restrictions.isNull("dwdm"), Restrictions.eq("dwdm", getDwdm())));
            } catch (Exception ex) {
                logger.error(ex.toString() + "{该业务没有设置单位代码}");
            }
        }
        Page page = new Page();
        List all = addAll(entityService.search("ythsw", list, orders, start, -1).getItems(),
                entityService.search("ythfw", list, orders, start, -1).getItems(),
                entityService.search("ythnw", list, orders, start, -1).getItems());
        int totalCount = all.size();
        page.setItems(all);
        page.setTotalCount(totalCount);
        return page;
    }

    @Override
    protected Page<Object> searchEntity(List<Criterion> criterions, List<Order> orders) {
        List<Criterion> list = new ArrayList<Criterion>(criterions);
        boolean hasDwdm = false;
        if (EnvHolder.isEnable(Switch.DWDM) && !SessionUtil.getCurrentUser().isAdmin()) {
            try {
                if (modelName.equals("ygd") || modelName.equals("pgd")) {
                    hasDwdm = false;
                    for(Field field : modelService.getModel("ythsw").getFields()){
                        if("dwdm".equalsIgnoreCase(field.getName())){
                            hasDwdm = true;
                            break;
                        }
                    }

                    if("daglry".equals(modelName)){
                        list.add(Restrictions.or(Restrictions.isNull("dwdm"), Restrictions.eq("dwdm", getDwdm())));
                    }
                } else {
//                    boolean hasDwdm = PropertyUtils.getProperty(entityService.<Object>newInstance(modelName), "dwdm") == null;
                    hasDwdm = false;
                    for(Field field : modelService.getModel(modelName).getFields()){
                        if("dwdm".equalsIgnoreCase(field.getName())){
                            hasDwdm = true;
                            break;
                        }
                    }
                }
                if(hasDwdm){
                    list.add(Restrictions.or(Restrictions.isNull("dwdm"), Restrictions.eq("dwdm", getDwdm())));
                }

            } catch (Exception ex) {
                logger.error(ex.toString() + "{该业务没有设置单位代码}");
            }
        }
        if (modelName.equals("ygd") || modelName.equals("pgd")) {
            list.add(Restrictions.eq("status", modelName));
            Page page = new Page();
            List all = new ArrayList() ;
            /**
            //如果为预归档则调用预归档排序，如果是已归档的则调用已归档的排序
            if(modelName.equals("ygd")){
                all = ygdSort(entityService.search("ythsw", list, orders, 0, -1).getItems(),
                        entityService.search("ythfw", list, orders, 0, -1).getItems(),
                        entityService.search("ythnw", list, orders, 0, -1).getItems());
            }else if(modelName.equals("pgd")){
                all = pgdSort(entityService.search("ythsw", list, orders, 0, -1).getItems(),
                        entityService.search("ythfw", list, orders, 0, -1).getItems(),
                        entityService.search("ythnw", list, orders, 0, -1).getItems());
            }else if(modelName.equals("daglzhcl")  || modelName.equals("dasj") || modelName.equals("dazl") || modelName.equals("dajd")
                    || modelName.equals("dabg") || modelName.equals("datj") || modelName.equals("daly") || modelName.equals("daglxjsyy")){
                all = qzjSort(entityService.search("ythsw", list, orders, 0, -1).getItems(),
                        entityService.search("ythfw", list, orders, 0, -1).getItems(),
                        entityService.search("ythnw", list, orders, 0, -1).getItems());
            }else{
                all = ygdSort(entityService.search("ythsw", list, orders, 0, -1).getItems(),
                        entityService.search("ythfw", list, orders, 0, -1).getItems(),
                        entityService.search("ythnw", list, orders, 0, -1).getItems());
            }
            */

            if(modelName.equals("ygd")){
                List ythsw = entityService.search("ythsw", list, orders, 0, -1).getItems();
                List ythfw = entityService.search("ythfw", list, orders, 0, -1).getItems();
                List ythnw = entityService.search("ythnw", list, orders, 0, -1).getItems();
                all = ygdSortByCwrq(ythsw,ythfw,ythnw);
            }else if(modelName.equals("pgd")){
                all = pgdSort1(entityService.search("ythsw", list, orders, 0, -1).getItems(),
                        entityService.search("ythfw", list, orders, 0, -1).getItems(),
                        entityService.search("ythnw", list, orders, 0, -1).getItems());
            }

            int totalCount = all.size();

            int end = start + limit;
            if (totalCount < end||end == -1)
                end = totalCount;
            List temp = all.subList(start, end);
            page.setItems(temp);
            page.setTotalCount(totalCount);
            return page;
        }

    /*    //如果是业务活动里面的都要进行日期字段的排序
        if(modelName.equals("zljcdj") || modelName.equals("wsddj") || modelName.equals("ywzd")
                ||  modelName.equals("xcgz") || modelName.equals("dafwtz")){
            Page page = new Page();
            List all = new ArrayList() ;

            all = ywhdSort(entityService.search(modelName, list, orders, 0, -1).getItems());

            int totalCount = all.size();
            int end = start + limit;
            if (totalCount < end||end == -1)
                end = totalCount;
            List temp = all.subList(start, end);
            page.setItems(temp);
            page.setTotalCount(totalCount);
            return page;
        }*/

       /* LinkedHashMap<String, String>  fields = getOrderFields();
        Set<String> keys = fields.keySet() ;
        if (fields != null) {
            Criterion cr = null;
            for (String field : keys) {
                cr = Restrictions.sqlRestriction("to_date("+field+",yyyy-MM-dd)");

                if (cr != null) {
                    criterions.add(cr) ;
                }
            }

        }*/

        if (isPrint)
            return entityService.search(modelName, list, orders, start, limit);
        Page page = entityService.search(modelName, list, orders, start, limit);
        List<Object> lists = page.getItems();
        for (Object object : lists) {
            try {
                String id = PropertyUtils.getProperty(object, "id").toString();
                PropertyUtils.setProperty(object, "hasOriginal", originalService.hasOriginal(id));
            } catch (Exception e) {
                break;
            }
        }
//        return entityService.search(modelName, list, orders, start, limit);
        return page;
    }


    private Object getObject(String id) {
        if (StringUtils.isNotBlank(id)) {
            try {
                Object object = null;
                object = entityService.load("ythsw", id);
                if (object == null)
                    object = entityService.load("ythfw", id);
                if (object == null)
                    object = entityService.load("ythnw", id);
                return object;
            } catch (Exception ex) {

            }
        }
        return null;
    }

    @Override
    protected Page<Object> getEntityPage() {
        if (StringUtils.isNotEmpty(idsKey)) {
            ids = idsCaches.get(idsKey);
        }
        if (ids != null) {
            entities = new ArrayList<Object>(ids.length);
            for (String id : ids) {
                if ("ygd".equals(modelName)) {
                    entities.add(getObject(id));
                } else {
                    entities.add(entityService.<Object>load(modelName, id));
                }

            }
            if("ythfw".equals(modelName)){
                return new Page<Object>(sortByWh(entities));
            }
            return new Page<Object>(entities);
        }
        List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
        List<Order> orders = createOrders(new ArrayList<Order>());
        return searchEntity(criterions, orders);
    }

    /**
     *
     * @param ythSw
     * @param ythFw
     * @param ythNw
     * @return
     */
    public List sortByDjh(List ythSw, List ythFw, List ythNw){
        return null;
    }


    /**
     *按照文号进行排序
     * @param ythfw
     * @return
     */
    private List sortByWh(List ythfw){
        Collections.sort(ythfw, new Comparator() {
            @Override
            public int compare(Object o1, Object o2) {
                try {
                    int value = 0;
                    String wh1 = PropertyUtils.getProperty(o1,"wh").toString();
                    String wh2 = PropertyUtils.getProperty(o2,"wh").toString();
                    value = Collator.getInstance(Locale.CHINESE).compare(wh1, wh2);

                    return value;

                } catch (Exception e) {
                    e.printStackTrace();
                    logger.error("sort by with error:" + e.toString());
                }
                return 0;
            }
        });

        return ythfw;
    }

    /**
     * “已归档”列表中，按照年度-保管期限-分类号-室编件号来进行列表排序
     * @param ythSw
     * @param ythFw
     * @param ythNw
     * @return
     */
    private List ygdSort(List ythSw, List ythFw, List ythNw) {
        ArrayList<Object> tempList = new ArrayList<Object>();
        if (ythSw != null)
            tempList.addAll(ythSw);
        if (ythFw != null)
            tempList.addAll(ythFw);
        if (ythNw != null)
            tempList.addAll(ythNw);
        Collections.sort(tempList, new Comparator() {
            public int compare(Object a, Object b) {
                int value = 0;
                try {
                    int aYear = Integer.parseInt(PropertyUtils.getProperty(a, "nd").toString());
                    int bYear = Integer.parseInt(PropertyUtils.getProperty(b, "nd").toString());
                    if (aYear == bYear) {  //年度相同
                        String aBGQX = PropertyUtils.getProperty(a, "bgqx").toString();
                        String bBGQX = PropertyUtils.getProperty(b, "bgqx").toString();
                        value = Collator.getInstance(Locale.CHINESE).compare(aBGQX, bBGQX);
                        if (value == 0) {//保管期限相同
                            String aFLH = PropertyUtils.getProperty(a, "flh").toString();
                            String bFLH = PropertyUtils.getProperty(b, "flh").toString();
                            value = Collator.getInstance(Locale.CHINESE).compare(aFLH, bFLH);
                            if (value == 0) {//分类号相同
                                int aSBJH = Integer.parseInt(PropertyUtils.getProperty(a, "sbjh").toString());
                                int bSBJH = Integer.parseInt(PropertyUtils.getProperty(b, "sbjh").toString());
                                if (aSBJH == bSBJH) {  //sbjh相同

                                } else {
                                    value = aSBJH - bSBJH > 0 ? 1 : -1;
                                }
                            }
                        }
                    } else {
                        value = aYear - bYear > 0 ? 1 : -1;
                    }
                } catch (Exception ex) {

                }
                return value;
            }
        });
        return tempList;
    }

    /**
     * 已归档按照成文时间降序
     * @param ythSw
     * @param ythFw
     * @param ythNw
     * @return
     */
    private List ygdSortByCwrq(List ythSw, List ythFw, List ythNw) {
        ArrayList<Object> tempList = new ArrayList<Object>();
        ArrayList<Object> tempList2 = new ArrayList<Object>();
        ArrayList<Object> emptyList = new ArrayList<Object>();
        if (ythSw != null)
            tempList.addAll(ythSw);
        if (ythFw != null)
            tempList.addAll(ythFw);
        if (ythNw != null)
            tempList.addAll(ythNw);

        tempList2.addAll(tempList);

        /**
         * 把成文日期为空的单独存储到emptyList集合当中去
         */
        for(Object object : tempList){
            try {
                Object ob1 = PropertyUtils.getProperty(object,"cwrq");
                if(ob1==null){
                    emptyList.add(object);
                    tempList2.remove(object);
                }
            } catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }



        Collections.sort(tempList2, new Comparator<Object>() {
            @Override
            public int compare(Object o1, Object o2) {
                int value = 0;
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

                try {
                    Object ob1 = PropertyUtils.getProperty(o1,"cwrq");
                    Object ob2 = PropertyUtils.getProperty(o2,"cwrq");
                    String d1 = null;
                    String d2 = null;
                    Date date1 = null;
                    Date date2 = null;

                    if(ob1 instanceof Timestamp){
                        date1 = (Date)ob1;
                    }else if(ob1 instanceof String){
                        d1 = (String)ob1;
                        date1 = dateFormat.parse(d1);
                    }

                    if(ob2 instanceof Timestamp){
                        date2 = (Date)ob2;
                    }else if(ob2 instanceof String){
                        d2 = (String)ob2;
                        date2 = dateFormat.parse(d2);
                    }

                    value = date2.compareTo(date1);
                }catch (Exception ex){
                    ex.printStackTrace();
                    logger.error(ex.getMessage());
                }

                return value;
            }
        });

        tempList2.addAll(emptyList);
        return tempList2;
    }

    /**
     * “预归档”列表中，按照年度-保管期限-分类号-件号来进行列表排序
     * @param ythSw
     * @param ythFw
     * @param ythNw
     * @return
     */
    private List pgdSort(List ythSw, List ythFw, List ythNw) {
        ArrayList<Object> tempList = new ArrayList<Object>();
        if (ythSw != null)
            tempList.addAll(ythSw);
        if (ythFw != null)
            tempList.addAll(ythFw);
        if (ythNw != null)
            tempList.addAll(ythNw);
        Collections.sort(tempList, new Comparator() {
            public int compare(Object a, Object b) {
                int value = 0;
                try {
                    int aYear = Integer.parseInt(PropertyUtils.getProperty(a, "nd").toString());
                    int bYear = Integer.parseInt(PropertyUtils.getProperty(b, "nd").toString());
                    if (aYear == bYear) {  //年度相同
                        String aBGQX = PropertyUtils.getProperty(a, "bgqx").toString();
                        String bBGQX = PropertyUtils.getProperty(b, "bgqx").toString();
                        value = Collator.getInstance(Locale.CHINESE).compare(aBGQX, bBGQX);
                        if (value == 0) {//保管期限相同
                            String aFLH = PropertyUtils.getProperty(a, "flh").toString();
                            String bFLH = PropertyUtils.getProperty(b, "flh").toString();
                            value = Collator.getInstance(Locale.CHINESE).compare(aFLH, bFLH);
                            if (value == 0) {//分类号相同
                                int aSBJH = Integer.parseInt(PropertyUtils.getProperty(a, "jh").toString());
                                int bSBJH = Integer.parseInt(PropertyUtils.getProperty(b, "jh").toString());
                                if (aSBJH == bSBJH) {  //sbjh相同

                                } else {
                                    value = aSBJH - bSBJH > 0 ? 1 : -1;
                                }
                            }
                        }
                    } else {
                        value = aYear - bYear > 0 ? 1 : -1;
                    }
                } catch (Exception ex) {

                }
                return value;
            }
        });
        return tempList;
    }

    /**
     * 预归档按照登记号降序排列
     * @param ythSw
     * @param ythFw
     * @param ythNw
     * @return
     */
    private List pgdSort1(List ythSw, List ythFw, List ythNw) {
        ArrayList<Object> tempList = new ArrayList<Object>();
        if (ythSw != null)
            tempList.addAll(ythSw);
        if (ythFw != null)
            tempList.addAll(ythFw);
        if (ythNw != null)
            tempList.addAll(ythNw);

        Collections.sort(tempList, new Comparator<Object>() {
            @Override
            public int compare(Object o1, Object o2) {
                int value=0;
                try {
                    String djh1 = (String)PropertyUtils.getProperty(o1,"djh");
                    String djh2 = (String)PropertyUtils.getProperty(o2,"djh");

                    value = djh1.compareTo(djh2);
                } catch (Exception e) {
                    e.printStackTrace();
                }
                return value;
            }
        });

        return tempList;
    }

    /**
     * 全宗卷里面的所有档案类型都要按照盒号-顺序号来进行排序
     * @param ythSw
     * @param ythFw
     * @param ythNw
     * @return
     */
    private List qzjSort(List ythSw, List ythFw, List ythNw) {
        ArrayList<Object> tempList = new ArrayList<Object>();
        if (ythSw != null)
            tempList.addAll(ythSw);
        if (ythFw != null)
            tempList.addAll(ythFw);
        if (ythNw != null)
            tempList.addAll(ythNw);
        Collections.sort(tempList, new Comparator() {
            public int compare(Object a, Object b) {
                int value = 0;
                try {
                    String aHhao = PropertyUtils.getProperty(a, "hh").toString();
                    String bHhao = PropertyUtils.getProperty(b, "hh").toString();
                    value = Collator.getInstance(Locale.CHINESE).compare(aHhao, bHhao) ;
                    if (value == 0) {  //盒号相同
                        int aSxh = Integer.parseInt(PropertyUtils.getProperty(a, "sxh").toString());
                        int bSxh = Integer.parseInt(PropertyUtils.getProperty(b, "sxh").toString());

                        if(aSxh == aSxh){//顺序号相同

                        }else{
                           value = aSxh-bSxh > 0 ? 1:-1 ;
                        }
                    }
                } catch (Exception ex) {

                }
                return value;
            }
        });
        return tempList;
    }


    /**
     * 业务活动里面的档案库房温湿度登记、档案资料检查登记、业务指导台账登记、宣传工作台账登记、档案咨询服务台账登记都要按照“日期字段”进行列表排序
     * @param ywhd
     * @return
     */
    private List ywhdSort(List ywhd) {
        ArrayList<Object> tempList = new ArrayList<Object>();
        boolean flag = false ;

        if (ywhd != null)
            tempList.addAll(ywhd);

        Map field = getShowFields() ;
        Set keys1 = field.keySet() ;

        Iterator<String> iterator1 = keys1.iterator() ;
        while(iterator1.hasNext()){
            flag = false ;
            dataField = iterator1.next() ;
            Map map2 = (Map)field.get(dataField) ;

            Set<String> keys2 = map2.keySet() ;

            for(String temp : keys2){
                if ("date".equals(temp)){
                    flag = true ;
                    break;
                }
            }

            if (flag){
                break;
            }
        }

        if (flag){

            Collections.sort(tempList, new Comparator() {
                public int compare(Object a, Object b) {
                    int value = 0;
                    try {
                        if((PropertyUtils.getProperty(a, dataField) instanceof String)
                                && (PropertyUtils.getProperty(b, dataField) instanceof String)){
                            String str1 = (String) PropertyUtils.getProperty(a, dataField) ;
                            String str2 = (String) PropertyUtils.getProperty(b, dataField) ;
                            if("wsddj".equalsIgnoreCase(modelName)) {
                                return str2.compareTo(str1);
                            }else{
                                return str1.compareTo(str2);
                            }

                        }else{
                            Date aDate = (Date)PropertyUtils.getProperty(a, dataField);
                            Date bDate = (Date)PropertyUtils.getProperty(b, dataField);

                            if (aDate == null && bDate == null)
                                return 0;

                            if (aDate == null)
                                return -1;
                            if (bDate == null)
                                return 1;
                            if("wsddj".equalsIgnoreCase(modelName)) {
                                return bDate.compareTo(aDate);
                            }else{
                                return aDate.compareTo(bDate);
                            }

                        }

                    } catch (Exception ex) {

                    }
                    return value;
                }
            });
        }
        return tempList;
    }

    @Override
    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        if (StringUtils.isNotBlank(status))
            criterions.add(Restrictions.eq("status", status));
        return super.createCriterions(criterions);
    }

    @Override
    public String print() throws Exception {
        isPrint = true;
        return super.print();
    }

    @Override
    public String fr3() throws Exception {
        if (StringUtils.isBlank(printType)) {
            String basePath = getEntityModel().getEnv().getExpr("${.vars['web.root']}/print");
            File file = new File(basePath, modelName + ".fr3");
            if (file.exists()) {
                sendFile(file);
            } else {
                try {
                    basePath = getEntityModel().getEnv().getExpr("${.vars['egov.conf']}/archive/print");
                    file = ResourceUtils.getFile(basePath + "/" + modelName + ".fr3");
                    if (file.exists()) {
                        sendFile(file);
                    } else {
                        file = ResourceUtils.getFile(basePath + "/" + modelName + ".fr3");
                        if (file.exists())
                            sendFile(file);
                    }
                } catch (FileNotFoundException ignored) {
                }
            }
        } else {
            String basePath = getEntityModel().getEnv().getExpr("${.vars['web.root']}/print");
            File file = new File(basePath, modelName + "-" + printType + ".fr3");
            if (file.exists()) {
                sendFile(file);
            } else {
                try {
                    basePath = getEntityModel().getEnv().getExpr("${.vars['egov.conf']}/archive/print");
                    file = ResourceUtils.getFile(basePath + "/" + modelName + "-" + printType + ".fr3");
                    if (file.exists()) {
                        sendFile(file);
                    } else {
                        file = ResourceUtils.getFile(basePath + "/" + modelName + "-" + printType + ".fr3");
                        if (file.exists())
                            sendFile(file);
                    }
                } catch (FileNotFoundException ignored) {
                }
            }
        }
        return null;
    }

    public void setStatus(String status) {
        this.status = status;
    }


    @Override
    public Model getEntityModel() {
        if (modelName.equals("ygd") || modelName.equals("pgd"))
            return modelService.getModel("ythsw");
        return modelService.getModel(modelName);
    }


    public String getLinkField() {
        if (linkField == null) {
            try {
                linkField = archiveService.getArchiveModel(modelName).getTemplate("linkField");
            } catch (Exception ex) {
                linkField = "tm";
            }
        }
        return linkField;
    }

    /**
     * 为收文生成室编件号或者件号
     *
     * @param mlh
     * @return
     */
    private int getSbjh(String mlh) {
        try {
            ajhRange = ajhRangeService.getAjhRangesForGeneric("Wdyth", mlh);
        } catch (Exception ex) {
            AjhRange ajhRangeTemp = new AjhRange();
            if (EnvHolder.isEnable(Switch.INDIVIDUAL_MLH))
                ajhRangeTemp.setDwdm(getDwdm());
            ajhRangeTemp.setMlh(mlh);
            ajhRangeTemp.setCurrentValue(0);
            ajhRangeTemp.setMinValue(0);
            ajhRangeTemp.setMaxValue(1000);
            ajhRangeTemp.setModelName("Wdyth");
            ajhRangeService.saveAjhRange(ajhRangeTemp);
            ajhRange = ajhRangeService.getAjhRangesForGeneric("Wdyth", mlh);
        }
        if (ajhRange.hasExhausted()) {
            ajhRange.setMaxValue(ajhRange.getMaxValue() + 100);
            ajhRangeService.saveAjhRange(ajhRange);
        }
        if (ajhRange != null) {
            sbjh = ajhRange.getNextValue();
        }
        return sbjh;
    }

    /**
     * 获取当前用户的单位代码
     *
     * @return
     */
    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }


    /**
     * 将检索结果合并，并根据成文日期升序排序，日期相同则根据登记号升序排序，若日期为null,则放到后面
     *
     * @param ythSw
     * @param ythFw
     * @param ythNw
     * @return
     */
    private List addAll(List ythSw, List ythFw, List ythNw) {
        ArrayList<Object> tempList = new ArrayList<Object>();
        if (ythSw != null)
            tempList.addAll(ythSw);
        if (ythFw != null)
            tempList.addAll(ythFw);
        if (ythNw != null)
            tempList.addAll(ythNw);
        Collections.sort(tempList, new Comparator() {
            public int compare(Object a, Object b) {
                int value = 0;
                DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    Date one = null;
                    if (PropertyUtils.getProperty(a, "cwrq") != null)
                        one = dateFormat.parse(PropertyUtils.getProperty(a, "cwrq").toString());
                    Date two = null;
                    if (PropertyUtils.getProperty(b, "cwrq") != null)
                        two = dateFormat.parse(PropertyUtils.getProperty(b, "cwrq").toString());
                    if (one == null && two != null) {
                        value = 1;
                    } else if (one != null && two == null) {
                        value = -1;
                    } else if (one != null && two != null) {
                        value = one.compareTo(two);
                        if (value == 0) {
                            int djh1 = Integer.parseInt(PropertyUtils.getProperty(a, "djh").toString());
                            int djh2 = Integer.parseInt(PropertyUtils.getProperty(b, "djh").toString());
                            value = djh1 - djh2 < 0 ? -1 : 1;
                        }
                    }
                } catch (Exception ex) {
                    logger.error(ex.toString());
                }
                return value;
            }
        });
        return tempList;
    }

    /**
     * 过滤条件查询id
     *
     * @return
     */
    public String searchIds() {
        List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
        //档案资料检查登记里面没有单位代码属性，需要进行判断
        Set<Field> sets = modelService.getModel(modelName).getFields();
        for(Field field : sets){
            if("dwdm".equalsIgnoreCase(field.getName())){
                criterions.add(Restrictions.eq("dwdm", getDwdm()));
            }
        }

        List<Order> orders = createOrders(new ArrayList<Order>());
        List items = null;
        if ("ygd".equals(modelName)) {
            items = ygdSort(entityService.search("ythsw", criterions, orders, 0, -1).getItems(),
                    entityService.search("ythfw", criterions, orders, 0, -1).getItems(),
                    entityService.search("ythnw", criterions, orders, 0, -1).getItems());
        } else {
            items = entityService.search(modelName, criterions, orders, start, limit).getItems();
        }

        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.size(); i++) {
            try {
                sb.append(PropertyUtils.getProperty(items.get(i), "id") + ",");
            } catch (Exception e) {
                logger.error(e.toString());
            }
        }
        ids = sb.toString().split(",");
        return cacheIds();
    }


    /**
     * 判断按钮的权限（已归档的增加、修改、删除）
     */
    public void checkButtonPermision(){
        synchronized(this) {
            treeService.getWDYTHButtonPermission(treeId, buttonType, modelName);
            renderJson(treeService.getPermisionResult());
            treeService.resetPermision();
        }
    }

    /**
     * 1.数据推送成功的收文档案需要修改收文的状态
     * 2.编辑过数据的收文或者上传新的正文或者附件也需要修改状态为未发送
     * 0 未发送
     * 1 已发送
     * @return
     */
    public String changeSwSendState(){
        HttpServletResponse response = ServletActionContext.getResponse();
        Map result = new HashMap();
        boolean flag = true;
        for(String id : swIds.split(",")){
            Object obj = entityService.load(modelName,id.trim());
            try {
                if("yfs".equals(changeType)){       // 已发送
                    PropertyUtils.setProperty(obj,"sffs",1);
                }else if("wfs".equals(changeType)){ // 未发送
                    PropertyUtils.setProperty(obj,"sffs",0);
                }
            } catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage());
                result.put("success", false);
                break;
            }
            entityService.save(obj);
        }
        if(flag){
            result.put("success",true);
        }else{
            result.put("success",false);
        }
        Struts2Utils.renderJson(result);

        return null;
    }
}
