package com.gtis.archive.web;

import com.gtis.archive.core.web.BaseEntityAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.service.ArchiveService;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-10-13
 */
public class DocEntityAction extends BaseEntityAction<Document> {
    @Autowired
    private ArchiveService archiveService;

    /**
     * 档案id
     */
    private String archiveId;

    private String state;

    /**
     * 被插入卷内的id
     */
    private String insertId;

    public String getState() {
        if (StringUtils.isBlank(state))
            return "";
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void prepare() {
        if (StringUtils.isBlank(id)) {
            entity = archiveService.newDocument(modelName);
            String cid = (String) session.get("currentDId");
            Document lastDocument = null;
            Document insertedDocument = null;
            if (cid != null) {
                lastDocument = archiveService.getDocument(modelName, cid);
            }
            if (insertId != null)
                insertedDocument = archiveService.getDocument(modelName, insertId);
            if (lastDocument != null) {
                try {
                    PropertyUtils.copyProperties(entity, lastDocument);
                    entity.setSxh(entity.getSxh() + 1);
                } catch (Exception ignored) {
                }
                entity.setId(null);
            }
            if (insertedDocument != null && insertedDocument.getSxh() != null) //插入
                entity.setSxh(insertedDocument.getSxh());
        } else {
            entity = archiveService.getDocument(modelName, id);
            if (archiveId == null)
                archiveId = entity.getArchiveId();
        }
        if (entity != null && archiveId != null) {
            try {
                Archive archive = archiveService.getArchive(modelName, archiveId);
                entity.setArchive(archive);
                entity.setMlh(archive.getMlh());
                entity.setAjh(archive.getAjh());
                entity.setQzh(archive.getQzh());
            } catch (Exception ex) {
                logger.debug(ex.toString());
            }
        }
    }


    @Override
    protected void preSave() {

    }

    @Override
    protected void doSave(Document entity) {
        archiveService.saveDocument(entity);
        if (StringUtils.isNotBlank(insertId)) {//插入操作
            List<Document> documentList = archiveService.getArchiveDocuments(modelName, archiveId, entity.getSxh(), entity.getId());
            for(Document document :documentList){
                document.setSxh(document.getSxh()+1);
                archiveService.saveDocument(document);
            }
        }
    }

    @Override
    protected String getJsCallBack() {
        return "onDocumentComplete";
    }

    @Override
    protected void afterSave() {
        session.put("currentDId", entity.getId());
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public String getInsertId() {
        return insertId;
    }

    public void setInsertId(String insertId) {
        this.insertId = insertId;
    }
}
