package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.NoPermissionException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.entity.Permission;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.*;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import javax.print.Doc;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-9-20
 */
public class DocAction extends BaseModelAction<Document> {
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private OriginalService originalService;
    @Autowired
    private SysUserService userService;
    /**
     * tree id
     */
    private String treeId;
    /**
     * document view type,wlj(未立卷) ylj(已立卷)
     */
    private String type;
    /**
     * 档案id
     */
    private String archiveId;

    /**
     * 链接字段
     */
    private String linkField;

    /**
     * 卷内数据模版
     */
    private List<Map> dataTpl;

    @Override
    public void setModelName(String modelName) {
        super.setModelName(Archive.toDocumentModelName(modelName));
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public String getTreeId() {
        return treeId;
    }

    public String getType() {
        return type;
    }

    public String getPermJson() {
        List<Item> operations = dictService.getItems(Permission.OPERATION_DICT);
        Map<String, Boolean> perm = new HashMap<String, Boolean>();
        for (Item item : operations) {
            if (securityService.isPermitted(treeId, item.getName()))
                perm.put(item.getName(), true);
        }
        return JSON.toJSONString(perm);
    }

    public List<Map<String, Object>> getTree() {
        return treeService.getTree(null, Constants.MODEL_ROOT);
    }

    @Override
    public String execute() throws Exception {
        if (StringUtils.isNotEmpty(modelName)) {
            Resource res = resourceService.findChildResource(null, Document.toArchiveModelName(modelName), Constants.MODEL_ROOT);
            if (res != null) {
                treeId = res.getId();
                if (!securityService.isPermitted(treeId, Permission.VIEW_PERMISSION)) {
                    throw new NoPermissionException(modelName);
                }
            } else {
                throw new ModelNotFoundException(modelName);
            }
        }
        modelService.getModel(modelName);
        String id = getId();
        if (id != null) {
            Document doc = archiveService.getDocument(modelName, id);
            if (doc != null) {
                type = doc.getArchiveId() == null ? "wlj" : "ylj";
            }
        }
        return Action.SUCCESS;
    }

    @Override
    protected Page<Document> searchEntity(List<Criterion> criterions, List<Order> orders) {
        if (StringUtils.isNotEmpty(archiveId)) {
            if (EnvHolder.isEnable(Switch.JIANGYIN)) {
                List<Document> documents = entityService.<Document>search(Archive.toDocumentModelName(modelName),
                        Collections.singletonList(Restrictions.eq("archiveId", archiveId)), orders, 0, Page.ALL).getItems();
                if (documents.size() > 0) {
                    documents.get(0).setArchive(archiveService.getArchive(modelName, archiveId));
                }
                return new Page<Document>(documents);
            } else {
                return new Page<Document>(entityService.<Document>search(Archive.toDocumentModelName(modelName),
                        Collections.singletonList(Restrictions.eq("archiveId", archiveId)), orders, 0, Page.ALL).getItems());
            }
        }
        if (EnvHolder.isEnable(Switch.JIANGYIN)) {
            if(EnvHolder.isEnable(Switch.DWDM)&&!SessionUtil.getCurrentUser().isAdmin())
                criterions.add(Restrictions.eq("dwdm",getDwdm()));
//                criterions.add(Restrictions.or(Restrictions.eq("dwdm",getDwdm()),Restrictions.isNull("dwdm")));
            Page<Document> page = super.searchEntity(criterions, orders);
            for (Document document : page.getItems()) {
//                if (StringUtils.isNotBlank(document.getArchiveId())) {
//                    document.setArchive(archiveService.getArchive(modelName, document.getArchiveId()));
//                }
                document.setHasOriginal(originalService.hasOriginal(document.getId()));
            }
            return page;
        } else {
            return super.searchEntity(criterions, orders);
        }

    }

    @Override
    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        if (type == null || !type.equals("all"))
            criterions.add("ylj".equals(type) ? Restrictions.isNotNull("archiveId") : Restrictions.isNull("archiveId"));
        return super.createCriterions(criterions);
    }

    @Override
    protected List<Order> createOrders(ArrayList<Order> orders) {
        List<Order> superOrders = super.createOrders(orders);
        if (superOrders.size() > 0) return superOrders;
        if (StringUtils.isNotEmpty(archiveId))
            orders.add(Order.desc("sxh"));
        orders.add(Order.desc("id"));
        return super.createOrders(orders);
    }

    /**
     * 获取卷内所属的档案
     *
     * @return
     */
    private Map docArchive;

    public Map getDocArchive() {
        try {
            if (docArchive == null) {
                docArchive = JSON.parseObject(JSON.toJSONString(archiveService.getArchive(modelName, archiveId), SerializerFeature.WriteMapNullValue));
                docArchive.remove("id");
            }
        } catch (Exception ex) {
            logger.error(ex.toString());
        }
        return docArchive;
    }

    public String getLinkField() {
        if (linkField == null) {
            try {
                linkField = archiveService.getDocumentModel(modelName).getTemplate("linkField");
            } catch (ModelNotFoundException ex) {
            } catch (TemplateNotFoundException ex) {
                linkField = "tm";
            }
        }
        return linkField;
    }

    /**
     * 根据模版插入卷内
     *
     * @return
     */
    public String insertDocumnets() {
        if (dataTpl == null) {
            try {
                dataTpl = JSON.parseArray(archiveService.getDocumentModel(modelName).getTemplate("dataTpl"), Map.class);
            } catch (Exception ex) {
            }
        }
        if (archiveId != null && dataTpl != null) {
            int currentSxh = archiveService.getArchiveDocumentLastSxh(Document.toArchiveModelName(modelName), archiveId);
            for (Map map : dataTpl) {
                Document document = archiveService.newDocument(Document.toArchiveModelName(modelName));
                for (Object entry : map.entrySet()) {
                    try {
                        Map.Entry pro = (Map.Entry) entry;
                        if ("rq".equals(pro.getKey().toString())) {
                            PropertyUtils.setProperty(document, pro.getKey().toString(),  Constants.DATE_FORMAT.parse(pro.getValue().toString()));
                        } else {
                            PropertyUtils.setProperty(document, pro.getKey().toString(), pro.getValue());
                        }

                    } catch (Exception ex) {
                    }
                }
                document.setSxh(currentSxh + dataTpl.indexOf(map) + 1);
                document.setDwdm(getDwdm());
                document.setArchiveId(archiveId);
                archiveService.saveDocument(document);
            }
            renderJson("success");
        }else {
            renderJson("failed");
        }
        return null;
    }

    /**
     * 获取当前用户的单位代码
     *
     * @return
     */
    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }

    /**
     *
     * @return
     * @throws Exception
     */
    public String list() throws Exception {
        try {
            renderJson(sortDocument(getEntityPage()));
        } catch (Exception e) {
            renderJson(new Page());
        }
        return null;
    }

    /**
     * 卷内排序
     * @param page
     * @return
     */
    private Page<Document> sortDocument(Page<Document> page){
        List<Document> docLists = page.getItems();
        List<Document> empty = new ArrayList(); //没有全宗号目录号案卷号的

        for(Document document : docLists){
            String qzh = document.getQzh();
            String mlh = document.getMlh();
            Integer ajh = document.getAjh();
            if(ajh!=null && qzh!=null && mlh!=null){
                continue;
            }else {
                Archive archive = archiveService.getSimpleArchive(document.getArchiveId());
                if(archive.getState()==2 || archive.getState()==0){ //2预归档 0已处理
                    try {
                        PropertyUtils.setProperty(document,"qzh",archive.getQzh());
                        PropertyUtils.setProperty(document,"mlh",archive.getMlh());
                        PropertyUtils.setProperty(document,"ajh",archive.getAjh());
                    } catch (Exception e){
                        logger.error(e.getMessage());
                    }
                }else if(archive.getState()==3){                    // 3 未处理
                    empty.add(document);
                }
            }
        }

        for(Document document : empty){
            docLists.remove(document);
        }

        Collections.sort(docLists, new Comparator() {
            @Override
            public int compare(Object o1, Object o2) {
                /*Document document1 = (Document)o1;
                Document document2 = (Document)o2;
                String qzh1 = document1.getQzh();
                String qzh2 = document2.getQzh();

                int value = Collator.getInstance(Locale.CHINESE).compare(qzh1, qzh2) ;

                if(value==0){//全宗号相同
                    String mlh1 = document1.getMlh();
                    String mlh2 = document2.getMlh();
                    value = Collator.getInstance(Locale.CHINESE).compare(mlh2, mlh1);
                    if(value==0){
                        int ajh1 = document1.getAjh();
                        int ajh2 = document2.getAjh();

                        if(ajh1 == ajh2){
                            value = 0;
                        }else{
                            value = ajh1-ajh2>0?-1:1;
                        }
                    }else {

                    }
                }*/
                Document document1 = (Document)o1;
                Document document2 = (Document)o2;
                int sxh1 = document1.getSxh();
                int sxh2 = document2.getSxh();

                int value ;
                if(sxh1>sxh2){value=1;}
                else if (sxh1<sxh2){value=-1;}
                else{String mlh1 = document1.getMlh();
                    String mlh2 = document2.getMlh();
                    value = Collator.getInstance(Locale.CHINESE).compare(mlh1, mlh2);
                    if(value==0){
                        int ajh1 = document1.getAjh();
                        int ajh2 = document2.getAjh();

                        if(ajh1 == ajh2){
                            value = 0;
                        }else{
                            value = ajh1-ajh2>0?-1:1;
                        }
                    }else {

                    }}



                return value;
            }
        });
        docLists.addAll(empty);
        page.setItems(docLists);
        return page;
    }

}
