package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.*;
import com.gtis.archive.service.*;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.json.JSONException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 文档一体化的互查
 */

public class CheckAction extends BaseModelAction<Object> {
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private AjhRangeService ajhRangeService;

    @Autowired
    private OriginalService originalService;

    @Autowired
    private ArchiveService archiveService;

    @Autowired
    private RecordAjhRangeService recordAjhRangeService;

    @Autowired
    private CheckLogService checkLogService ;

    private AjhRange ajhRange;

    private Integer sbjh;

    private String linkField;

    /**
     * 年度
     */
    private String nd;

    private String archiveId ;

    private String modelName ;

    /**
     * tree id
     */
    private String treeId;

    private String tplName;

    private String status;

    private String printType;

    private Boolean isPrint=false;

    private String itemId;

    private List<Item> operations;

    private List<Map<String, Object>> tree;


    public String getItemId() {
        return itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getTreeId() {
        return treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setTplName(String tplName){
        this.tplName = tplName;
    }

    public String getTreeJson() throws JSONException {
        List<Map<String, Object>> listTree =  treeService.getTree(treeId);
        List<Map<String, Object>> newTree =null;
        Item item=dictService.getItem(itemId);
        if(item!=null&&item.getRemark()!=null&&StringUtils.isNotBlank(item.getRemark().toString())){
            String remark=item.getRemark().toString();
            JSONObject job= JSON.parseObject(remark);
            JSONArray array=job.getJSONArray("items");
            ArrayList<String> resIds = new ArrayList<String>();
            for(int i=0;i<array.size();i++){
                String resId=((JSONObject)array.get(i)).get("id").toString();
                if(!resIds.contains(resId))
                    resIds.add(resId);
            }
            newTree=rewriteMap(listTree,resIds);
    }
        return JSON.toJSONString(newTree);
    }

    private List<Map<String, Object>> rewriteMap(List<Map<String, Object>> listTree, List<String> resIds){
        List<Map<String, Object>> parentList=new ArrayList<Map<String, Object>>();
        if(listTree != null){
            for (Map tree : listTree){
                List<Map<String, Object>>childrenList=rewriteMap((List<Map<String, Object>>) tree.get("children"), resIds);
                String id = (String) tree.get("id");
                if(resIds.contains(id)||childrenList.size()!=0){
                    tree.put("children",childrenList);
                    parentList.add(tree);
                }
            }
        }
        return parentList;
    }



    public int getLimit() {
        return limit;
    }

    public String getPrintType() {
        return printType;
    }

    public void setPrintType(String printType) {
        this.printType = printType;
    }

    @Override
    public void setId(String[] ids) {
        this.ids=ids;
    }

    @Override
    public void setStart(int start) {
        super.setStart(start);
    }

    public String getNd() {
        return nd;
    }

    public void setNd(String nd) {
        this.nd = nd;
    }

    public String getArchiveId() {
        return archiveId;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public String getModelName() {
        return modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    @Override
    public Map getShowFields(){
        Map showFields = null;
        try{
            showFields = super.getShowFields();
        }catch(TemplateNotFoundException ex){
            logger.error(ex.getMessage());
        }
        return showFields;
    }

    @Override
    protected String[] getQueryFields() {
        String[] qFields = null;
        try{
            qFields = super.getQueryFields();
        }catch(TemplateNotFoundException ex){
            logger.error(ex.getMessage());
        }
        return qFields;
    }

    public List<Map<String, Object>> getTree() {
        if(tree==null){
            List<Map<String, Object>> listTree = treeService.getTree(null,Constants.MODEL_ROOT);
            for(Map item:listTree){
                logger.debug(item.toString());
                if(item.get("name").equals(Constants.GENERIC)){
                    listTree.remove(item);
                    break;
                }
            }
            tree = listTree;
        }
        return tree;
    }

    @Override
    public String execute() {
        if (treeId == null) {
            Resource res = resourceService.findChildResource(null, Constants.GENERIC, Constants.MODEL_ROOT);
            treeId = res.getId();
        }
        operations = dictService.getItems(Constants.HUCHA_PERM);
        /*if (!securityService.isPermitted(treeId, Permission.VIEW_PERMISSION)) {
            throw new NoPermissionException(treeId);
        }*/
        return Action.SUCCESS;
    }

    /**
     *
     * @return
     */
    public String tpl() {
        try {
            if(tplName.indexOf("list")>-1){
                try{
                    renderModelTemplate(tplName);
                }catch(TemplateNotFoundException e){
                    renderModelTemplate("Generic-list");
                }
            }else{
                renderModelTemplate(tplName);
            }
        } catch (Exception e) {
            logger.error(e.getLocalizedMessage());
        }
        return null;
    }

    private List orderEntities(){
        List<Object> entities=new ArrayList<Object>();
        for(String id:ids){
            Object entity = entityService.load(modelName,id);
            entities.add(entity);
        }
        return  addAll(entities,null,null);
    }

    /**
     * 检索收文，发文，内文中的档案，并根据成文日期排序
     * @param criterions
     * @param orders
     * @return
     */
    private Page<Object> searchEntityAll(List<Criterion> criterions, List<Order> orders){
        List<Criterion> list = new ArrayList<Criterion>(criterions);
        if (EnvHolder.isEnable(Switch.DWDM) && !SessionUtil.getCurrentUser().isAdmin()) {
            try{
                boolean hasDwdm=PropertyUtils.getProperty(entityService.<Object>newInstance(modelName),"dwdm")==null;
                list.add(Restrictions.or(Restrictions.isNull("dwdm"), Restrictions.eq("dwdm", getDwdm())));
            }catch (Exception ex){
                logger.error(ex.toString()+"{该业务没有设置单位代码}");
            }
        }
        Page page=new Page();
        List all=addAll(entityService.search("ythsw", list, orders, start, limit).getItems(),
                entityService.search("ythfw", list, orders, start, limit).getItems(),
                entityService.search("ythnw", list, orders, start, limit).getItems());
        int totalCount=all.size();
        page.setItems(all);
        page.setTotalCount(totalCount);
        return page;
    }


    /**
     * 获取互查的单位代码
     * @return
     */
    private String getCheckDwdm(){
        if(StringUtils.isNotBlank(itemId)){
            Item item=dictService.getItem(itemId);
            return  item.getValue();
        }
        return null;
    }

    @Override
    protected Page<Object> searchEntity(List<Criterion> criterions, List<Order> orders) {
        List<Criterion> list = new ArrayList<Criterion>(criterions);
        if (EnvHolder.isEnable(Switch.DWDM) && !SessionUtil.getCurrentUser().isAdmin()) {
            try{
//                if(modelName.equals("ygd") || modelName.equals("pgd")){
//                    boolean hasDwdm=PropertyUtils.getProperty(entityService.<Object>newInstance("ythsw"),"dwdm")==null;
//                }else{
//                    boolean hasDwdm=PropertyUtils.getProperty(entityService.<Object>newInstance(modelName),"dwdm")==null;
//                }
//                list.add(Restrictions.or(Restrictions.isNull("dwdm"), Restrictions.eq("dwdm", getDwdm())));
                list.add(Restrictions.or(Restrictions.isNull("dwdm"), Restrictions.eq("dwdm", getCheckDwdm())));
            }catch (Exception ex){
                logger.error(ex.toString()+"{该业务没有设置单位代码}");
            }
        }
        if(modelName.equals("ygd") || modelName.equals("pgd")) {
            list.add(Restrictions.eq("status",modelName));
            Page page=new Page();
            List all=ygdSort(entityService.search("ythsw", list, orders, start, limit).getItems(),
                    entityService.search("ythfw", list, orders, start, limit).getItems(),
                    entityService.search("ythnw", list, orders, start, limit).getItems());
            int totalCount=all.size();
            page.setItems(all);
            page.setTotalCount(totalCount);
            return page;
        }
        if(isPrint)
            return entityService.search(modelName, list, orders, start, limit);
        Page page= entityService.search(modelName, list, orders, start, limit);
        List<Object> lists=page.getItems();
        for(Object object:lists){
            try {
                String id=PropertyUtils.getProperty(object,"id").toString();
                PropertyUtils.setProperty(object,"hasOriginal",originalService.hasOriginal(id));
            } catch (Exception e) {
                break;
            }
        }
//        return entityService.search(modelName, list, orders, start, limit);
        return page;
    }


    private List  ygdSort(List ythSw,List ythFw,List ythNw){
        ArrayList<Object> tempList=new ArrayList<Object>();
        if(ythSw!=null)
            tempList.addAll(ythSw);
        if(ythFw!=null)
            tempList.addAll(ythFw);
        if(ythNw!=null)
            tempList.addAll(ythNw);
        Collections.sort(tempList, new Comparator() {
            public int compare(Object a, Object b) {
                int value = 0;
                try {
                    String aQzh = PropertyUtils.getProperty(a, "qzh").toString();
                    String bQzh = PropertyUtils.getProperty(b, "qzh").toString();
                    value = Collator.getInstance(Locale.CHINESE).compare(aQzh, bQzh);
                    if (value == 0) {  //全宗号相同
                        int aYear = Integer.parseInt(PropertyUtils.getProperty(a, "nd").toString());
                        int bYear = Integer.parseInt(PropertyUtils.getProperty(b, "nd").toString());
                        if (aYear == bYear) {  //年度相同
                            String aBGQX = PropertyUtils.getProperty(a, "bgqx").toString();
                            String bBGQX = PropertyUtils.getProperty(b, "bgqx").toString();
                            value = Collator.getInstance(Locale.CHINESE).compare(aBGQX, bBGQX);
                            if (value == 0) {//保管期限相同
                                String aFLH = PropertyUtils.getProperty(a, "flh").toString();
                                String bFLH = PropertyUtils.getProperty(b, "flh").toString();
                                value = Collator.getInstance(Locale.CHINESE).compare(aFLH, bFLH);
                                if (value == 0) {//分类号相同
                                    int aSBJH = Integer.parseInt(PropertyUtils.getProperty(a, "sbjh").toString());
                                    int bSBJH = Integer.parseInt(PropertyUtils.getProperty(b, "sbjh").toString());
                                    if (aSBJH == bSBJH) {  //sbjh相同

                                    } else {
                                        value = aSBJH - bSBJH < 0 ? -1 : 1;
                                    }
                                }
                            }
                        } else {
                            value = aYear - bYear < 0 ? -1 : 1;
                        }
                    }
                } catch (Exception ex) {

                }
                return value;
            }
        });
        return tempList;
    }

    @Override
    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        if(StringUtils.isNotBlank(status))
            criterions.add(Restrictions.eq("status",status));
        return super.createCriterions(criterions);
    }

    public void setStatus(String status) {
        this.status = status;
    }


    @Override
    public Model getEntityModel() {
        if(modelName.equals("ygd") || modelName.equals("pgd"))
            return modelService.getModel("ythsw");
        return modelService.getModel(modelName);
    }


    public String getLinkField(){
        if(linkField==null){
            try{
                linkField=archiveService.getArchiveModel(modelName).getTemplate("linkField");
            }catch (Exception ex){
                linkField="tm";
            }
        }
        return linkField;
    }

    /**
     * 获取当前用户的单位代码
     *
     * @return
     */
    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }


    /**
     * 将检索结果合并，并根据成文日期升序排序，日期相同则根据登记号升序排序，若日期为null,则放到后面
     * @param ythSw
     * @param ythFw
     * @param ythNw
     * @return
     */
    private List addAll(List ythSw,List ythFw,List ythNw){
        ArrayList<Object> tempList=new ArrayList<Object>();
        if(ythSw!=null)
            tempList.addAll(ythSw);
        if(ythFw!=null)
            tempList.addAll(ythFw);
        if(ythNw!=null)
            tempList.addAll(ythNw);
        Collections.sort(tempList, new Comparator() {
            public int compare(Object a, Object b) {
                int value=0;
                DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try{
                    Date  one =null;
                    if(PropertyUtils.getProperty(a,"cwrq")!=null)
                        one=dateFormat.parse(PropertyUtils.getProperty(a,"cwrq").toString());
                    Date  two =null;
                    if(PropertyUtils.getProperty(b,"cwrq")!=null)
                        two=dateFormat.parse(PropertyUtils.getProperty(b,"cwrq").toString());
                    if(one==null&&two!=null){
                        value=1;
                    }else if(one!=null&&two==null){
                        value=-1;
                    }else if(one!=null&&two!=null){
                        value=one.compareTo(two);
                        if(value==0){
                            int djh1=Integer.parseInt(PropertyUtils.getProperty(a,"djh").toString());
                            int djh2=Integer.parseInt(PropertyUtils.getProperty(b,"djh").toString());
                            value=djh1-djh2 < 0 ? -1:1;
                        }
                    }
                }catch (Exception ex){
                    logger.error(ex.toString());
                }
                return value ;
            }
        });
        return tempList;
    }

    /**
     * 过滤条件查询ｉｄ
     * @return
     */
    public String searchIds(){
        List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
        List<Order> orders = createOrders(new ArrayList<Order>());
        List items=entityService.search(modelName, criterions, orders, start, limit).getItems();
        StringBuilder sb=new StringBuilder();
        for(int i=0;i<items.size();i++){
            try {
                sb.append(PropertyUtils.getProperty(items.get(i), "id")+",");
            } catch (Exception e) {
                logger.error(e.toString());
            }
        }
        ids=sb.toString().split(",");
        return cacheIds();
    }

    public String getPermJson() {
        Map<String, Boolean> perm = new HashMap<String, Boolean>();
        String remark;
        if(StringUtils.isNotBlank(itemId)){
            Item huchaItem=dictService.getItem(itemId);
            if (StringUtils.isNotBlank(huchaItem.getRemark())){
                remark=huchaItem.getRemark().toString();
                JSONObject jsonObject=JSON.parseObject(remark);
                JSONArray items= (JSONArray) jsonObject.get("items");
                for (int i=0;i<items.size();i++){
                    String id=((JSONObject)items.get(i)).get("id").toString();
                    String huchaPerm=((JSONObject)items.get(i)).get("perm").toString();
                    if (id.equals(treeId)){
                        if(operations==null)
                            operations = dictService.getItems(Constants.HUCHA_PERM);
                        for (Item item : operations){
                            if (item.getName().equals(huchaPerm))
                                perm.put(item.getName(),true);
                        }
                    }
                }
            }
        }
        renderJson(perm);
        return null;
    }


    /**
     * 添加互查日志
     * @return
     */
    public String addCheckLog(){
        CheckLog checkLog = new CheckLog() ;
        String qlr = "";
        Archive archive = null ;

        if("ythsw".equals(modelName)){          //收文类型
            Object entity = entityService.load(modelName, archiveId);
            checkLog.setUserName( userService.getUserVo(SessionUtil.getCurrentUserId()).getUserName());
            checkLog.setModelName(modelName);
            checkLog.setArchiveId(archiveId);
            checkLog.setCreateAt(new Date());

            try {
                checkLog.setQzh((String)PropertyUtils.getProperty(entity, "qzh"));
               // checkLog.setMlh((String)PropertyUtils.getProperty(entity, "mlh"));
                //checkLog.setAjh((String)PropertyUtils.getProperty(entity, "ajh"));
                checkLog.setTm((String)PropertyUtils.getProperty(entity, "tm"));
                //checkLog.setQlr((String)PropertyUtils.getProperty(entity, "qlr"));
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            } catch (InvocationTargetException e) {
                e.printStackTrace();
            } catch (NoSuchMethodException e) {
                e.printStackTrace();
            }

        }else{
            //通过modelName和achieveId获取档案的含子表信息
            archive = archiveService.getArchive(modelName, archiveId) ;
            checkLog.setUserName( userService.getUserVo(SessionUtil.getCurrentUserId()).getUserName());
            checkLog.setModelName(modelName);
            checkLog.setArchiveId(archiveId);
            checkLog.setCreateAt(new Date());
            checkLog.setQzh(archive.getQzh());
            checkLog.setMlh(archive.getMlh());
            checkLog.setAjh(String.valueOf(archive.getAjh()));
            checkLog.setTm(archive.getTm());
            try {
                qlr = !"".equals(PropertyUtils.getProperty(archive,"qlrmc")) ? (String)PropertyUtils.getProperty(archive,"qlrmc") : "";
            } catch (IllegalAccessException e) {
               // e.printStackTrace();
            } catch (InvocationTargetException e) {
               // e.printStackTrace();
            } catch (NoSuchMethodException e) {
               // e.printStackTrace();
            }finally {
                checkLog.setQlr(qlr);
            }
        }

        checkLogService.saveCheckLog(checkLog) ;

        return renderJson("") ;
    }

}
