package com.gtis.archive.web;

import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.*;
import com.gtis.archive.service.*;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import java.text.Collator;
import java.util.*;

public class BorrowAction extends BaseModelAction<Archive> {

    @Autowired
    private LoanService loanService;

    @Autowired
    protected ModelService modelService;

    @Autowired
    protected EntityService entityService;

    @Autowired
    private ArchiveService archiveService;

    @Autowired
    private SysUserService userService;

    private String archiveType;

    private String idString;

    private String id;

    private String archiveIds;


    public String getArchiveType() {
        return this.archiveType;
    }

    public void setArchiveType(String archiveType) {
        this.archiveType = archiveType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIdString(String idString) {
        this.idString = idString;
    }

    public void setIds(String[] ids) {
        this.ids = ids;
    }

    public String getArchiveIds() {
        return archiveIds;
    }

    public void setArchiveIds(String archiveIds) {
        this.archiveIds = archiveIds;
    }


    public List<LoanCart> getLoanCar() {
        List<LoanCart> entities = new ArrayList<LoanCart>();
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if (!"".equals(idString)) {
            Date date = new Date();
            for (String id : idString.split(",")) {
                LoanCart lc = new LoanCart();
                lc.setArchiveId(id.trim());
                lc.setUserId(userInfo.getId());
                lc.setArchiveType(archiveType);
                lc.setInDate(date);
                lc.setDwdm(getDwdm());
                if (archiveType.indexOf("_jn") != -1) {
                    Document document = entityService.load(archiveType, id.trim());
                    lc.setSxh(document.getSxh());
                    if (document.getArchive() != null || document.getArchiveId() != null) {
                        Archive archive = document.getArchive() == null ?
                                (Archive) entityService.load(Archive.class, document.getArchiveId()) :
                                document.getArchive();
                        if (archive != null) {
                            lc.setAjh(String.valueOf(archive.getAjh()));
                            lc.setMlh(archive.getMlh());
                            lc.setDh(archive.getDh());
                        }
                    }
                    //读取配置的模板
                    String loanTm = getDocLoanTm(archiveType);
                    String tmValue = "";
                    try {
                        tmValue = PropertyUtils.getProperty(document, loanTm).toString();
                    } catch (Exception ex) {
                        tmValue = document.getTm();
                    }
                    lc.setTm(tmValue);
                } else {
                    if (!archiveType.equals("ythsw") && !archiveType.equals("ythfw") && !archiveType.equals("ythnw")) {
                        Archive arvhice = entityService.load(archiveType, id.trim());
                        //读取配置的模板
                        String loanTm = getLoanTm(archiveType);
                        String tmValue = "";
                        try {
                            tmValue = PropertyUtils.getProperty(arvhice, loanTm).toString();
                        } catch (Exception ex) {
                            tmValue = arvhice.getTm();
                        }
                        lc.setTm(tmValue);
                        lc.setMlh(arvhice.getMlh());
                        lc.setAjh(arvhice.getAjh().toString());
                        lc.setDh(arvhice.getDh());
                    }
                }
                entities.add(lc);
            }
        }
        return entities;
    }

    public String borrows() {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
        if (userInfo.isAdmin()) {
            renderJson(sortPage(loanService.getPages(start, limit, criterions)));
        } else {
            Criterion cr = Restrictions.eq("userId", userInfo.getId());
            criterions.add(cr);
            renderJson(sortPage(loanService.getPages(start, limit, criterions)));
        }
        return null;
    }


    /**
     * 获取配置模板的在借阅中显示的tm，默认为tm
     *
     * @param modelName
     * @return
     */
    private String getLoanTm(String modelName) {
        String tm = "tm";
        try {
            tm = archiveService.getArchiveModel(modelName).getTemplate("loanField");
        } catch (Exception ex) {
            tm = "tm";
        }
        return tm;
    }

    private String getDocLoanTm(String modelName) {
        String tm = "tm";
        try {
            tm = archiveService.getDocumentModel(modelName).getTemplate("loanField");
        } catch (Exception ex) {
            tm = "tm";
        }
        return tm;
    }

    public String addLoanCar() {
        /**
         *  添加逻辑：判断是否已经被借阅，对于被借阅的档案在没有被归还前将不能给再次借阅
         */
        List<LoanCart> loanCarts = getLoanCar();
        String message = "";
        List<Criterion> wghlist = new ArrayList<Criterion>();
        Map<String,LoanCart> map1 = new HashMap<String,LoanCart>();
        List<String> archiveIdList = new ArrayList<String>();        //存放被借阅档案的id

        /**
         * 获取所有的未归档档案Id
         */
        for (LoanCart loancar : loanCarts) {
            wghlist.add(Restrictions.eq("archiveId", loancar.getArchiveId())); //锁定一类唯一档案
            wghlist.add(Restrictions.eq("state", 0)); //未归还类型的
            Page wghPage = entityService.search(Loan.class, wghlist, null, 0, -1);
            List<Loan> wghLists = wghPage.getItems(); //查询所有该类未归还借阅档案记录

            if(wghLists!=null && wghLists.size()!=0){
                archiveIdList.add(loancar.getArchiveId());
            }

            if(!map1.containsKey(loancar.getArchiveId())){
                map1.put(loancar.getArchiveId(),loancar);
            }
        }

        /**
         * 删除所有的被借阅档案
         */
        for (String archiveId:archiveIdList){
            if(map1.containsKey(archiveId)){
                map1.remove(archiveId);
            }
        }

        /**
         * 添加到借阅车
         */
        for(Map.Entry<String,LoanCart> loanCartEntry : map1.entrySet()){
            loanService.addToCart(loanCartEntry.getValue());
        }

        if(archiveIdList.size()==0){
            message = "success";
        }else if(loanCarts.size()==1&&archiveIdList.size()==1&&loanCarts.get(0).getArchiveId().equals(archiveIdList.get(0))){
            Archive archive = archiveService.getSimpleArchive(archiveIdList.get(0));
            message = "目录号为" + archive.getMlh() + "案卷号为" + archive.getAjh() + "的档案已被借阅，未归还";
        }else if(map1.entrySet().size()<loanCarts.size()&& map1.entrySet().size()>0){
            message = "已借出未归还档案无法添加到借阅车";
        }

        Struts2Utils.renderJson(message);
        return null;
    }

    public String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }


    public String remove() {
        loanService.removeFromCart(entityService.load(LoanCart.class, id));
        Struts2Utils.renderJson("success");
        return null;
    }

    public Model getEntityModel() {
        return modelService.getModel("LoanCart");
    }

    /**
     * 重写父类方法，获取数据按照sortPage方法的排序进行排序
     * @return
     */
    public List getEntities() {
        entities = super.getEntities();
        return sortPage(new Page(entities)).getItems();
    }

    /**
     * 排序借阅车内的数据，按照目录号从小到大，同一目录号下案卷号从小到大的顺序排列
     * @param entityPage
     * @return
     */
    public Page<LoanCart> sortPage(Page entityPage) {
        List<LoanCart> loanCarts = entityPage.getItems();

        Collections.sort(loanCarts, new Comparator<LoanCart>() {
            @Override
            public int compare(LoanCart o1, LoanCart o2) {
                //int value = Integer.parseInt(o1.getMlh()) - Integer.parseInt(o2.getMlh());
                int value = Collator.getInstance(Locale.CHINESE).compare(o1.getMlh(),o2.getMlh());
                if (value == 0) {
                    if(o1.getAjh()!=null&&o2.getAjh()!=null){
                        value = Integer.parseInt(o1.getAjh()) - Integer.parseInt(o2.getAjh()) > 0 ? 1 : -1;
                        return value;
                    }else{
                        return -1;
                    }
                } else {
                    return value > 0 ? 1 : -1;
                }
            }
        });

        entityPage.setItems(loanCarts);

        return entityPage;
    }

    /**
     * 借阅登记之前验证是否已经被借阅
     */
    public void checkIsBorrowNow() {
        String[] ids = getArchiveIds().split(",");
        StringBuffer message = new StringBuffer();
        List<Criterion> wghlist = new ArrayList<Criterion>();

        for (String archiveId : ids) {
            wghlist.add(Restrictions.eq("archiveId", archiveId)); //锁定一类唯一档案
            wghlist.add(Restrictions.eq("state", 0)); //未归还类型的

            Page wghPage = entityService.search(Loan.class, wghlist, null, 0, -1);

            List<Loan> wghLists = wghPage.getItems(); //查询所有该类未归还借阅档案记录

            if (wghLists.size() == 0) {
//                message.append(true);
            } else {
                //不是当前借阅用户的不能够进入借阅登记页面
                Archive archive = archiveService.getSimpleArchive(archiveId);
                message.append("全宗号为" + archive.getQzh() + "目录号为" + archive.getMlh() + "案卷号为" + archive.getAjh() + "的档案已被借阅，未归还,请等待归还后再登记！").append("\n");
            }
        }
        Struts2Utils.renderJson(message.toString());
    }

    /**
     * 验证是否重复添加到借阅车
     */
    public void checkIsAddTwo(){
        String[] ids = archiveIds.split(",");
        List<Criterion> lists = null;
        String message = "";
        for(String id:ids){
            lists = new ArrayList<Criterion>();
            lists.add(Restrictions.eq("archiveId", id.trim())); //锁定一类唯一档案
            lists.add(Restrictions.eq("userId", SessionUtil.getCurrentUserId()));

            Page wghPage = entityService.search(LoanCart.class, lists, null, 0, -1);

            List<LoanCart> addLists = wghPage.getItems(); //查询所有该类未归还借阅档案记录
            if(addLists.size()>0){
                Archive archive = archiveService.getSimpleArchive(addLists.get(0).getArchiveId());
                message="全宗号为" + archive.getQzh() + "目录号为" + archive.getMlh() + "案卷号为" + archive.getAjh() + "的档案不可被重复添加借阅车！";
                break;
            }
        }
        renderJson(message);
    }
}
