package com.gtis.archive.web;

import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.support.hibernate.UUIDHexGenerator;
import com.gtis.archive.core.web.BaseEntityAction;
import com.gtis.archive.entity.AjhRange;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.RecordAjhRange;
import com.gtis.archive.service.AjhRangeService;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.RecordAjhRangeService;
import com.gtis.archive.service.ResourceService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.WrongClassException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-10-13
 */
public class ArchiveEntityAction extends BaseEntityAction<Archive> {
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private AjhRangeService ajhRangeService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SysUserService userService;

    @Autowired
    private RecordAjhRangeService recordAjhRangeService;


    private String treeId;
    private AjhRange ajhRange;
    public Integer _ajh;
    public boolean gd;

    private String template;

    private List<String> mlhs;//江阴目录号列表


    private String currentMlh;

    private Integer currentAjh;

    private String mlh;//用户江阴目录号下拉框改变时同时改变案卷号

    private String bgqx;//保管期限

    private boolean  add; //新增档案自动赋值目录号案卷号，其他值为空

    private String state;

    public String getState() {
        if(StringUtils.isBlank(state))
            return "";
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setAjhRange(AjhRange ajhRange) {
        this.ajhRange = ajhRange;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setGd(boolean gd) {
        this.gd = gd;
    }

    public AjhRange getAjhRange() {
        return ajhRange;
    }

    public String getTreeId() {
        return treeId;
    }

    public String getBgqx() {
        return bgqx;
    }

    public void setBgqx(String bgqx) {
        this.bgqx = bgqx;
    }

    public boolean isAdd() {
        return add;
    }

    public void setAdd(boolean add) {
        this.add = add;
    }
    /**
     * 是否处于档案补录状态
     */
    private boolean isMakeUp;

    public boolean isMakeUp() {
        return isMakeUp;
    }

    public void setMakeUp(boolean makeUp) {
        isMakeUp = makeUp;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getCurrentMlh() {
        return entity.getMlh();
    }

    public Integer getCurrentAjh() {
        return entity.getAjh();
    }

    @Override
    public void prepare() {
        boolean isCreate = StringUtils.isBlank(id);
        if (isCreate) {
            entity = archiveService.newArchive(modelName);
            String cid = (String) session.get("currentAId");
            Archive lastArchive = null;
            if (cid != null) {
                lastArchive = archiveService.getArchive(modelName, cid);
            }
            if (lastArchive != null&&lastArchive.getModelName().equals(modelName)) {
                try {
                    if(!add){
                        PropertyUtils.copyProperties(entity, lastArchive);
                    }else if(EnvHolder.isEnable(Switch.JIANGYIN)){
                        entity.setDwdm(getDwdm());
                        entity.setQzh(getQzh());
                    }
                } catch (Exception ignored) {
                }
                entity.setDh(null);
            }else if(EnvHolder.isEnable(Switch.JIANGYIN)) {
                entity.setDwdm(getDwdm());
                entity.setQzh(getQzh());
            }
            entity.setId(UUIDHexGenerator.generate());
            if (StringUtils.isNotBlank(treeId)) {
//                String flh = resourceService.getResource(treeId).getContent();
                String flh = resourceService.getResource(treeId).getFlh();
                if (StringUtils.isNotBlank(flh))
                        entity.setFlh(flh);
            }
        } else {
            //未严格测试
            List<Criterion> criterions = new ArrayList<Criterion>();
            criterions.add(Restrictions.eq("id", id));
//            Page<Archive> page = archiveService.searchArchive(modelName, criterions, null, 0, 1);
            Page<Archive> page = archiveService.searchArchive(modelName, criterions, null,null, 0, 1);
            if(page.getItems().size()==1)
                entity=page.getItem(0);
//            entity = archiveService.getArchive(modelName, id);
            if (entity == null) {
                entity = archiveService.newArchive(modelName);
//                }
            }
        }
        /**
         * 两种情况：
         * 1、开启案卷自增业务时所有业务模型均可案卷号自增
         * 2、关闭案卷号自增业务时，字典【increaseAjhModel】配置的业务模型可以自增案卷号
         */
        if ((isCreate && EnvHolder.isEnable(Switch.INCREASE_AJH)) || (isCreate && getEnableIncreaseAjhModel(modelName))) {
            ajhRange = getAvailableAjhRange();
            entity.setMlh(ajhRange.getMlh());
            if(EnvHolder.isEnable(Switch.JIANGYIN)){ //江阴，根据该目录号先查找改目录号是否存在之前已删除的案卷号
                String dwdm=ajhRange.getDwdm();
                if(StringUtils.isBlank(dwdm))
                    dwdm=getDwdm();
                RecordAjhRange recordAjhRange=recordAjhRangeService.getAvailable(ajhRange.getMlh(),modelName,dwdm);
                if(recordAjhRange!=null){
                    entity.setAjh(recordAjhRange.getAjh());
                }else {
                    entity.setAjh(ajhRange.getNextValue());
                }
            }else{
                entity.setAjh(ajhRange.getNextValue());
            }
            if(EnvHolder.isEnable(Switch.JIANGYIN))
                entity.setBgqx(ajhRange.getBgqx());
        }
    }

    @Override
    protected void preSave() {
        if (ajhRange != null && StringUtils.isNotBlank(ajhRange.getId()) && entity.getAjh()!=null && entity.getAjh() == ajhRange.getNextValue()) {//如果相等，说明用户未修改ajh，取出当前可用案卷号赋值
             //此处添加案卷号重复验证存在这样的情况，在用户可能会手动修改案卷号的当前值，比如当前值为23时，手动修改当前值为20，会造成21,22重复
            ajhRange = ajhRangeService.getAjhRange(ajhRange.getId());
            ajhRange=checkAjh(ajhRange,entity.getQzh(),entity.getMlh(),entity.getAjh(),entity.getId());
            _ajh = ajhRange.getNextValue();
            entity.setAjh(_ajh);
        } else {
            List<Criterion> criterions = new ArrayList<Criterion>();
            criterions.add(Restrictions.eq("qzh", entity.getQzh()));
            criterions.add(Restrictions.eq("mlh", entity.getMlh()));
            criterions.add(Restrictions.eq("ajh", entity.getAjh()));
            Page<Archive> page;
            try{
                page = archiveService.searchArchive(modelName, criterions, null, 0, 1);
            }catch (WrongClassException wrongClassException){
                page=archiveService.searchArchive("Archive", criterions, null, 0, 1);
            }

            if (!page.isEmpty() && !page.getItem(0).getId().equals(entity.getId())) {
                if (!EnvHolder.isEnable(Switch.BENG_BU) && !isMakeUp) {
                    throw new RuntimeException("此案卷号已被使用占用案卷编号【"+page.getItem(0).getId()+"】");
                }
                if(EnvHolder.isEnable(Switch.JIN_TAN) && isMakeUp){
                    logger.debug("档案补录，插入案卷号");
                    makeUpArchive();
                }
            }
        }
        if (StringUtils.isNotBlank(treeId)) {
            entity.setResourceId(treeId);
        }
        if(entity.getAjh()!=null && entity.getMlh()!=null)
        {   AjhRange preAjhRange;
            if(ajhRange!=null){ //说明添加操作，要获取可用案卷号
                preAjhRange = ajhRangeService.getAvailableAjhRange(modelName,entity.getMlh());
            }else {    //编辑操作，不对案卷号做可用判断
                preAjhRange = ajhRangeService.getAjhRangeAvailable(modelName,entity.getMlh(),StringUtils.isBlank(entity.getDwdm())?getDwdm():entity.getDwdm());
                ajhRange=preAjhRange;
            }
            //获得当前目录号的案卷号范围
            /**List<AjhRange> listAjh =  ajhRangeService.getAjhRangeByModelName(modelName);
            for (AjhRange ajh : listAjh) {
                if (entity.getMlh().equals(ajh.getMlh())) {
                    preAjhRange = ajh;
                }
            }**/
            //如果当前案卷号大于当前最大可用案卷号或者是小于当前最小可用案卷号，则给出提示！
            if(preAjhRange!=null){
                if(entity.getAjh()>preAjhRange.getMaxValue())
                    throw new RuntimeException("案卷号不能大于当前最大案卷号");
                if(entity.getAjh()<preAjhRange.getMinValue())
                    throw new RuntimeException("案卷号不能小于当前最小案卷号");
            }
        }

        if (gd) {
            ajhRange = ajhRangeService.getAvailableAjhRange(modelName);
            if (entity.getAjh() > ajhRange.getNextValue()) {
                throw new RuntimeException("不能大于当前最大案卷号");
            }
            entity.setGdsj(new Date());
            entity.setState(Archive.STATE_YGD);
        }
        entity.setDh(null);
    }

    /**
     * 档案补录
     */
    private void makeUpArchive(){
        try{
            List<Criterion> criterions = new ArrayList<Criterion>();
            criterions.add(Restrictions.eq("mlh", entity.getMlh()));
            criterions.add(Restrictions.ge("ajh", entity.getAjh()));
            List<Order> orders = new ArrayList<Order>();
            orders.add(Order.asc("ajh"));
            List<AjhRange> ajhRanges = ajhRangeService.getAjhRangeByModelName(modelName);
            for(AjhRange range : ajhRanges){
                if(range.getMlh().equalsIgnoreCase(entity.getMlh())) {
                    ajhRange = range;
                    break;
                }
            }
            Page<Archive> pages = archiveService.searchArchive(modelName, criterions, orders, 0, ajhRange.getMaxValue());
            for (int i = pages.getTotalCount(); i>0; i--){
                Archive archive = pages.getItem(i-1);
                archive.setAjh(archive.getAjh().intValue()+1);
                archive.setDh(null);
                if(archive.getAjh()>ajhRange.getMaxValue()) {
                    throw new RuntimeException("档案移动后将会超出目录最大容量，请先扩充目录号【{"+archive.getMlh()+"}】容量");
                }
                archiveService.saveArchive(archive);
            }
        }catch(Exception ex){
            logger.error("档案补录异常【{}】,确认目录号【{}】已配置",ex.getLocalizedMessage(),entity.getMlh());
            throw new RuntimeException("档案补录异常,确认目录号【"+entity.getMlh()+"】已配置");
        }
    }

    public String bl() throws Exception {
        return renderModelTemplate("bl");
    }

    /**
     * render template
     * @return
     * @throws Exception
     */
    public String render() throws Exception {
        return renderModelTemplate(template);
    }

    @Override
    protected void doSave(Archive entity) {
        archiveService.saveArchive(entity);
    }

    @Override
    protected void afterSave() {
        if(EnvHolder.isEnable(Switch.JIANGYIN)){ //当使用recordAjhRange时要将那条记录删除 ,不更新AjhRange
           String id= recordAjhRangeService.removeHasUsed(entity.getMlh(),entity.getModelName(),entity.getDwdm(),entity.getBgqx(),entity.getAjh());
            if(StringUtils.isNotBlank(id)){
                recordAjhRangeService.remove(id);
            } else{
                if (_ajh != null) {
                    ajhRange.setCurrentValue(_ajh);
                    ajhRangeService.saveAjhRange(ajhRange);
                }
            }

        }else {
            if (_ajh != null) {
                ajhRange.setCurrentValue(_ajh);
                ajhRangeService.saveAjhRange(ajhRange);
            }
        }
        session.put("currentAId", entity.getId());
    }

    /**
     * 获取可用的案卷号
     * @return
     */
    private AjhRange getAvailableAjhRange(){
        if(entity.getMlh()!=null)
            try{
                return ajhRangeService.getAvailableAjhRange(modelName,entity.getMlh());
            }catch (Exception ex){
                return ajhRangeService.getAvailableAjhRange(modelName);
            }
        else
            return ajhRangeService.getAvailableAjhRange(modelName);
    }

    @Override
    protected String getSuccessMsg() {
        return entity==null?super.getSuccessMsg():entity.getId();
    }

    @Override
    protected String getJsCallBack() {
        return "onArchiveComplete";
    }



    /**
     * 获取全宗号
     *
     * @return
     */
    private String getQzh() {
        String qzh = "";
        String dwdm = getDwdm();
        try {
            List<Item> items = dictService.getItems(Constants.QZH_DWDM);
            for (Item item : items) {
                if (dwdm.equals(item.getName())) {
                    qzh = item.getValue();
                    break;
                }
            }
        } catch (Exception ex) {
            logger.info("未配置[{}]单位代码全宗号字典项", Constants.QZH_DWDM);
        }
        return qzh;
    }


    /**
     * 获取当前用户的单位代码
     *
     * @return
     */
    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }


    public String reSetAjh(){
        try{
            ajhRange=ajhRangeService.getAvailableAjhRange(modelName,mlh);
            entity.setMlh(mlh);
            entity.setAjh(ajhRange.getNextValue());
            renderJson(ajhRange.getNextValue()+","+ajhRange.getId()+","+ajhRange.getCurrentValue()+","+ajhRange.getBgqx());
        }catch (Exception ex){
            renderJson("该目录案卷号已用完");
        }

        return null;
    }

    public String reSetMlh(){
        try{
            String dwdm=entity.getDwdm();
            if(StringUtils.isBlank(dwdm))
                dwdm=getDwdm();
            ajhRange=ajhRangeService.getAjhRangesByBgqx(modelName,bgqx,dwdm);
            RecordAjhRange recordAjhRange =recordAjhRangeService.getRecordAjhRange(ajhRange.getMlh(),modelName,dwdm,bgqx);
            entity.setMlh(ajhRange.getMlh());
            int tempAjh=ajhRange.getNextValue();
            if(recordAjhRange!=null){
                entity.setAjh(recordAjhRange.getAjh());
                tempAjh=recordAjhRange.getAjh();
            }else{
                entity.setAjh(ajhRange.getNextValue());
            }
            renderJson(tempAjh+","+ajhRange.getId()+","+ajhRange.getCurrentValue()+","+ajhRange.getMlh());
        }catch (Exception ex){
            renderJson(ex.getMessage());
        }
        return null;
    }

    public String getMlh() {
        return mlh;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public List<String> getMlhs() {
        if(template==null){
            return ajhRangeService.getMlhByModelName(modelName);
        }else {
            return ajhRangeService.getMlh(modelName,entity.getDwdm());
        }
    }

    /**
     * 验证当前案卷号是否重复
     * @param ajhRange
     * @param qzh 全宗号
     * @param mlh 目录号
     * @param ajh 案卷号
     * @return
     */
    private AjhRange checkAjh(AjhRange ajhRange , String qzh , String mlh ,int ajh ,String id){
        List<Criterion> list=new ArrayList<Criterion>();
        list.add(Restrictions.eq("qzh",qzh));
        list.add(Restrictions.eq("mlh",mlh));
        list.add(Restrictions.eq("ajh",ajh));
        Page<Archive> archivePage;
        try{
            archivePage = archiveService.searchArchive(modelName, list, null, 0, 1);
        }catch (WrongClassException wrongClassException){
            archivePage = archiveService.searchArchive("Archive", list, null, 0, 1);
        }
        //数据库中一存在该目录号案卷号的记录,当前值重新验证
        if (!archivePage.isEmpty() && !archivePage.getItem(0).getId().equals(id)) {
            ajhRange.setCurrentValue(ajh);
            ajhRangeService.saveAjhRange(ajhRange);
            ajhRange=checkAjh(ajhRange,qzh,mlh,ajhRange.getCurrentValue()+1,id);
        }

        return ajhRange;
    }

    /**
     * 获取在关闭案卷号自增配置（increaseAjh.enable=false），允许自增的业务模型
     * @param modelName
     * @return
     */
    private boolean getEnableIncreaseAjhModel(String modelName){
        try {
            List<Item> items = dictService.getItems("increaseAjhModel");
            for(Item item : items){
                if(item.getValue().equals(modelName)){
                    return true;
                }
            }
        }catch (Exception ex){
            logger.error("没有字典【increaseAjhModel】" + ex.toString());
            return false;
        }
        return false;
    }
}