package com.gtis.archive.util;

import java.io.*;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterOutputStream;

import com.thoughtworks.xstream.io.binary.BinaryStreamReader;
import javassist.bytecode.ByteArray;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

/**
 * Created by Administrator on 15-1-19.
 */
public class Base64Utils {
    /**
     * 对文件二进制流进行编码
     * @param file 需要编码的文件
     * @return 对文件进行base64编码后的字符串
     * @throws Exception
     */
    public static String file2StringOfBinary(File file) throws Exception{
        StringBuffer sb = new StringBuffer();
        FileInputStream in = new FileInputStream(file);
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(in));
        byte[] bytes = new byte[dataInputStream.available()];

        dataInputStream.readFully(bytes);

        in.close();
        dataInputStream.close();

        //使用base64编码
        String newString = compressDataOfBinary(bytes);

        return newString;
    }

    /**
     * 对文件进行编码
     * @param file 需要编码的文件
     * @return 对文件进行base64编码后的字符串
     * @throws Exception
     */
    public static String file2String(File file) throws Exception{
        StringBuffer sb = new StringBuffer();
        FileInputStream in = new FileInputStream(file);

        int b;
        char ch;
        while((b=in.read())!=-1){
            ch = (char)b;
            sb.append(ch);
        }
        in.close();
        //将buffer转化为string
        String oldString = new String(sb);

        //使用base64编码
        String newString = compressData(oldString);

        return newString;
    }

    /**
     * 对文件进行解码
     * @param oldString 需要解码的字符串
     * @param filePath  将字符串解码到filepath文件路径
     * @return  返回解码后得到的文件
     * @throws Exception
     */
    public static File string2File(String oldString,String filePath) throws Exception{
        File file = new File(filePath);
        if(file.exists()){
            System.out.println("文件已经存在，不能将base64编码转换为文件");
            return null;
        }else{
            file.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(file);

        //对oldString进行解码
        String newString = decompressData(oldString);

        //将问件内容转为byte[]
        char[] str = newString.toCharArray();
        for(char ch:str){
            byte b = (byte)ch;
            out.write(b);
        }
        out.close();
        return file;
    }

    /**
     * 使用base64编码字符串
     * @param data
     * @return 编码后的字符串
     */
    public static String compressData(String data) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DeflaterOutputStream zos = new DeflaterOutputStream(bos);
            zos.write(data.getBytes());
            zos.close();
            return new String(getenBASE64inCodec(bos.toByteArray()));
        } catch (Exception ex) {
            ex.printStackTrace();
            return "ZIP_ERR";
        }
    }

    /**
     * 使用base64编码字符串
     * @param data
     * @return 编码后的字符串
     */
    public static String compressDataOfBinary(byte[] data) {
        try {
            return new String(getenBASE64inCodecOfBinary(data));
        } catch (Exception ex) {
            ex.printStackTrace();
            return "ZIP_ERR";
        }
    }

    /**
     * 使用base64解码字符串
     * @param encdata
     * @return 解码后的字符串
     */
    public static String decompressData(String encdata) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            InflaterOutputStream zos = new InflaterOutputStream(bos);
            zos.write(getdeBASE64inCodec(encdata));
            zos.close();
            return new String(bos.toByteArray());
        } catch (Exception ex) {
            ex.printStackTrace();
            return "UNZIP_ERR";
        }
    }


    /**
     * 调用apache的编码方法
     */
    public static String getenBASE64inCodec(byte [] b) {
        if (b == null)
            return null;
        return new String((new Base64()).encode(b));
    }

    /**
     * 调用apache的编码方法
     */
    public static String getenBASE64inCodecOfBinary(byte[] data) {
        if (data == null)
            return null;
        return new String(new Base64().encodeBase64(data,false));
    }


    /**
     * 调用apache的解码方法
     */
    public static byte[] getdeBASE64inCodec(String s) {
        if (s == null)
            return null;
        return new Base64().decode(s.getBytes());
    }
}
