package com.gtis.archive.service;

import java.util.List;
import java.util.Map;

/**
 * ExtTreeService interface.
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-9-17
 */
public interface ExtTreeService {
    /**
     * get tree by  resourceId
     *
     * @param resourceId resourceId
     * @return tree
     */
    List<Map<String, Object>> getTree(String resourceId);

    /**
     * get tree by  resourceId and names
     *
     * @param resourceId resourceId
     * @param name       name
     * @return tree
     */
    List<Map<String, Object>> getTree(String resourceId, String... name);

    /**
     * 获取所有列表不做验证
     * @param resourceId
     * @param name
     * @return
     */
    List<Map<String,Object>> getAllTree(String resourceId,String... name);


    /**
     * 通用管理
     * @param resourceId
     * @return
     */
    List<Map<String,Object>> getTree2(String resourceId);


    /**
     * 文档一体化动态判断【增加，修该，删除】按钮的权限，针对有权限的返回true允许显示
     * @param resourceId
     * @param type
     * @return
     */
    String getWDYTHButtonPermission(String resourceId, String type, String modelName);

    boolean getPermisionResult();

    void resetPermision();

}
