package com.gtis.archive.entity;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * Created with IntelliJ IDEA.
 * User: zhangbixi
 * Date: 13-4-17
 * Time: 下午2:13
 * To change this template use File | Settings | File Templates.
 */
@Entity
@Table(name = "t_record_ajh_range")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class RecordAjhRange {
    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String id;


    /**
     * 模型名称
     */
    @Column(length = 100, nullable = false)
    private String modelName;

    /**
     * 目录号
     */
    @Column(length = 100, nullable = false)
    private String mlh;


    /**
     * 案卷号
     */
    @Column(length = 100, nullable = false)
    private int ajh;

    /**
     * 单位代码
     */
    @Column(length=100)
    private String dwdm;

    /**
     * 保管期限
      */
    @Column(length = 100)
    private String bgqx;
    /**
     *登记号
     */
    @Column(length = 100)
    private Integer djh;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }


    public String getModelName() {
        return modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getMlh() {
        return mlh;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public int getAjh() {
        return ajh;
    }

    public void setAjh(int ajh) {
        this.ajh = ajh;
    }

    public String getDwdm() {
        return dwdm;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    public String getBgqx() {
        return bgqx;
    }

    public void setBgqx(String bgqx) {
        this.bgqx = bgqx;
    }
    public Integer getDjh(){return djh;}
    public void setDjh(Integer djh){this.djh=djh;}

}
