package com.gtis.archive.core.web;

import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ValueStack;
import freemarker.template.*;
import org.apache.commons.collections.map.LRUMap;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.views.freemarker.FreemarkerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-12-1
 */
public class FreemarkerRenderSupport{
    private final Logger logger = LoggerFactory.getLogger(getClass());
    private static final Map<String,Template> tplCaches = Collections.synchronizedMap(new LRUMap(500));
    private Configuration configuration;
    private FreemarkerManager freemarkerManager;

    @Inject
    public void setFreemarkerManager(FreemarkerManager mgr) throws TemplateException {
        this.freemarkerManager = mgr;
    }

    protected String renderTemplate(String content) throws TemplateException, IOException {
        configuration = freemarkerManager.getConfiguration(ServletActionContext.getServletContext());
        TemplateModel model = createModel();
        Template template = tplCaches.get(content);
        if (template == null) {
            template = new Template(null, new StringReader(content), configuration);
            tplCaches.put(content, template);
        }
        if (preTemplateProcess(template, model)) {
            try {
                HttpServletResponse response = ServletActionContext.getResponse();
                response.setContentType("text/html;charset=UTF-8");
                template.process(model, response.getWriter());
            } finally {
                postTemplateProcess(template, model);
            }
        }
        return null;
    }

    protected boolean preTemplateProcess(Template template, TemplateModel model) throws IOException {
        return true;
    }

    protected void postTemplateProcess(Template template, TemplateModel data) throws IOException {
    }

    protected TemplateModel createModel() throws TemplateModelException {
        ServletContext servletContext = ServletActionContext.getServletContext();
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        ValueStack stack = ServletActionContext.getContext().getValueStack();
        return freemarkerManager.buildTemplateModel(stack, this, servletContext, request, response, configuration.getObjectWrapper());
    }
}
