package com.gtis.archive.core.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.Field;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.support.hibernate.UUIDHexGenerator;
import com.gtis.archive.entity.Permission;
import com.gtis.archive.service.SecurityService;
import com.gtis.archive.util.SearchUtils;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.util.Md5Util;
import com.gtis.web.SessionUtil;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.*;

/**
 * 模型实体对象集合基础action.
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-12-1
 */
public class BaseModelAction<T> extends BaseAction {
    public static final String DIR_ASC = "asc";
    public static final String DIR_DESC = "desc";
    protected static final Map<String, String[]> idsCaches = Collections.synchronizedMap(new LRUMap(500));
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected EntityService entityService;
    @Autowired
    protected DictService dictService;
    @Autowired
    private SysUserService userService;

    @Autowired
    private SecurityService securityService;
    /**
     * 分页位置
     */
    protected int start = 0;
    /**
     * 分页大小
     */
    protected int limit = Constants.DEFAULT_PAGE_SIZE;
    /**
     * 排序字段
     */
    protected String sort;
    /**
     * 排序方向
     */
    protected String dir;
    /**
     * 模型名
     */
    protected String modelName;
    /**
     * 打印类型
     */
    protected String printType;
    /**
     * 模糊检索关键字
     */
    protected String query;
    /**
     * 高级检索关键字
     */
    protected String condition;

    /**
     * id列表
     */
    protected String[] ids;
    /**
     * 数据
     */
    protected String idsKey;
    /**
     * 实体对象列表
     */
    protected List<T> entities;
    /**
     * 列表要显示的字段
     */
    private Map showFields;
    /**
     * 当前是否为打印状态
     */
    private boolean isPrint;

    /**
     * 修改后的密码
     */
    private String passWord;

    /**
     * 老密码
     */
    private String oldPassWord;

    /**
     * 页面勾选条件进行模糊查询的条件
     */
    private Map conditionMap;

    /**
     *  模糊查询的选择条件
     */
    protected String searchSelectedItem;

    public String getSearchSelectedItem() {
        return searchSelectedItem;
    }

    public void setSearchSelectedItem(String searchSelectedItem) {
        this.searchSelectedItem = searchSelectedItem;
    }


    public BaseModelAction() {
        Type genType = getClass().getGenericSuperclass();
        if (genType instanceof ParameterizedType) {
            Type params = (((ParameterizedType) genType).getActualTypeArguments())[0];
            if (params instanceof Class) {
                setModelName(((Class) params).getSimpleName());
            }
        }
    }

    public Map getConditionMap() {
        String templateStr = "";
        try{
            templateStr = getEntityTemplate("customizeSearchFields");
        }catch (Exception ex){

        }
        String[] configFields = StringUtils.split(templateStr, ",");
        Map<String, Field> fields = getFields();

        if(this.conditionMap==null){
            this.conditionMap = new HashMap();
        }

        if(configFields.length!=0){
            for(String field : configFields){
                if(fields.containsKey(field)){
                    Field value = fields.get(field);
                    conditionMap.put(value.getName(), value.getTitle());
                }
            }
        }else{
            for(Map.Entry<String, Field> field : fields.entrySet()){
                Field value = field.getValue();
                conditionMap.put(value.getName(),value.getTitle());
            }
        }

        return conditionMap;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void setModelName(String modelName) {
        if (modelName.startsWith(Constants.ARCHIVE_PREFIX)) {
            this.modelName = modelName.substring(2);
        } else {
            this.modelName = modelName;
        }
    }

    public void setPrintType(String printType) {
        this.printType = printType;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void setId(String[] ids) {
        this.ids = ids;
    }

    public void setIdsKey(String idsKey) {
        this.idsKey = idsKey;
    }

    public int getLimit() {
        if (limit == Constants.DEFAULT_PAGE_SIZE) {
            String pageSize = getEntityModel().getEnv().get("pageSize");
            if (StringUtils.isNotBlank(pageSize))
                limit = Integer.parseInt(pageSize);
        }
        return limit;
    }

    public String getModelName() {
        return modelName;
    }

    public List<T> getEntities() {
        if (entities == null) {
            entities = getEntityPage().getItems();
            if (modelName.toLowerCase().equals("ythsw") && EnvHolder.isEnable(Switch.JIANGYIN) && isPrint) {
                try {
                    PropertyUtils.setProperty(entities.get(0), "oragn", getRagon());
                } catch (Exception ex) {
                    logger.error(ex.toString());
                }
            }
        }
        return entities;
    }

    /**
     * 获取实体对象模型
     *
     * @return 实体对象模型
     */
    public Model getEntityModel() {
        return modelService.getModel(modelName);
    }

    /**
     * 获取字段列表
     *
     * @return 字段列表
     */
    public Map<String, Field> getFields() {
        return getEntityModel().getInheritfieldsMap();
    }

    public Map getShowFields() {
        if (showFields == null) {
            showFields = JSON.parseObject(getEntityTemplate("showFields"), LinkedHashMap.class);
        }
        return showFields == null ? Collections.emptyMap() : showFields;
    }

    public String getId() {
        return ids == null ? null : ids[0];
    }

    public String list() throws Exception {
        try {
            renderJson(getEntityPage());
        } catch (Exception e) {
//            e.printStackTrace();
            renderJson(new Page());
        }
        return null;
    }

    public String cacheIds() {
        String key = UUIDHexGenerator.generate();
        idsCaches.put(key, ids);
        return renderJson(Collections.singletonMap("idsKey", key));
    }

    public String print() throws Exception {
        isPrint = true;
        return renderTemplate(getEntityModel().getTemplate("print"));
    }

    public String fr3() throws Exception {
        sendFile(getEntityModel().getPrintFr3(printType));
        return null;
    }

    public String export() throws Exception {
        ServletActionContext.getResponse().setContentType("application/vnd.ms-excel");
        ServletActionContext.getResponse().setHeader("Content-Disposition", "attachment; filename=" + modelName + "-export.xls");
        entities = getEntityPage().getItems();
        return renderModelTemplate("export");
    }

    public String remove() throws Exception {
        entityService.remove(modelName, ids);
        return null;
    }

    protected Page<T> getEntityPage() {
        if (StringUtils.isNotEmpty(idsKey)) {
            ids = idsCaches.get(idsKey);
        }
        if (ids != null) {
            entities = new ArrayList<T>(ids.length);
            for (String id : ids) {
                entities.add(entityService.<T>load(modelName, id));
            }
            return new Page<T>(entities);
        }
        List<Criterion> criterions = createCriterions(new ArrayList<Criterion>());
        List<Order> orders = createOrders(new ArrayList<Order>());
        return searchEntity(criterions, orders);
    }

    protected Page<T> searchEntity(List<Criterion> criterions, List<Order> orders) {
        return entityService.search(modelName, criterions, orders, start, limit);
    }

    protected List<Order> createOrders(final ArrayList<Order> orders) {
        if (StringUtils.isNotEmpty(sort)) {
            if (DIR_ASC.equalsIgnoreCase(dir)) {
                orders.add(Order.asc(sort));
            } else {
                orders.add(Order.desc(sort));
            }
        }
        if (orders.isEmpty()) {
            for (Map.Entry<String, String> entry : getOrderFields().entrySet()) {
                orders.add(entry.getValue().equalsIgnoreCase(DIR_ASC) ? Order.asc(entry.getKey()) : Order.desc(entry.getKey()));
            }
        }
        return orders;
    }

    protected List<Criterion> createCriterions(final ArrayList<Criterion> criterions) {
        if (StringUtils.isNotBlank(condition))
            criterions.addAll(SearchUtils.conditionToCriterion(getFields(), condition));
        if (StringUtils.isNotBlank(query)) {
            String[] fields = null;
            if(StringUtils.isNotBlank(searchSelectedItem)){ //用户自己勾选条件的模糊查询字段
                JSONArray arrays = JSON.parseArray(searchSelectedItem);
                fields = new String[arrays.size()];
                for(int i=0; i<arrays.size(); i++){
                    fields[i]=arrays.get(i).toString();
                }
            }else{ //系统默认配置的模糊查询字段
                fields = getQueryFields();
            }
            if (fields != null) {
                Criterion cr = null;
                for (String field : fields) {
                    cr = cr == null ? Restrictions.like(field, "%" + query + "%") : Restrictions.or(cr, Restrictions.like(field, "%" + query + "%"));
                }
                if (cr != null) {
                    criterions.add(cr);
                }
            }
        }
        return criterions;
    }

    /**
     * 高级查询字段过滤
     */
    public Map<String, Field> getAdvSearchFields() {
        Map<String, Field> allFields = getFields();
        Map<String, Field> fields = new LinkedHashMap<String, Field>();
        try {
            String[] filters = StringUtils.split(getEntityTemplate("advSearchFields"), ",");
            if (filters.length == 0) return fields;
            for (String name : filters) {
                if (allFields.containsKey(name))
                    fields.put(name, allFields.get(name));
            }
        } catch (TemplateNotFoundException e) {
            return allFields;
        }
        return fields;
    }

    /**
     *  文档一体化部分高级查询字段过滤
     *  由之前通用的改动
     *  添加默认的三个检索条件题名，文号，年度
     * @return
     */
    public Map<String, Field> getDefAdvSearchFields() {
        Map<String, Field> allFields = getFields();
        Map<String, Field> fields = new LinkedHashMap<String, Field>();
        List<String> defCondition = Arrays.asList("tm","wh","nd");    //默认的三个条件题名，文号，年度
        try {
            String[] filters = StringUtils.split(getEntityTemplate("advSearchFields"), ",");
            if (filters.length == 0){       //添加默认的三个条件
                for(String name : defCondition){
                    if (allFields.containsKey(name))
                        fields.put(name, allFields.get(name));
                }
                return fields;
            }

            //判断添加的是否含有默认的三个条件，不含有的添加到fields里面
            for(String name : defCondition){
                for(String fname : filters){
                    if(!name.equals(fname)){
                        fields.put(name, allFields.get(name));
                    }
                }

            }

            for (String name : filters) {
                if (allFields.containsKey(name)){
                    fields.put(name, allFields.get(name));
                }
            }
        } catch (TemplateNotFoundException e) {
            return allFields;
        }
        return fields;
    }

    @SuppressWarnings("unchecked")
    protected LinkedHashMap<String, String> getOrderFields() {
        try {
            if (isPrint) {
                isPrint = false;
                return JSON.parseObject(getEntityTemplate("printOrderFields"), LinkedHashMap.class);
            } else
                return JSON.parseObject(getEntityTemplate("orderFields"), LinkedHashMap.class);
        } catch (TemplateNotFoundException ex) {
            return JSON.parseObject(getEntityTemplate("orderFields"), LinkedHashMap.class);
        }
    }

    protected String[] getQueryFields() {
        return StringUtils.split(getEntityTemplate("queryFields"), ",");
    }

    protected String getEntityTemplate(String name) {
        return getEntityModel().getTemplate(name);
    }

    protected String renderModelTemplate(String name) throws Exception {
        return renderTemplate(getEntityTemplate(name));
    }


    //暨办单组织机构
    private String getRagon() {
        String oragn = "";
        String dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
        try {
            List<Item> items = dictService.getItems(Constants.ORAGN);
            for (Item item : items) {
                if (dwdm.equals(item.getName())) {
                    oragn = item.getValue();
                    break;
                }
            }
        } catch (Exception ex) {
            logger.info("未配置[{}]组织机构字典项", Constants.ORAGN);
        }
        return oragn;
    }

    /**
     * 是否是管理员
     *
     * @return
     */
    public boolean isAdmin() {
        return SessionUtil.getCurrentUser().isAdmin();
    }

    public Map<String, Boolean> getSysPerms() {
        HashMap perms = new HashMap<String, Boolean>();
        for (Item item : dictService.getItems(Permission.SYS_FUNCTION_DICT)) {
            if (securityService.isPermitted("sys", item.getName()))
                perms.put(item.getName(), true);
        }
        return perms;
    }

    /**
     * 互查的字典项
     *
     * @return
     */
    public List<Map<String, String>> getAbs() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        List<Item> items = dictService.getItems(Constants.HUCHA_PREFIX + dwdm);
        List<Map<String, String>> abs = new ArrayList<Map<String, String>>();
        for (Item item : items) {
            Map<String, String> map = new HashMap<String, String>();
            map.put("name", item.getName());
            map.put("value", item.getValue());
            map.put("itemId", item.getId());
            abs.add(map);
        }
        return abs;
    }

    public String getUserName() {
        return userService.getUserVo(SessionUtil.getCurrentUserId()).getUserName();
    }


    public String changePassword() {
        String mssg = "";
        String oldPd = userService.getUserVo(SessionUtil.getCurrentUserId()).getLoginPassWord();

        if (!oldPd.equals(Md5Util.Build(oldPassWord))) {
            mssg = "{result: \"failed\",mssg: \"当前密码不正确!\"}";
        } else {
            if (userService.savePassWord(SessionUtil.getCurrentUserId(), passWord)) {
                mssg = "{result: \"success\",mssg: \"保存成功!\"}";
            } else {
                mssg = "{result: \"failed\",mssg: \"保存失败!\"}";
            }
        }
        Struts2Utils.renderJson(mssg);
        return null;
    }

    public String getPassWord() {
        return passWord;
    }

    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    public String getOldPassWord() {
        return oldPassWord;
    }

    public void setOldPassWord(String oldPassWord) {
        this.oldPassWord = oldPassWord;
    }

}
